/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.tl1.device.impl;

import com.google.common.annotations.Beta;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;

@Beta
public class Tl1DeviceConfig
extends Config<DeviceId> {
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{IP, PORT, USERNAME, PASSWORD}) && this.ip() != null;
    }

    public IpAddress ip() {
        return IpAddress.valueOf((String)this.get(IP, (String)this.extractIpPort().getKey()));
    }

    public int port() {
        return this.get(PORT, (Integer)this.extractIpPort().getValue());
    }

    public String username() {
        return this.get(USERNAME, "");
    }

    public String password() {
        return this.get(PASSWORD, "");
    }

    private Pair<String, Integer> extractIpPort() {
        String info = ((DeviceId)this.subject).toString();
        if (info.startsWith("tl1")) {
            String ip = info.substring(info.indexOf(":") + 1, info.lastIndexOf(":"));
            int port = Integer.parseInt(info.substring(info.lastIndexOf(":") + 1));
            return Pair.of((Object)ip, (Object)port);
        }
        return null;
    }
}

