/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.host.impl;

import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPPacketType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onlab.packet.ipv6.IExtensionHeader;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onlab.packet.ndp.RouterAdvertisement;
import org.onlab.packet.ndp.RouterSolicitation;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HostLocationProvider
extends AbstractProvider
implements HostProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private HostProviderService providerService;
    private final InternalHostProvider processor = new InternalHostProvider();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private ApplicationId appId;
    @Property(name="hostRemovalEnabled", boolValue={true}, label="Enable host removal on port/device down events")
    private boolean hostRemovalEnabled = true;
    @Property(name="useArp", boolValue={true}, label="Enable using ARP for neighbor discovery by the Host Location Provider; default is true")
    private boolean useArp = true;
    @Property(name="useIpv6ND", boolValue={false}, label="Enable using IPv6 Neighbor Discovery by the Host Location Provider; default is false")
    private boolean useIpv6ND = false;
    @Property(name="useDhcp", boolValue={false}, label="Enable using DHCP for neighbor discovery by the Host Location Provider; default is false")
    private boolean useDhcp = false;
    @Property(name="requestInterceptsEnabled", boolValue={true}, label="Enable requesting packet intercepts")
    private boolean requestInterceptsEnabled = true;
    protected ExecutorService eventHandler;
    private static final byte[] SENDER_ADDRESS = IpAddress.valueOf((String)"0.0.0.0").toOctets();

    public HostLocationProvider() {
        super(new ProviderId("of", "org.onosproject.provider.host"));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.appId = this.coreService.registerApplication("org.onosproject.provider.host");
        this.eventHandler = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/host-loc-provider", (String)"event-handler", (Logger)this.log));
        this.providerService = (HostProviderService)this.providerRegistry.register((Provider)this);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.advisor((int)1));
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.modified(context);
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.withdrawIntercepts();
        this.providerRegistry.unregister((Provider)this);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.eventHandler.shutdown();
        this.providerService = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        if (this.requestInterceptsEnabled) {
            this.requestIntercepts();
        } else {
            this.withdrawIntercepts();
        }
    }

    private void requestIntercepts() {
        TrafficSelector arpSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP).build();
        if (this.useArp) {
            this.packetService.requestPackets(arpSelector, PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(arpSelector, PacketPriority.CONTROL, this.appId);
        }
        TrafficSelector ipv6NsSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58).matchIcmpv6Type((byte)-121).build();
        TrafficSelector ipv6NaSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58).matchIcmpv6Type((byte)-120).build();
        if (this.useIpv6ND) {
            this.packetService.requestPackets(ipv6NsSelector, PacketPriority.CONTROL, this.appId);
            this.packetService.requestPackets(ipv6NaSelector, PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(ipv6NsSelector, PacketPriority.CONTROL, this.appId);
            this.packetService.cancelPackets(ipv6NaSelector, PacketPriority.CONTROL, this.appId);
        }
        TrafficSelector dhcpServerSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)67)).build();
        TrafficSelector dhcpClientSelector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpSrc(TpPort.tpPort((int)68)).build();
        if (this.useDhcp) {
            this.packetService.requestPackets(dhcpServerSelector, PacketPriority.CONTROL, this.appId);
            this.packetService.requestPackets(dhcpClientSelector, PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(dhcpServerSelector, PacketPriority.CONTROL, this.appId);
            this.packetService.cancelPackets(dhcpClientSelector, PacketPriority.CONTROL, this.appId);
        }
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        selector.matchEthType(Ethernet.TYPE_IPV6);
        selector.matchIPProtocol((byte)58);
        selector.matchIcmpv6Type((byte)-121);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        selector.matchIcmpv6Type((byte)-120);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"hostRemovalEnabled");
        if (flag == null) {
            this.log.info("Host removal on port/device down events is not configured, using current value of {}", (Object)this.hostRemovalEnabled);
        } else {
            this.hostRemovalEnabled = flag;
            this.log.info("Configured. Host removal on port/device down events is {}", (Object)(this.hostRemovalEnabled ? "enabled" : "disabled"));
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"useArp");
        if (flag == null) {
            this.log.info("Using ARP is not configured, using current value of {}", (Object)this.useArp);
        } else {
            this.useArp = flag;
            this.log.info("Configured. Using ARP is {}", (Object)(this.useArp ? "enabled" : "disabled"));
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"useIpv6ND");
        if (flag == null) {
            this.log.info("Using IPv6 Neighbor Discovery is not configured, using current value of {}", (Object)this.useIpv6ND);
        } else {
            this.useIpv6ND = flag;
            this.log.info("Configured. Using IPv6 Neighbor Discovery is {}", (Object)(this.useIpv6ND ? "enabled" : "disabled"));
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"useDhcp");
        if (flag == null) {
            this.log.info("Using DHCP is not configured, using current value of {}", (Object)this.useDhcp);
        } else {
            this.useDhcp = flag;
            this.log.info("Configured. Using DHCP is {}", (Object)(this.useDhcp ? "enabled" : "disabled"));
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"requestInterceptsEnabled");
        if (flag == null) {
            this.log.info("Request intercepts is not configured, using current value of {}", (Object)this.requestInterceptsEnabled);
        } else {
            this.requestInterceptsEnabled = flag;
            this.log.info("Configured. Request intercepts is {}", (Object)(this.requestInterceptsEnabled ? "enabled" : "disabled"));
        }
    }

    public void triggerProbe(Host host) {
    }

    private void sendProbe(Host host, IpAddress targetIp) {
        Ethernet probePacket = null;
        if (targetIp.isIp4()) {
            probePacket = this.buildArpRequest(targetIp, host);
        } else {
            this.log.info("Triggering probe on device {} ", (Object)host);
        }
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(host.location().port()).build();
        DefaultOutboundPacket outboundPacket = new DefaultOutboundPacket(host.location().deviceId(), treatment, ByteBuffer.wrap(probePacket.serialize()));
        this.packetService.emit((OutboundPacket)outboundPacket);
    }

    private Ethernet buildArpRequest(IpAddress targetIp, Host host) {
        ARP arp = new ARP();
        arp.setHardwareType((short)1).setHardwareAddressLength((byte)6).setProtocolType((short)2048).setProtocolAddressLength((byte)4).setOpCode((short)1);
        arp.setSenderHardwareAddress(MacAddress.BROADCAST.toBytes()).setSenderProtocolAddress(SENDER_ADDRESS).setTargetHardwareAddress(MacAddress.BROADCAST.toBytes()).setTargetProtocolAddress(targetIp.toOctets());
        Ethernet ethernet = new Ethernet();
        ethernet.setEtherType(Ethernet.TYPE_ARP).setDestinationMACAddress(MacAddress.BROADCAST).setSourceMACAddress(MacAddress.BROADCAST).setPayload((IPacket)arp);
        ethernet.setPad(true);
        return ethernet;
    }

    private void removeHosts(Set<Host> hosts) {
        for (Host host : hosts) {
            this.providerService.hostVanished(host.id());
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.providerRegistry = hostProviderRegistry;
    }

    protected void unbindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.providerRegistry == hostProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            HostLocationProvider.this.eventHandler.execute(() -> this.handleEvent(event));
        }

        private void handleEvent(DeviceEvent event) {
            Device device = (Device)event.subject();
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: {
                    break;
                }
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (!HostLocationProvider.this.hostRemovalEnabled || HostLocationProvider.this.deviceService.isAvailable(device.id())) break;
                    HostLocationProvider.this.removeHosts(HostLocationProvider.this.hostService.getConnectedHosts(device.id()));
                    break;
                }
                case DEVICE_SUSPENDED: 
                case DEVICE_UPDATED: {
                    break;
                }
                case DEVICE_REMOVED: {
                    if (!HostLocationProvider.this.hostRemovalEnabled) break;
                    HostLocationProvider.this.removeHosts(HostLocationProvider.this.hostService.getConnectedHosts(device.id()));
                    break;
                }
                case PORT_ADDED: {
                    break;
                }
                case PORT_UPDATED: {
                    if (!HostLocationProvider.this.hostRemovalEnabled) break;
                    ConnectPoint point = new ConnectPoint((ElementId)device.id(), event.port().number());
                    HostLocationProvider.this.removeHosts(HostLocationProvider.this.hostService.getConnectedHosts(point));
                    break;
                }
                case PORT_REMOVED: {
                    break;
                }
            }
        }
    }

    private class InternalHostProvider
    implements PacketProcessor {
        private InternalHostProvider() {
        }

        private void updateLocation(HostId hid, MacAddress mac, VlanId vlan, HostLocation hloc) {
            DefaultHostDescription desc = new DefaultHostDescription(mac, vlan, hloc, new SparseAnnotations[0]);
            try {
                HostLocationProvider.this.providerService.hostDetected(hid, (HostDescription)desc, false);
            }
            catch (IllegalStateException e) {
                HostLocationProvider.this.log.debug("Host {} suppressed", (Object)hid);
            }
        }

        private void updateLocationIP(HostId hid, MacAddress mac, VlanId vlan, HostLocation hloc, IpAddress ip) {
            DefaultHostDescription desc = ip.isZero() || ip.isSelfAssigned() ? new DefaultHostDescription(mac, vlan, hloc, new SparseAnnotations[0]) : new DefaultHostDescription(mac, vlan, hloc, ip, new SparseAnnotations[0]);
            try {
                HostLocationProvider.this.providerService.hostDetected(hid, (HostDescription)desc, false);
            }
            catch (IllegalStateException e) {
                HostLocationProvider.this.log.debug("Host {} suppressed", (Object)hid);
            }
        }

        private void updateIp(HostId hid, IpAddress ip) {
            Host host = HostLocationProvider.this.hostService.getHost(hid);
            if (host == null) {
                HostLocationProvider.this.log.debug("Fail to update IP for {}. Host does not exist");
                return;
            }
            DefaultHostDescription desc = new DefaultHostDescription(hid.mac(), hid.vlanId(), host.location(), ip, new SparseAnnotations[0]);
            try {
                HostLocationProvider.this.providerService.hostDetected(hid, (HostDescription)desc, false);
            }
            catch (IllegalStateException e) {
                HostLocationProvider.this.log.debug("Host {} suppressed", (Object)hid);
            }
        }

        public void process(PacketContext context) {
            if (context == null) {
                return;
            }
            Ethernet eth = context.inPacket().parsed();
            if (eth == null) {
                return;
            }
            MacAddress srcMac = eth.getSourceMAC();
            if (srcMac.isBroadcast() || srcMac.isMulticast()) {
                return;
            }
            VlanId vlan = VlanId.vlanId((short)eth.getVlanID());
            ConnectPoint heardOn = context.inPacket().receivedFrom();
            if (heardOn.port().isLogical()) {
                return;
            }
            Topology topology = HostLocationProvider.this.topologyService.currentTopology();
            if (HostLocationProvider.this.topologyService.isInfrastructure(topology, heardOn)) {
                return;
            }
            HostLocation hloc = new HostLocation(heardOn, System.currentTimeMillis());
            HostId hid = HostId.hostId((MacAddress)eth.getSourceMAC(), (VlanId)vlan);
            if (eth.getEtherType() == Ethernet.TYPE_ARP) {
                ARP arp = (ARP)eth.getPayload();
                IpAddress ip = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])arp.getSenderProtocolAddress());
                this.updateLocationIP(hid, srcMac, vlan, hloc, ip);
            } else if (eth.getEtherType() == Ethernet.TYPE_IPV4) {
                DHCP dhcp;
                IPacket pkt = eth.getPayload();
                if (pkt != null && pkt instanceof IPv4 && (pkt = pkt.getPayload()) != null && pkt instanceof UDP && (pkt = pkt.getPayload()) != null && pkt instanceof DHCP && (dhcp = (DHCP)pkt).getOptions().stream().anyMatch(dhcpOption -> dhcpOption.getCode() == DHCP.DHCPOptionCode.OptionCode_MessageType.getValue() && dhcpOption.getLength() == 1 && dhcpOption.getData()[0] == DHCPPacketType.DHCPACK.getValue())) {
                    MacAddress hostMac = MacAddress.valueOf((byte[])dhcp.getClientHardwareAddress());
                    VlanId hostVlan = VlanId.vlanId((short)eth.getVlanID());
                    HostId hostId = HostId.hostId((MacAddress)hostMac, (VlanId)hostVlan);
                    this.updateIp(hostId, IpAddress.valueOf((int)dhcp.getYourIPAddress()));
                }
                this.updateLocation(hid, srcMac, vlan, hloc);
            } else if (eth.getEtherType() == Ethernet.TYPE_IPV6) {
                IPv6 ipv6 = (IPv6)eth.getPayload();
                IpAddress ip = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])ipv6.getSourceAddress());
                IPv6 pkt = ipv6;
                while (pkt.getPayload() != null && pkt.getPayload() instanceof IExtensionHeader) {
                    pkt = pkt.getPayload();
                }
                if ((pkt = pkt.getPayload()) != null && pkt instanceof ICMP6) {
                    if ((pkt = pkt.getPayload()) != null && (pkt instanceof RouterAdvertisement || pkt instanceof RouterSolicitation)) {
                        return;
                    }
                    if (pkt != null && (pkt instanceof NeighborSolicitation || pkt instanceof NeighborAdvertisement)) {
                        if (ip.isZero()) {
                            return;
                        }
                        this.updateLocationIP(hid, srcMac, vlan, hloc, ip);
                        return;
                    }
                }
                if (eth.isMulticast()) {
                    return;
                }
                this.updateLocation(hid, srcMac, vlan, hloc);
            }
        }
    }
}

