/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.yang.compiler.api.YangCompilationParam;
import org.onosproject.yang.compiler.api.YangCompilerService;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.runtime.DefaultModelRegistrationParam;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.onosproject.yang.runtime.helperutils.YangApacheUtils;

@Path(value="live-compiler")
public class YangWebResource
extends AbstractWebResource {
    private static final String YANG_FILE_EXTENSION = ".yang";
    private static final String SER_FILE_EXTENSION = ".ser";
    private static final String REGISTER = "register";
    private static final String UNREGISTER = "unregister";
    private static final String CODE_GEN_DIR = "target/generated-sources/";
    private static final String META_DATA_DIR = "target/yang/resources/";
    private static final String SERIALIZED_FILE_NAME = "YangMetaData.ser";
    private static final String UNKNOWN_KEY = "Key must be either register or unregister.";

    @Path(value="upload")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response upload(FormDataMultiPart formData) throws IOException {
        Map input = this.parseInputData(formData);
        for (Map.Entry entry : input.entrySet()) {
            YangIoUtils.deleteDirectory((String)CODE_GEN_DIR);
            YangIoUtils.deleteDirectory((String)META_DATA_DIR);
            YangCompilerService liveCompiler = (YangCompilerService)this.get(YangCompilerService.class);
            liveCompiler.compileYangFiles(this.createCompilationParam((List)entry.getValue()));
            YangModelRegistry modelRegistry = (YangModelRegistry)this.get(YangModelRegistry.class);
            String key = (String)entry.getKey();
            if (key.equalsIgnoreCase(REGISTER)) {
                modelRegistry.registerModel(this.getModelRegParam());
                continue;
            }
            if (key.equalsIgnoreCase(UNREGISTER)) {
                modelRegistry.unregisterModel(this.getModelRegParam());
                continue;
            }
            return Response.serverError().entity((Object)UNKNOWN_KEY).build();
        }
        return Response.status((int)200).build();
    }

    private File getInputFile(InputStream stream, String fileName) throws IOException {
        byte[] content = IOUtils.toByteArray((InputStream)stream);
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fop = new FileOutputStream(file);
        fop.write(content);
        fop.flush();
        fop.close();
        return file;
    }

    private Map<String, List<File>> parseInputData(FormDataMultiPart formData) throws IOException {
        HashMap<String, List<File>> input = new HashMap<String, List<File>>();
        Map fieldsByName = formData.getFields();
        for (Map.Entry entry : fieldsByName.entrySet()) {
            LinkedList<File> inputFiles = new LinkedList<File>();
            for (FormDataBodyPart field : (List)entry.getValue()) {
                InputStream stream = (InputStream)field.getEntityAs(InputStream.class);
                FormDataContentDisposition content = field.getFormDataContentDisposition();
                String fileName = content.getFileName();
                inputFiles.add(this.getInputFile(stream, fileName));
            }
            input.put((String)entry.getKey(), (List<File>)inputFiles);
        }
        return input;
    }

    private YangCompilationParam createCompilationParam(List<File> inputFiles) throws IOException {
        return null;
    }

    private ModelRegistrationParam getModelRegParam() throws IOException {
        String metaPath = "target/yang/resources/YangMetaData.ser";
        List curNodes = this.getYangNodes(metaPath);
        if (curNodes != null && !curNodes.isEmpty()) {
            YangModel model = YangApacheUtils.processYangModel((String)metaPath, (List)curNodes);
            return DefaultModelRegistrationParam.builder().setYangModel(model).build();
        }
        return null;
    }

    private List<YangNode> getYangNodes(String path) throws IOException {
        LinkedList<YangNode> nodes = new LinkedList<YangNode>();
        File file = new File(path);
        if (file.getName().endsWith(SER_FILE_EXTENSION)) {
            nodes.addAll(DataModelUtils.deSerializeDataModel((String)file.toString()));
        }
        return nodes;
    }
}

