/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.ProviderId;

@Component(immediate=true)
@Service
public class VirtualProviderManager
implements VirtualProviderRegistryService {
    private final Map<ProviderId, VirtualProvider> providers = new HashMap<ProviderId, VirtualProvider>();
    private final Map<ProviderId, VirtualProviderService> servicesWithProvider = new HashMap<ProviderId, VirtualProviderService>();
    private final Map<String, VirtualProvider> providersByScheme = new HashMap<String, VirtualProvider>();
    private final Map<NetworkId, Set<VirtualProviderService>> servicesByNetwork = new HashMap<NetworkId, Set<VirtualProviderService>>();

    public synchronized void registerProvider(VirtualProvider virtualProvider) {
        Preconditions.checkNotNull((Object)virtualProvider, (Object)"Provider cannot be null");
        Preconditions.checkState((!this.providers.containsKey(virtualProvider.id()) ? 1 : 0) != 0, (String)"Provider %s already registered", (Object)virtualProvider.id());
        ProviderId pid = virtualProvider.id();
        Preconditions.checkState((pid.isAncillary() || !this.providersByScheme.containsKey(pid.scheme()) ? 1 : 0) != 0, (String)"A primary provider with id %s is already registered", (Object)this.providersByScheme.get(pid.scheme()));
        this.providers.put(virtualProvider.id(), virtualProvider);
        if (!pid.isAncillary()) {
            this.providersByScheme.put(pid.scheme(), virtualProvider);
        }
    }

    public synchronized void unregisterProvider(VirtualProvider virtualProvider) {
        Preconditions.checkNotNull((Object)virtualProvider, (Object)"Provider cannot be null");
        this.providers.remove(virtualProvider.id());
        if (!virtualProvider.id().isAncillary()) {
            this.providersByScheme.remove(virtualProvider.id().scheme());
        }
    }

    public synchronized void registerProviderService(NetworkId networkId, VirtualProviderService virtualProviderService) {
        Set services = this.servicesByNetwork.computeIfAbsent(networkId, k -> new HashSet());
        services.add(virtualProviderService);
    }

    public synchronized void unregisterProviderService(NetworkId networkId, VirtualProviderService virtualProviderService) {
        Set<VirtualProviderService> services = this.servicesByNetwork.get(networkId);
        if (services != null) {
            services.remove(virtualProviderService);
        }
    }

    public synchronized Set<ProviderId> getProviders() {
        return ImmutableSet.copyOf(this.providers.keySet());
    }

    public Set<ProviderId> getProvidersByService(VirtualProviderService virtualProviderService) {
        Class clazz = this.getProviderClass(virtualProviderService);
        return ImmutableSet.copyOf((Collection)this.providers.values().stream().filter(clazz::isInstance).map(VirtualProvider::id).collect(Collectors.toSet()));
    }

    public synchronized VirtualProvider getProvider(ProviderId providerId) {
        return this.providers.get(providerId);
    }

    public synchronized VirtualProvider getProvider(DeviceId deviceId) {
        return this.providersByScheme.get(deviceId.uri().getScheme());
    }

    public synchronized VirtualProvider getProvider(String scheme) {
        return this.providersByScheme.get(scheme);
    }

    public synchronized VirtualProviderService getProviderService(NetworkId networkId, Class<? extends VirtualProvider> providerClass) {
        Set<VirtualProviderService> services = this.servicesByNetwork.get(networkId);
        if (services == null) {
            return null;
        }
        return services.stream().filter(s -> this.getProviderClass((VirtualProviderService)s).equals(providerClass)).findFirst().orElse(null);
    }

    private Class getProviderClass(VirtualProviderService service) {
        String className = service.getClass().getGenericSuperclass().getTypeName();
        String pramType = className.split("<")[1].split(">")[0];
        try {
            return Class.forName(pramType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

