/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl.provider;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.incubator.net.virtual.impl.provider.VirtualPacketContext;
import org.onosproject.incubator.net.virtual.provider.AbstractVirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualPacketProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualPacketProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.ProviderId;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DefaultVirtualPacketProvider
extends AbstractVirtualProvider
implements VirtualPacketProvider {
    private static final int PACKET_PROCESSOR_PRIORITY = 1;
    private static final PacketPriority VIRTUAL_PACKET_PRIORITY = PacketPriority.REACTIVE;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkAdminService vnaService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualProviderRegistryService providerRegistryService;
    ApplicationId appId;
    InternalPacketProcessor processor;
    private Map<VirtualPacketContext, PacketContext> contextMap;
    private Set<NetworkId> requestsSet = Sets.newHashSet();

    public DefaultVirtualPacketProvider() {
        super(new ProviderId("virtual-packet", "org.onosproject.virtual.virtual-packet"));
    }

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.virtual.virtual-packet");
        this.providerRegistryService.registerProvider((VirtualProvider)this);
        this.contextMap = Maps.newConcurrentMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        if (this.processor != null) {
            this.packetService.removeProcessor((PacketProcessor)this.processor);
        }
        this.providerRegistryService.unregisterProvider((VirtualProvider)this);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
    }

    public void emit(NetworkId networkId, OutboundPacket packet) {
        this.packetService.emit(this.devirtualize(networkId, packet));
    }

    public void startPacketHandling(NetworkId networkId) {
        this.requestsSet.add(networkId);
        if (this.processor == null) {
            this.processor = new InternalPacketProcessor();
            this.packetService.addProcessor((PacketProcessor)this.processor, 1);
        }
    }

    public void stopPacketHandling(NetworkId networkId) {
        this.requestsSet.remove(networkId);
        if (this.requestsSet.isEmpty()) {
            this.packetService.removeProcessor((PacketProcessor)this.processor);
            this.processor = null;
        }
    }

    private VirtualPacketContext virtualize(PacketContext context) {
        VirtualPort vPort = this.getMappedVirtualPort(context.inPacket().receivedFrom());
        if (vPort != null) {
            ConnectPoint cp = new ConnectPoint(vPort.element().id(), vPort.number());
            Ethernet eth = context.inPacket().parsed();
            eth.setVlanID((short)-1);
            DefaultInboundPacket inPacket = new DefaultInboundPacket(cp, eth, ByteBuffer.wrap(eth.serialize()));
            DefaultOutboundPacket outPkt = new DefaultOutboundPacket(cp.deviceId(), DefaultTrafficTreatment.builder().build(), ByteBuffer.wrap(eth.serialize()));
            VirtualPacketContext vContext = new VirtualPacketContext(context.time(), (InboundPacket)inPacket, (OutboundPacket)outPkt, false, vPort.networkId(), this);
            this.contextMap.put(vContext, context);
            return vContext;
        }
        return null;
    }

    private VirtualPort getMappedVirtualPort(ConnectPoint cp) {
        Set tIds = this.vnaService.getTenantIds();
        HashSet vNetworks = new HashSet();
        tIds.forEach(tid -> vNetworks.addAll(this.vnaService.getVirtualNetworks(tid)));
        for (VirtualNetwork vNet : vNetworks) {
            Set vDevices = this.vnaService.getVirtualDevices(vNet.id());
            HashSet vPorts = new HashSet();
            vDevices.forEach(dev -> vPorts.addAll(this.vnaService.getVirtualPorts(dev.networkId(), dev.id())));
            VirtualPort vPort = vPorts.stream().filter(vp -> vp.realizedBy().equals((Object)cp)).findFirst().orElse(null);
            if (vPort == null) continue;
            return vPort;
        }
        return null;
    }

    private OutboundPacket devirtualize(NetworkId networkId, OutboundPacket packet) {
        Set vPorts = this.vnaService.getVirtualPorts(networkId, packet.sendThrough());
        PortNumber vOutPortNum = packet.treatment().allInstructions().stream().filter(i -> i.type() == Instruction.Type.OUTPUT).map(i -> ((Instructions.OutputInstruction)i).port()).findFirst().get();
        Optional<ConnectPoint> optionalCpOut = vPorts.stream().filter(v -> v.number().equals((Object)vOutPortNum)).map(v -> v.realizedBy()).findFirst();
        if (!optionalCpOut.isPresent()) {
            this.log.warn("Port {} is not realized yet, in Network {}, Device {}", new Object[]{vOutPortNum, networkId, packet.sendThrough()});
            return null;
        }
        ConnectPoint egressPoint = optionalCpOut.get();
        TrafficTreatment.Builder commonTreatmentBuilder = DefaultTrafficTreatment.builder();
        packet.treatment().allInstructions().stream().filter(i -> i.type() != Instruction.Type.OUTPUT).forEach(i -> commonTreatmentBuilder.add(i));
        TrafficTreatment commonTreatment = commonTreatmentBuilder.build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder((TrafficTreatment)commonTreatment).setOutput(egressPoint.port()).build();
        DefaultOutboundPacket outboundPacket = new DefaultOutboundPacket(egressPoint.deviceId(), treatment, packet.data());
        return outboundPacket;
    }

    public void devirtualizeContext(VirtualPacketContext context) {
        NetworkId networkId = context.getNetworkId();
        TrafficTreatment vTreatment = context.treatmentBuilder().build();
        DeviceId sendThrough = context.outPacket().sendThrough();
        PortNumber vOutPortNum = vTreatment.allInstructions().stream().filter(i -> i.type() == Instruction.Type.OUTPUT).map(i -> ((Instructions.OutputInstruction)i).port()).findFirst().get();
        TrafficTreatment.Builder commonTreatmentBuilder = DefaultTrafficTreatment.builder();
        vTreatment.allInstructions().stream().filter(i -> i.type() != Instruction.Type.OUTPUT).forEach(i -> commonTreatmentBuilder.add(i));
        TrafficTreatment commonTreatment = commonTreatmentBuilder.build();
        if (!vOutPortNum.isLogical()) {
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().addTreatment(commonTreatment).setOutput(vOutPortNum).build();
            this.emit(networkId, (OutboundPacket)new DefaultOutboundPacket(sendThrough, treatment, context.outPacket().data()));
        } else if (vOutPortNum == PortNumber.FLOOD) {
            Set vPorts = this.vnaService.getVirtualPorts(networkId, sendThrough);
            Set outPorts = vPorts.stream().filter(vp -> !vp.number().isLogical()).filter(vp -> vp.number() != context.inPacket().receivedFrom().port()).collect(Collectors.toSet());
            for (VirtualPort outPort : outPorts) {
                TrafficTreatment treatment = DefaultTrafficTreatment.builder().addTreatment(commonTreatment).setOutput(outPort.number()).build();
                this.emit(networkId, (OutboundPacket)new DefaultOutboundPacket(sendThrough, treatment, context.outPacket().data()));
            }
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindVnaService(VirtualNetworkAdminService virtualNetworkAdminService) {
        this.vnaService = virtualNetworkAdminService;
    }

    protected void unbindVnaService(VirtualNetworkAdminService virtualNetworkAdminService) {
        if (this.vnaService == virtualNetworkAdminService) {
            this.vnaService = null;
        }
    }

    protected void bindProviderRegistryService(VirtualProviderRegistryService virtualProviderRegistryService) {
        this.providerRegistryService = virtualProviderRegistryService;
    }

    protected void unbindProviderRegistryService(VirtualProviderRegistryService virtualProviderRegistryService) {
        if (this.providerRegistryService == virtualProviderRegistryService) {
            this.providerRegistryService = null;
        }
    }

    private final class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            VirtualPacketContext vContexts = DefaultVirtualPacketProvider.this.virtualize(context);
            if (vContexts == null) {
                return;
            }
            VirtualPacketProviderService service = (VirtualPacketProviderService)DefaultVirtualPacketProvider.this.providerRegistryService.getProviderService(vContexts.getNetworkId(), VirtualPacketProvider.class);
            if (service != null) {
                service.processPacket((PacketContext)vContexts);
            }
        }
    }
}

