/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl.provider;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.provider.VirtualNetworkProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualNetworkProviderRegistry;
import org.onosproject.incubator.net.virtual.provider.VirtualNetworkProviderService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultVirtualNetworkProvider
extends AbstractProvider
implements VirtualNetworkProvider {
    private final Logger log = LoggerFactory.getLogger(DefaultVirtualNetworkProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkProviderRegistry providerRegistry;
    private VirtualNetworkProviderService providerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    protected TopologyListener topologyListener = new InternalTopologyListener();
    private ExecutorService executor;

    public DefaultVirtualNetworkProvider() {
        super(DefaultVirtualLink.PID);
    }

    @Activate
    public void activate() {
        this.executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/vnet", (String)"provider", (Logger)this.log));
        this.providerService = (VirtualNetworkProviderService)this.providerRegistry.register((Provider)this);
        this.topologyService.addListener((EventListener)this.topologyListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.topologyService.removeListener((EventListener)this.topologyListener);
        this.executor.shutdownNow();
        this.executor = null;
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    public boolean isTraversable(ConnectPoint src, ConnectPoint dst) {
        boolean[] foundSrc = new boolean[1];
        boolean[] foundDst = new boolean[1];
        Topology topology = this.topologyService.currentTopology();
        Set paths = this.topologyService.getPaths(topology, src.deviceId(), dst.deviceId());
        paths.forEach(path -> {
            foundDst[0] = false;
            foundSrc[0] = false;
            path.links().forEach(link -> {
                if (link.src().equals((Object)src)) {
                    foundSrc[0] = true;
                }
                if (link.dst().equals((Object)dst)) {
                    foundDst[0] = true;
                }
            });
            if (foundSrc[0] && foundDst[0]) {
                return;
            }
        });
        return foundSrc[0] && foundDst[0];
    }

    public TunnelId createTunnel(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        return null;
    }

    public void destroyTunnel(NetworkId networkId, TunnelId tunnelId) {
    }

    public Set<Set<ConnectPoint>> getConnectPoints(Topology topology) {
        HashSet<Set<ConnectPoint>> clusters = new HashSet<Set<ConnectPoint>>();
        Set topologyClusters = this.topologyService.getClusters(topology);
        topologyClusters.forEach(topologyCluster -> {
            HashSet connectPointSet = new HashSet();
            Set clusterLinks = this.topologyService.getClusterLinks(topology, topologyCluster);
            clusterLinks.forEach(link -> {
                connectPointSet.add(link.src());
                connectPointSet.add(link.dst());
            });
            if (!connectPointSet.isEmpty()) {
                clusters.add(connectPointSet);
            }
        });
        return clusters;
    }

    protected void bindProviderRegistry(VirtualNetworkProviderRegistry virtualNetworkProviderRegistry) {
        this.providerRegistry = virtualNetworkProviderRegistry;
    }

    protected void unbindProviderRegistry(VirtualNetworkProviderRegistry virtualNetworkProviderRegistry) {
        if (this.providerRegistry == virtualNetworkProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        public void event(TopologyEvent event) {
            DefaultVirtualNetworkProvider.this.executor.submit(() -> DefaultVirtualNetworkProvider.this.providerService.topologyChanged(DefaultVirtualNetworkProvider.this.getConnectPoints((Topology)event.subject())));
        }

        public boolean isRelevant(TopologyEvent event) {
            return event.type() == TopologyEvent.Type.TOPOLOGY_CHANGED && event.reasons().stream().anyMatch(reason -> reason instanceof LinkEvent);
        }
    }
}

