/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl.provider;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.provider.AbstractVirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualGroupProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.provider.ProviderId;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultVirtualGroupProvider
extends AbstractVirtualProvider
implements VirtualGroupProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualProviderRegistryService providerRegistryService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    private InternalGroupEventListener internalGroupEventListener;

    public DefaultVirtualGroupProvider() {
        super(new ProviderId("vnet-group", "org.onosproject.virtual.of-group"));
    }

    @Activate
    public void activate() {
        this.providerRegistryService.registerProvider((VirtualProvider)this);
        this.internalGroupEventListener = new InternalGroupEventListener();
        this.groupService.addListener((EventListener)this.internalGroupEventListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.groupService.removeListener((EventListener)this.internalGroupEventListener);
        this.providerRegistryService.unregisterProvider((VirtualProvider)this);
    }

    @Modified
    protected void modified(ComponentContext context) {
    }

    public void performGroupOperation(NetworkId networkId, DeviceId deviceId, GroupOperations groupOps) {
        block5: for (GroupOperation groupOperation : groupOps.operations()) {
            switch (groupOperation.opType()) {
                case ADD: {
                    this.log.info("Group Add is not supported, yet");
                    continue block5;
                }
                case MODIFY: {
                    this.log.info("Group Modify is not supported, yet");
                    continue block5;
                }
                case DELETE: {
                    this.log.info("Group Delete is not supported, yet");
                    continue block5;
                }
            }
            this.log.error("Unsupported Group operation");
            return;
        }
    }

    protected void bindProviderRegistryService(VirtualProviderRegistryService virtualProviderRegistryService) {
        this.providerRegistryService = virtualProviderRegistryService;
    }

    protected void unbindProviderRegistryService(VirtualProviderRegistryService virtualProviderRegistryService) {
        if (this.providerRegistryService == virtualProviderRegistryService) {
            this.providerRegistryService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    private class InternalGroupEventListener
    implements GroupListener {
        private InternalGroupEventListener() {
        }

        public void event(GroupEvent event) {
            switch ((GroupEvent.Type)event.type()) {
                default: 
            }
        }
    }
}

