/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.incubator.net.virtual.provider.AbstractVirtualProvider;
import org.onosproject.incubator.net.virtual.provider.InternalRoutingAlgorithm;
import org.onosproject.incubator.net.virtual.provider.VirtualFlowRuleProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualFlowRuleProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.BatchOperationEntry;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.TopologyService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultVirtualFlowRuleProvider
extends AbstractVirtualProvider
implements VirtualFlowRuleProvider {
    private static final String APP_ID_STR = "org.onosproject.virtual.vnet-flow_";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkService vnService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualProviderRegistryService providerRegistryService;
    private InternalRoutingAlgorithm internalRoutingAlgorithm;
    private InternalVirtualFlowRuleManager frm;
    private ApplicationId appId;
    private FlowRuleListener flowRuleListener;

    public DefaultVirtualFlowRuleProvider() {
        super(new ProviderId("vnet-flow", "org.onosproject.virtual.vnet-flow"));
    }

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_ID_STR);
        this.providerRegistryService.registerProvider((VirtualProvider)this);
        this.flowRuleListener = new InternalFlowRuleListener();
        this.flowRuleService.addListener((EventListener)this.flowRuleListener);
        this.internalRoutingAlgorithm = new DefaultInternalRoutingAlgorithm();
        this.frm = new InternalVirtualFlowRuleManager();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.flowRuleService.removeListener((EventListener)this.flowRuleListener);
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.providerRegistryService.unregisterProvider((VirtualProvider)this);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
    }

    public void applyFlowRule(NetworkId networkId, FlowRule ... flowRules) {
        for (FlowRule flowRule : flowRules) {
            this.devirtualize(networkId, flowRule).forEach(r -> this.flowRuleService.applyFlowRules(new FlowRule[]{r}));
        }
    }

    public void removeFlowRule(NetworkId networkId, FlowRule ... flowRules) {
        for (FlowRule flowRule : flowRules) {
            this.devirtualize(networkId, flowRule).forEach(r -> this.flowRuleService.removeFlowRules(new FlowRule[]{r}));
        }
    }

    public void executeBatch(final NetworkId networkId, final FlowRuleBatchOperation batch) {
        Preconditions.checkNotNull((Object)batch);
        for (FlowRuleBatchEntry fop : batch.getOperations()) {
            FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
            switch ((FlowRuleBatchEntry.FlowRuleOperation)fop.operator()) {
                case ADD: {
                    this.devirtualize(networkId, (FlowRule)fop.target()).forEach(arg_0 -> ((FlowRuleOperations.Builder)builder).add(arg_0));
                    break;
                }
                case REMOVE: {
                    this.devirtualize(networkId, (FlowRule)fop.target()).forEach(arg_0 -> ((FlowRuleOperations.Builder)builder).remove(arg_0));
                    break;
                }
                case MODIFY: {
                    this.devirtualize(networkId, (FlowRule)fop.target()).forEach(arg_0 -> ((FlowRuleOperations.Builder)builder).modify(arg_0));
                    break;
                }
            }
            this.flowRuleService.apply(builder.build(new FlowRuleOperationsContext(){

                public void onSuccess(FlowRuleOperations ops) {
                    CompletedBatchOperation status = new CompletedBatchOperation(true, Sets.newConcurrentHashSet(), batch.deviceId());
                    VirtualFlowRuleProviderService providerService = (VirtualFlowRuleProviderService)DefaultVirtualFlowRuleProvider.this.providerRegistryService.getProviderService(networkId, VirtualFlowRuleProvider.class);
                    providerService.batchOperationCompleted(batch.id(), status);
                }

                public void onError(FlowRuleOperations ops) {
                    ImmutableSet failures = ImmutableSet.copyOf((Collection)Lists.transform((List)batch.getOperations(), BatchOperationEntry::target));
                    CompletedBatchOperation status = new CompletedBatchOperation(false, (Set)failures, batch.deviceId());
                    VirtualFlowRuleProviderService providerService = (VirtualFlowRuleProviderService)DefaultVirtualFlowRuleProvider.this.providerRegistryService.getProviderService(networkId, VirtualFlowRuleProvider.class);
                    providerService.batchOperationCompleted(batch.id(), status);
                }
            }));
        }
    }

    public void setEmbeddingAlgorithm(InternalRoutingAlgorithm internalRoutingAlgorithm) {
        this.internalRoutingAlgorithm = internalRoutingAlgorithm;
    }

    private FlowRule virtualizeFlowRule(FlowRule flowRule) {
        FlowRule storedrule = this.frm.getVirtualRule(flowRule);
        if (flowRule.reason() == FlowRule.FlowRemoveReason.NO_REASON) {
            return storedrule;
        }
        return DefaultFlowRule.builder().withReason(flowRule.reason()).withPriority(storedrule.priority()).forDevice(storedrule.deviceId()).forTable(storedrule.tableId()).fromApp((ApplicationId)new DefaultApplicationId((int)storedrule.appId(), null)).withIdleTimeout(storedrule.timeout()).withHardTimeout(storedrule.hardTimeout()).withSelector(storedrule.selector()).withTreatment(storedrule.treatment()).build();
    }

    private FlowEntry virtualize(FlowEntry flowEntry) {
        FlowRule vRule = this.virtualizeFlowRule((FlowRule)flowEntry);
        DefaultFlowEntry vEntry = new DefaultFlowEntry(vRule, flowEntry.state(), flowEntry.life(), flowEntry.packets(), flowEntry.bytes());
        return vEntry;
    }

    private Set<FlowRule> devirtualize(NetworkId networkId, FlowRule flowRule) {
        HashSet<FlowRule> outRules = new HashSet<FlowRule>();
        Set<ConnectPoint> ingressPoints = this.extractIngressPoints(networkId, flowRule.deviceId(), flowRule.selector());
        ConnectPoint egressPoint = this.extractEgressPoints(networkId, flowRule.deviceId(), flowRule.treatment());
        if (egressPoint == null) {
            return outRules;
        }
        TrafficSelector.Builder commonSelectorBuilder = DefaultTrafficSelector.builder();
        flowRule.selector().criteria().stream().filter(c -> c.type() != Criterion.Type.IN_PORT).forEach(c -> commonSelectorBuilder.add(c));
        TrafficSelector commonSelector = commonSelectorBuilder.build();
        TrafficTreatment.Builder commonTreatmentBuilder = DefaultTrafficTreatment.builder();
        flowRule.treatment().allInstructions().stream().filter(i -> i.type() != Instruction.Type.OUTPUT).forEach(i -> commonTreatmentBuilder.add(i));
        TrafficTreatment commonTreatment = commonTreatmentBuilder.build();
        for (ConnectPoint ingressPoint : ingressPoints) {
            if (egressPoint.port() == PortNumber.FLOOD) {
                Set outPoints = this.vnService.getVirtualPorts(networkId, flowRule.deviceId()).stream().map(VirtualPort::realizedBy).filter(p -> !p.equals((Object)ingressPoint)).collect(Collectors.toSet());
                for (ConnectPoint outPoint : outPoints) {
                    outRules.addAll(this.generateRules(networkId, ingressPoint, outPoint, commonSelector, commonTreatment, flowRule));
                }
                continue;
            }
            outRules.addAll(this.generateRules(networkId, ingressPoint, egressPoint, commonSelector, commonTreatment, flowRule));
        }
        return outRules;
    }

    private Set<ConnectPoint> extractIngressPoints(NetworkId networkId, DeviceId deviceId, TrafficSelector selector) {
        HashSet<ConnectPoint> ingressPoints = new HashSet<ConnectPoint>();
        Set vPorts = this.vnService.getVirtualPorts(networkId, deviceId);
        PortCriterion portCriterion = (PortCriterion)selector.getCriterion(Criterion.Type.IN_PORT);
        if (portCriterion != null) {
            PortNumber vInPortNum = portCriterion.port();
            Optional<ConnectPoint> optionalCp = vPorts.stream().filter(v -> v.number().equals((Object)vInPortNum)).map(VirtualPort::realizedBy).findFirst();
            if (!optionalCp.isPresent()) {
                this.log.warn("Port {} is not realized yet, in Network {}, Device {}", new Object[]{vInPortNum, networkId, deviceId});
                return ingressPoints;
            }
            ingressPoints.add(optionalCp.get());
        } else {
            for (VirtualPort vPort : vPorts) {
                if (vPort.realizedBy() != null) {
                    ingressPoints.add(vPort.realizedBy());
                    continue;
                }
                this.log.warn("Port {} is not realized yet, in Network {}, Device {}", new Object[]{vPort, networkId, deviceId});
            }
        }
        return ingressPoints;
    }

    private ConnectPoint extractEgressPoints(NetworkId networkId, DeviceId deviceId, TrafficTreatment treatment) {
        Set vPorts = this.vnService.getVirtualPorts(networkId, deviceId);
        PortNumber vOutPortNum = treatment.allInstructions().stream().filter(i -> i.type() == Instruction.Type.OUTPUT).map(i -> ((Instructions.OutputInstruction)i).port()).findFirst().get();
        Optional<ConnectPoint> optionalCpOut = vPorts.stream().filter(v -> v.number().equals((Object)vOutPortNum)).map(VirtualPort::realizedBy).findFirst();
        if (!optionalCpOut.isPresent()) {
            if (vOutPortNum.isLogical()) {
                return new ConnectPoint((ElementId)DeviceId.deviceId((String)"vNet"), vOutPortNum);
            }
            this.log.warn("Port {} is not realized yet, in Network {}, Device {}", new Object[]{vOutPortNum, networkId, deviceId});
            return null;
        }
        return optionalCpOut.get();
    }

    private Set<FlowRule> generateRules(NetworkId networkId, ConnectPoint ingressPoint, ConnectPoint egressPoint, TrafficSelector commonSelector, TrafficTreatment commonTreatment, FlowRule flowRule) {
        HashSet<FlowRule> outRules = new HashSet<FlowRule>();
        if (ingressPoint.deviceId().equals((Object)egressPoint.deviceId()) || egressPoint.port().isLogical()) {
            TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder((TrafficSelector)commonSelector).matchInPort(ingressPoint.port());
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)commonTreatment);
            VirtualPort virtualIngressPort = this.vnService.getVirtualPorts(networkId, flowRule.deviceId()).stream().filter(p -> p.realizedBy().equals((Object)ingressPoint)).findFirst().get();
            VirtualPort virtualEgressPort = this.vnService.getVirtualPorts(networkId, flowRule.deviceId()).stream().filter(p -> p.realizedBy().equals((Object)egressPoint)).findFirst().get();
            ConnectPoint ingressCp = new ConnectPoint(virtualIngressPort.element().id(), virtualIngressPort.number());
            ConnectPoint egressCp = new ConnectPoint(virtualEgressPort.element().id(), virtualEgressPort.number());
            Optional<VirtualLink> optionalIngressLink = this.vnService.getVirtualLinks(networkId).stream().filter(l -> l.dst().equals((Object)ingressCp)).findFirst();
            Optional<VirtualLink> optionalEgressLink = this.vnService.getVirtualLinks(networkId).stream().filter(l -> l.src().equals((Object)egressCp)).findFirst();
            if (!optionalIngressLink.isPresent() && !optionalEgressLink.isPresent()) {
                treatmentBuilder.setOutput(egressPoint.port());
            } else if (optionalIngressLink.isPresent() && !optionalEgressLink.isPresent()) {
                selectorBuilder.matchVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue()));
                treatmentBuilder.popVlan();
                treatmentBuilder.setOutput(egressPoint.port());
            } else if (!optionalIngressLink.isPresent() && optionalEgressLink.isPresent()) {
                outRules.addAll(this.generateRulesOnPath(networkId, optionalEgressLink.get(), commonSelector, commonTreatment, flowRule));
                treatmentBuilder.pushVlan().setVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue()));
                treatmentBuilder.setOutput(egressPoint.port());
            } else if (optionalIngressLink.isPresent() && optionalEgressLink.isPresent()) {
                outRules.addAll(this.generateRulesOnPath(networkId, optionalEgressLink.get(), commonSelector, commonTreatment, flowRule));
                selectorBuilder.matchVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue()));
                treatmentBuilder.setOutput(egressPoint.port());
            }
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(this.vnService.getVirtualNetworkApplicationId(networkId)).forDevice(ingressPoint.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withIdleTimeout(flowRule.timeout()).withPriority(flowRule.priority());
            FlowRule rule = ruleBuilder.build();
            this.frm.addIngressRule(flowRule, rule, networkId);
            outRules.add(rule);
        } else {
            Path internalPath = this.internalRoutingAlgorithm.findPath(ingressPoint, egressPoint);
            Preconditions.checkNotNull((Object)internalPath, (Object)("No path between " + ingressPoint.toString() + " " + egressPoint.toString()));
            ConnectPoint outCp = ((Link)internalPath.links().get(0)).src();
            TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder((TrafficSelector)commonSelector);
            selectorBuilder.matchInPort(ingressPoint.port());
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)commonTreatment);
            treatmentBuilder.pushVlan().setVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue()));
            treatmentBuilder.setOutput(outCp.port());
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(this.vnService.getVirtualNetworkApplicationId(networkId)).forDevice(ingressPoint.deviceId()).withSelector(selectorBuilder.build()).withIdleTimeout(flowRule.timeout()).withTreatment(treatmentBuilder.build()).withPriority(flowRule.priority());
            FlowRule rule = ruleBuilder.build();
            this.frm.addIngressRule(flowRule, rule, networkId);
            outRules.add(rule);
            ConnectPoint inCp = ((Link)internalPath.links().get(0)).dst();
            if (internalPath.links().size() > 1) {
                for (Link l2 : internalPath.links().subList(1, internalPath.links().size())) {
                    outCp = l2.src();
                    selectorBuilder = DefaultTrafficSelector.builder((TrafficSelector)commonSelector).matchVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue())).matchInPort(inCp.port());
                    treatmentBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)commonTreatment).setOutput(outCp.port());
                    ruleBuilder = DefaultFlowRule.builder().fromApp(this.vnService.getVirtualNetworkApplicationId(networkId)).forDevice(inCp.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withIdleTimeout(flowRule.timeout()).withPriority(flowRule.priority());
                    outRules.add(ruleBuilder.build());
                    inCp = l2.dst();
                }
            }
            selectorBuilder = DefaultTrafficSelector.builder((TrafficSelector)commonSelector).matchVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue())).matchInPort(inCp.port());
            treatmentBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)commonTreatment).popVlan().setOutput(egressPoint.port());
            ruleBuilder = DefaultFlowRule.builder().fromApp(this.appId).forDevice(egressPoint.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withIdleTimeout(flowRule.timeout()).withPriority(flowRule.priority());
            outRules.add(ruleBuilder.build());
        }
        return outRules;
    }

    private Set<FlowRule> generateRulesOnPath(NetworkId networkId, VirtualLink virtualLink, TrafficSelector commonSelector, TrafficTreatment commonTreatment, FlowRule flowRule) {
        VirtualPort srcVirtualPort = this.vnService.getVirtualPorts(networkId, virtualLink.src().deviceId()).stream().filter(p -> p.number().equals((Object)virtualLink.src().port())).findFirst().get();
        VirtualPort dstVirtualPort = this.vnService.getVirtualPorts(networkId, virtualLink.dst().deviceId()).stream().filter(p -> p.number().equals((Object)virtualLink.dst().port())).findFirst().get();
        HashSet<FlowRule> outRules = new HashSet<FlowRule>();
        ConnectPoint srcCp = srcVirtualPort.realizedBy();
        ConnectPoint dstCp = dstVirtualPort.realizedBy();
        Path internalPath = this.internalRoutingAlgorithm.findPath(srcCp, dstCp);
        List links = internalPath.links();
        if (internalPath != null && links.size() > 1) {
            for (int i = 0; i < links.size() - 1; ++i) {
                ConnectPoint inCp = ((Link)links.get(i)).dst();
                ConnectPoint outCp = ((Link)links.get(i + 1)).src();
                TrafficSelector.Builder linkSelectorBuilder = DefaultTrafficSelector.builder((TrafficSelector)commonSelector).matchVlanId(VlanId.vlanId((short)((Long)networkId.id()).shortValue())).matchInPort(inCp.port());
                TrafficTreatment.Builder linkTreatmentBuilder = DefaultTrafficTreatment.builder((TrafficTreatment)commonTreatment).setOutput(outCp.port());
                FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(this.vnService.getVirtualNetworkApplicationId(networkId)).forDevice(inCp.deviceId()).withSelector(linkSelectorBuilder.build()).withTreatment(linkTreatmentBuilder.build()).withPriority(flowRule.priority());
                if (flowRule.isPermanent()) {
                    ruleBuilder.makePermanent();
                } else {
                    ruleBuilder.makeTemporary(flowRule.timeout());
                }
                outRules.add(ruleBuilder.build());
            }
        }
        return outRules;
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindVnService(VirtualNetworkService virtualNetworkService) {
        this.vnService = virtualNetworkService;
    }

    protected void unbindVnService(VirtualNetworkService virtualNetworkService) {
        if (this.vnService == virtualNetworkService) {
            this.vnService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindProviderRegistryService(VirtualProviderRegistryService virtualProviderRegistryService) {
        this.providerRegistryService = virtualProviderRegistryService;
    }

    protected void unbindProviderRegistryService(VirtualProviderRegistryService virtualProviderRegistryService) {
        if (this.providerRegistryService == virtualProviderRegistryService) {
            this.providerRegistryService = null;
        }
    }

    private class DefaultInternalRoutingAlgorithm
    implements InternalRoutingAlgorithm {
        private DefaultInternalRoutingAlgorithm() {
        }

        public Path findPath(ConnectPoint src, ConnectPoint dst) {
            Set paths = DefaultVirtualFlowRuleProvider.this.topologyService.getPaths(DefaultVirtualFlowRuleProvider.this.topologyService.currentTopology(), src.deviceId(), dst.deviceId());
            if (paths.isEmpty()) {
                return null;
            }
            return (Path)paths.toArray()[0];
        }
    }

    private class InternalVirtualFlowRuleManager {
        final Table<NetworkId, DeviceId, Set<FlowRule>> flowRuleTable = HashBasedTable.create();
        final Table<NetworkId, DeviceId, Set<FlowEntry>> flowEntryTable = HashBasedTable.create();
        final Map<FlowRule, NetworkId> ingressRuleMap = Maps.newHashMap();
        final Map<FlowRule, FlowRule> virtualizationMap = Maps.newHashMap();

        private InternalVirtualFlowRuleManager() {
        }

        private Iterable<FlowRule> getFlowRules(NetworkId networkId, DeviceId deviceId) {
            return (Iterable)this.flowRuleTable.get((Object)networkId, (Object)deviceId);
        }

        private Iterable<FlowEntry> getFlowEntries(NetworkId networkId, DeviceId deviceId) {
            return (Iterable)this.flowEntryTable.get((Object)networkId, (Object)deviceId);
        }

        private void addFlowRule(NetworkId networkId, DeviceId deviceId, FlowRule flowRule) {
            Set set = (Set)this.flowRuleTable.get((Object)networkId, (Object)deviceId);
            if (set == null) {
                set = Sets.newHashSet();
                this.flowRuleTable.put((Object)networkId, (Object)deviceId, (Object)set);
            }
            set.add(flowRule);
        }

        private void removeFlowRule(NetworkId networkId, DeviceId deviceId, FlowRule flowRule) {
            Set set = (Set)this.flowRuleTable.get((Object)networkId, (Object)deviceId);
            if (set == null) {
                return;
            }
            set.remove(flowRule);
        }

        private void addOrUpdateFlowEntry(NetworkId networkId, DeviceId deviceId, FlowEntry flowEntry) {
            Set set = (Set)this.flowEntryTable.get((Object)networkId, (Object)deviceId);
            if (set == null) {
                set = Sets.newConcurrentHashSet();
                this.flowEntryTable.put((Object)networkId, (Object)deviceId, (Object)set);
            }
            set.stream().filter(fe -> fe.exactMatch((FlowRule)flowEntry)).forEach(set::remove);
            set.add(flowEntry);
        }

        private void removeFlowEntry(NetworkId networkId, DeviceId deviceId, FlowEntry flowEntry) {
            Set set = (Set)this.flowEntryTable.get((Object)networkId, (Object)deviceId);
            if (set == null) {
                return;
            }
            set.remove(flowEntry);
        }

        private void addIngressRule(FlowRule virtualRule, FlowRule physicalRule, NetworkId networkId) {
            this.ingressRuleMap.put(physicalRule, networkId);
            this.virtualizationMap.put(physicalRule, virtualRule);
        }

        private FlowRule getVirtualRule(FlowRule physicalRule) {
            return this.virtualizationMap.get(physicalRule);
        }

        private void removeIngressRule(FlowRule physicalRule) {
            this.ingressRuleMap.remove(physicalRule);
            this.virtualizationMap.remove(physicalRule);
        }

        private Set<FlowRule> getAllPhysicalRule() {
            return ImmutableSet.copyOf(this.virtualizationMap.keySet());
        }

        private NetworkId getVirtualNetworkId(FlowRule physicalRule) {
            return this.ingressRuleMap.get(physicalRule);
        }

        private boolean isVirtualIngressRule(FlowRule flowRule) {
            return this.ingressRuleMap.containsKey(flowRule);
        }
    }

    private class InternalFlowRuleListener
    implements FlowRuleListener {
        private InternalFlowRuleListener() {
        }

        public void event(FlowRuleEvent event) {
            if (event.type() == FlowRuleEvent.Type.RULE_ADDED || event.type() == FlowRuleEvent.Type.RULE_UPDATED) {
                if (DefaultVirtualFlowRuleProvider.this.frm.isVirtualIngressRule((FlowRule)event.subject())) {
                    NetworkId networkId = DefaultVirtualFlowRuleProvider.this.frm.getVirtualNetworkId((FlowRule)event.subject());
                    FlowEntry vEntry = this.getVirtualFlowEntry((FlowRule)event.subject());
                    DefaultVirtualFlowRuleProvider.this.frm.addOrUpdateFlowEntry(networkId, vEntry.deviceId(), vEntry);
                    VirtualFlowRuleProviderService providerService = (VirtualFlowRuleProviderService)DefaultVirtualFlowRuleProvider.this.providerRegistryService.getProviderService(networkId, VirtualFlowRuleProvider.class);
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll(DefaultVirtualFlowRuleProvider.this.frm.getFlowEntries(networkId, vEntry.deviceId()));
                    providerService.pushFlowMetrics(vEntry.deviceId(), (Iterable)builder.build());
                }
            } else if (event.type() == FlowRuleEvent.Type.RULE_REMOVED && DefaultVirtualFlowRuleProvider.this.frm.isVirtualIngressRule((FlowRule)event.subject())) {
                NetworkId networkId = DefaultVirtualFlowRuleProvider.this.frm.getVirtualNetworkId((FlowRule)event.subject());
                FlowEntry vEntry = this.getVirtualFlowEntry((FlowRule)event.subject());
                DefaultVirtualFlowRuleProvider.this.frm.removeFlowEntry(networkId, vEntry.deviceId(), vEntry);
                DefaultVirtualFlowRuleProvider.this.frm.removeFlowRule(networkId, vEntry.deviceId(), (FlowRule)vEntry);
                VirtualFlowRuleProviderService providerService = (VirtualFlowRuleProviderService)DefaultVirtualFlowRuleProvider.this.providerRegistryService.getProviderService(networkId, VirtualFlowRuleProvider.class);
                providerService.flowRemoved(vEntry);
            }
        }

        private FlowEntry getVirtualFlowEntry(FlowRule rule) {
            FlowEntry entry = null;
            for (FlowEntry fe : DefaultVirtualFlowRuleProvider.this.flowRuleService.getFlowEntries(rule.deviceId())) {
                if (!rule.exactMatch((FlowRule)fe)) continue;
                entry = fe;
            }
            if (entry != null) {
                return DefaultVirtualFlowRuleProvider.this.virtualize(entry);
            }
            return DefaultVirtualFlowRuleProvider.this.virtualize((FlowEntry)new DefaultFlowEntry(rule, FlowEntry.FlowEntryState.PENDING_REMOVE));
        }
    }
}

