/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.common.DefaultTopology;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.topology.AdapterLinkWeigher;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultGraphDescription;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;

public class VirtualNetworkTopologyManager
extends AbstractVirtualListenerManager<TopologyEvent, TopologyListener>
implements TopologyService {
    private static final String TOPOLOGY_NULL = "Topology cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String CLUSTER_ID_NULL = "Cluster ID cannot be null";
    private static final String CLUSTER_NULL = "Topology cluster cannot be null";
    private static final String CONNECTION_POINT_NULL = "Connection point cannot be null";
    private static final String LINK_WEIGHT_NULL = "Link weight cannot be null";

    public VirtualNetworkTopologyManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId, TopologyEvent.class);
    }

    public Topology currentTopology() {
        Iterable devices = this.manager.getVirtualDevices(this.networkId()).stream().collect(Collectors.toSet());
        Iterable links = this.manager.getVirtualLinks(this.networkId()).stream().collect(Collectors.toSet());
        DefaultGraphDescription graph = new DefaultGraphDescription(System.nanoTime(), System.currentTimeMillis(), devices, links, new SparseAnnotations[0]);
        return new DefaultTopology(DefaultVirtualLink.PID, (GraphDescription)graph);
    }

    public boolean isLatest(Topology topology) {
        Topology currentTopology = this.currentTopology();
        return this.defaultTopology(topology).getGraph().equals(this.defaultTopology(currentTopology).getGraph());
    }

    public TopologyGraph getGraph(Topology topology) {
        return this.defaultTopology(topology).getGraph();
    }

    private DefaultTopology defaultTopology(Topology topology) {
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkArgument((boolean)(topology instanceof DefaultTopology), (String)"Topology class %s not supported", topology.getClass());
        return (DefaultTopology)topology;
    }

    public Set<TopologyCluster> getClusters(Topology topology) {
        return this.defaultTopology(topology).getClusters();
    }

    public TopologyCluster getCluster(Topology topology, ClusterId clusterId) {
        Preconditions.checkNotNull((Object)clusterId, (Object)CLUSTER_ID_NULL);
        return this.defaultTopology(topology).getCluster(clusterId);
    }

    public Set<DeviceId> getClusterDevices(Topology topology, TopologyCluster cluster) {
        Preconditions.checkNotNull((Object)cluster, (Object)CLUSTER_NULL);
        return this.defaultTopology(topology).getClusterDevices(cluster);
    }

    public Set<Link> getClusterLinks(Topology topology, TopologyCluster cluster) {
        Preconditions.checkNotNull((Object)cluster, (Object)CLUSTER_NULL);
        return this.defaultTopology(topology).getClusterLinks(cluster);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst) {
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        return this.defaultTopology(topology).getPaths(src, dst);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.getPaths(topology, src, dst, AdapterLinkWeigher.adapt((LinkWeight)weight));
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.defaultTopology(topology).getPaths(src, dst, weigher);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst) {
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        return this.defaultTopology(topology).getDisjointPaths(src, dst);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.getDisjointPaths(topology, src, dst, AdapterLinkWeigher.adapt((LinkWeight)weight));
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.defaultTopology(topology).getDisjointPaths(src, dst, weigher);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, Map<Link, Object> riskProfile) {
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        return this.defaultTopology(topology).getDisjointPaths(src, dst, riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight, Map<Link, Object> riskProfile) {
        return this.getDisjointPaths(topology, src, dst, AdapterLinkWeigher.adapt((LinkWeight)weight), riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher, Map<Link, Object> riskProfile) {
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.defaultTopology(topology).getDisjointPaths(src, dst, weigher, riskProfile);
    }

    public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECTION_POINT_NULL);
        return this.defaultTopology(topology).isInfrastructure(connectPoint);
    }

    public boolean isBroadcastPoint(Topology topology, ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECTION_POINT_NULL);
        return this.defaultTopology(topology).isBroadcastPoint(connectPoint);
    }
}

