/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.virtual.AbstractVnetService;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkPacketStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.provider.AbstractVirtualProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualPacketProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualPacketProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.packet.DefaultPacketRequest;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketEvent;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketProcessorEntry;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.packet.PacketStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkPacketManager
extends AbstractVnetService
implements PacketService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final VirtualNetworkService manager;
    protected VirtualNetworkPacketStore store;
    private final List<ProcessorEntry> processors = Lists.newCopyOnWriteArrayList();
    private NodeId localNodeId;
    private DeviceService deviceService;
    private FlowObjectiveService objectiveService;
    private VirtualProviderRegistryService providerRegistryService = null;
    private InternalPacketProviderService providerService = null;

    public VirtualNetworkPacketManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId);
        this.manager = virtualNetworkManager;
        ClusterService clusterService = (ClusterService)this.serviceDirectory.get(ClusterService.class);
        this.localNodeId = clusterService.getLocalNode().id();
        this.store = (VirtualNetworkPacketStore)this.serviceDirectory.get(VirtualNetworkPacketStore.class);
        this.store.setDelegate(this.networkId(), (StoreDelegate)new InternalStoreDelegate());
        this.deviceService = (DeviceService)this.manager.get(this.networkId(), DeviceService.class);
        this.objectiveService = (FlowObjectiveService)this.manager.get(this.networkId(), FlowObjectiveService.class);
        this.providerRegistryService = (VirtualProviderRegistryService)this.serviceDirectory.get(VirtualProviderRegistryService.class);
        this.providerService = new InternalPacketProviderService();
        this.providerRegistryService.registerProviderService(this.networkId(), (VirtualProviderService)this.providerService);
    }

    public void addProcessor(PacketProcessor processor, int priority) {
        int i;
        ProcessorEntry entry = new ProcessorEntry(processor, priority);
        for (i = 0; i < this.processors.size() && priority >= this.processors.get(i).priority(); ++i) {
        }
        this.processors.add(i, entry);
    }

    public void removeProcessor(PacketProcessor processor) {
        for (int i = 0; i < this.processors.size(); ++i) {
            if (this.processors.get(i).processor() != processor) continue;
            this.processors.remove(i);
            break;
        }
    }

    public List<PacketProcessorEntry> getProcessors() {
        return ImmutableList.copyOf(this.processors);
    }

    public void requestPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId) {
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, Optional.empty());
        this.store.requestPackets(this.networkId(), (PacketRequest)request);
    }

    public void requestPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId, Optional<DeviceId> deviceId) {
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, deviceId);
        this.store.requestPackets(this.networkId(), (PacketRequest)request);
    }

    public void cancelPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId) {
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, Optional.empty());
        this.store.cancelPackets(this.networkId(), (PacketRequest)request);
    }

    public void cancelPackets(TrafficSelector selector, PacketPriority priority, ApplicationId appId, Optional<DeviceId> deviceId) {
        DefaultPacketRequest request = new DefaultPacketRequest(selector, priority, appId, this.localNodeId, deviceId);
        this.store.cancelPackets(this.networkId(), (PacketRequest)request);
    }

    public List<PacketRequest> getRequests() {
        return this.store.existingRequests(this.networkId());
    }

    public void emit(OutboundPacket packet) {
        this.store.emit(this.networkId(), packet);
    }

    private void localEmit(NetworkId networkId, OutboundPacket packet) {
        Device device = this.deviceService.getDevice(packet.sendThrough());
        if (device == null) {
            return;
        }
        VirtualPacketProvider packetProvider = (VirtualPacketProvider)this.providerService.provider();
        if (packetProvider != null) {
            packetProvider.emit(networkId, packet);
        }
    }

    private void pushRule(final Device device, final PacketRequest request) {
        if (!device.type().equals((Object)Device.Type.VIRTUAL)) {
            return;
        }
        ForwardingObjective forwarding = this.createBuilder(request).add(new ObjectiveContext(){

            public void onError(Objective objective, ObjectiveError error) {
                VirtualNetworkPacketManager.this.log.warn("Failed to install packet request {} to {}: {}", new Object[]{request, device.id(), error});
            }
        });
        this.objectiveService.forward(device.id(), forwarding);
    }

    private void removeRule(final Device device, final PacketRequest request) {
        if (!device.type().equals((Object)Device.Type.VIRTUAL)) {
            return;
        }
        ForwardingObjective forwarding = this.createBuilder(request).remove(new ObjectiveContext(){

            public void onError(Objective objective, ObjectiveError error) {
                VirtualNetworkPacketManager.this.log.warn("Failed to withdraw packet request {} from {}: {}", new Object[]{request, device.id(), error});
            }
        });
        this.objectiveService.forward(device.id(), forwarding);
    }

    private void pushToAllDevices(PacketRequest request) {
        this.log.debug("Pushing packet request {} to all devices", (Object)request);
        for (Device device : this.deviceService.getDevices()) {
            this.pushRule(device, request);
        }
    }

    private void removeFromAllDevices(PacketRequest request) {
        this.deviceService.getAvailableDevices().forEach(d -> this.removeRule((Device)d, request));
    }

    private DefaultForwardingObjective.Builder createBuilder(PacketRequest request) {
        return DefaultForwardingObjective.builder().withPriority(request.priority().priorityValue()).withSelector(request.selector()).fromApp(request.appId()).withFlag(ForwardingObjective.Flag.VERSATILE).withTreatment(DefaultTrafficTreatment.builder().punt().build()).makePermanent();
    }

    protected class InternalStoreDelegate
    implements PacketStoreDelegate {
        protected InternalStoreDelegate() {
        }

        public void notify(PacketEvent event) {
            VirtualNetworkPacketManager.this.localEmit(VirtualNetworkPacketManager.this.networkId(), (OutboundPacket)event.subject());
        }

        public void requestPackets(PacketRequest request) {
            DeviceId deviceid = request.deviceId().orElse(null);
            if (deviceid != null) {
                VirtualNetworkPacketManager.this.pushRule(VirtualNetworkPacketManager.this.deviceService.getDevice(deviceid), request);
            } else {
                VirtualNetworkPacketManager.this.pushToAllDevices(request);
            }
            ((VirtualPacketProvider)VirtualNetworkPacketManager.this.providerService.provider()).startPacketHandling(VirtualNetworkPacketManager.this.networkId);
        }

        public void cancelPackets(PacketRequest request) {
            DeviceId deviceid = request.deviceId().orElse(null);
            if (deviceid != null) {
                VirtualNetworkPacketManager.this.removeRule(VirtualNetworkPacketManager.this.deviceService.getDevice(deviceid), request);
            } else {
                VirtualNetworkPacketManager.this.removeFromAllDevices(request);
            }
            ((VirtualPacketProvider)VirtualNetworkPacketManager.this.providerService.provider()).stopPacketHandling(VirtualNetworkPacketManager.this.networkId);
        }
    }

    private class ProcessorEntry
    implements PacketProcessorEntry {
        private final PacketProcessor processor;
        private final int priority;
        private long invocations = 0L;
        private long nanos = 0L;

        public ProcessorEntry(PacketProcessor processor, int priority) {
            this.processor = processor;
            this.priority = priority;
        }

        public PacketProcessor processor() {
            return this.processor;
        }

        public int priority() {
            return this.priority;
        }

        public long invocations() {
            return this.invocations;
        }

        public long totalNanos() {
            return this.nanos;
        }

        public long averageNanos() {
            return this.invocations > 0L ? this.nanos / this.invocations : 0L;
        }

        void addNanos(long nanos) {
            this.nanos += nanos;
            ++this.invocations;
        }
    }

    private class InternalPacketProviderService
    extends AbstractVirtualProviderService<VirtualPacketProvider>
    implements VirtualPacketProviderService {
        protected InternalPacketProviderService() {
            Set providerIds = VirtualNetworkPacketManager.this.providerRegistryService.getProvidersByService((VirtualProviderService)this);
            ProviderId providerId = (ProviderId)providerIds.stream().findFirst().get();
            VirtualPacketProvider provider = (VirtualPacketProvider)VirtualNetworkPacketManager.this.providerRegistryService.getProvider(providerId);
            this.setProvider((VirtualProvider)provider);
        }

        public void processPacket(PacketContext context) {
            for (ProcessorEntry entry : VirtualNetworkPacketManager.this.processors) {
                try {
                    long start = System.nanoTime();
                    entry.processor().process(context);
                    entry.addNanos(System.nanoTime() - start);
                }
                catch (Exception e) {
                    VirtualNetworkPacketManager.this.log.warn("Packet processor {} threw an exception", (Object)entry.processor(), (Object)e);
                }
            }
        }
    }
}

