/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.virtual.DefaultVirtualLink;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkIntent;
import org.onosproject.incubator.net.virtual.VirtualNetworkListener;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualNetworkStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkStoreDelegate;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.incubator.net.virtual.VnetService;
import org.onosproject.incubator.net.virtual.event.VirtualEvent;
import org.onosproject.incubator.net.virtual.event.VirtualListenerRegistryManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkDeviceManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkFlowObjectiveManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkFlowRuleManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkGroupManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkHostManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkIntentManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkLinkManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkPacketManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkPathManager;
import org.onosproject.incubator.net.virtual.impl.VirtualNetworkTopologyManager;
import org.onosproject.incubator.net.virtual.provider.VirtualNetworkProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualNetworkProviderRegistry;
import org.onosproject.incubator.net.virtual.provider.VirtualNetworkProviderService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VirtualNetworkManager
extends AbstractListenerProviderRegistry<VirtualNetworkEvent, VirtualNetworkListener, VirtualNetworkProvider, VirtualNetworkProviderService>
implements VirtualNetworkService,
VirtualNetworkAdminService,
VirtualNetworkProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String TENANT_NULL = "Tenant ID cannot be null";
    private static final String NETWORK_NULL = "Network ID cannot be null";
    private static final String DEVICE_NULL = "Device ID cannot be null";
    private static final String LINK_POINT_NULL = "Link end-point cannot be null";
    private static final String VIRTUAL_NETWORK_APP_ID_STRING = "org.onosproject.virtual-network";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private final InternalVirtualIntentListener intentListener = new InternalVirtualIntentListener();
    private VirtualNetworkStoreDelegate delegate = arg_0 -> ((VirtualNetworkManager)this).post(arg_0);
    private ServiceDirectory serviceDirectory = new DefaultServiceDirectory();
    private ApplicationId appId;
    private final Map<ServiceKey, VnetService> networkServices = Maps.newConcurrentMap();

    public void setStore(VirtualNetworkStore store) {
        this.store = store;
    }

    public void setIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(VirtualNetworkEvent.class, (EventSink)this.listenerRegistry);
        this.eventDispatcher.addSink(VirtualEvent.class, (EventSink)VirtualListenerRegistryManager.getInstance());
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.intentService.addListener((EventListener)this.intentListener);
        this.appId = this.coreService.registerApplication(VIRTUAL_NETWORK_APP_ID_STRING);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(VirtualNetworkEvent.class);
        this.eventDispatcher.removeSink(VirtualEvent.class);
        this.intentService.removeListener((EventListener)this.intentListener);
        this.log.info("Stopped");
    }

    public void registerTenantId(TenantId tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)TENANT_NULL);
        this.store.addTenantId(tenantId);
    }

    public void unregisterTenantId(TenantId tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)TENANT_NULL);
        this.store.removeTenantId(tenantId);
    }

    public Set<TenantId> getTenantIds() {
        return this.store.getTenantIds();
    }

    public VirtualNetwork createVirtualNetwork(TenantId tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)TENANT_NULL);
        return this.store.addNetwork(tenantId);
    }

    public void removeVirtualNetwork(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        this.store.removeNetwork(networkId);
    }

    public VirtualDevice createVirtualDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return this.store.addDevice(networkId, deviceId);
    }

    public void removeVirtualDevice(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        this.store.removeDevice(networkId, deviceId);
    }

    public VirtualHost createVirtualHost(NetworkId networkId, HostId hostId, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)hostId, (Object)DEVICE_NULL);
        return this.store.addHost(networkId, hostId, mac, vlan, location, ips);
    }

    public void removeVirtualHost(NetworkId networkId, HostId hostId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)hostId, (Object)DEVICE_NULL);
        this.store.removeHost(networkId, hostId);
    }

    public VirtualLink createVirtualLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)src, (Object)LINK_POINT_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)LINK_POINT_NULL);
        ConnectPoint physicalSrc = this.mapVirtualToPhysicalPort(networkId, src);
        Preconditions.checkNotNull((Object)physicalSrc, (Object)LINK_POINT_NULL);
        ConnectPoint physicalDst = this.mapVirtualToPhysicalPort(networkId, dst);
        Preconditions.checkNotNull((Object)physicalDst, (Object)LINK_POINT_NULL);
        VirtualNetworkProvider provider = (VirtualNetworkProvider)this.getProvider(DefaultVirtualLink.PID);
        Link.State state = Link.State.INACTIVE;
        if (provider != null) {
            boolean traversable = provider.isTraversable(physicalSrc, physicalDst);
            state = traversable ? Link.State.ACTIVE : Link.State.INACTIVE;
        }
        return this.store.addLink(networkId, src, dst, state, null);
    }

    private ConnectPoint mapVirtualToPhysicalPort(NetworkId networkId, ConnectPoint virtualCp) {
        Set ports = this.store.getPorts(networkId, virtualCp.deviceId());
        for (VirtualPort port : ports) {
            if (!port.number().equals((Object)virtualCp.port())) continue;
            return new ConnectPoint((ElementId)port.realizedBy().deviceId(), port.realizedBy().port());
        }
        return null;
    }

    private ConnectPoint mapPhysicalToVirtualToPort(NetworkId networkId, ConnectPoint physicalCp) {
        Set ports = this.store.getPorts(networkId, null);
        for (VirtualPort port : ports) {
            if (!port.realizedBy().deviceId().equals((Object)physicalCp.elementId()) || !port.realizedBy().port().equals((Object)physicalCp.port())) continue;
            return new ConnectPoint(port.element().id(), port.number());
        }
        return null;
    }

    public void removeVirtualLink(NetworkId networkId, ConnectPoint src, ConnectPoint dst) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)src, (Object)LINK_POINT_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)LINK_POINT_NULL);
        this.store.removeLink(networkId, src, dst);
    }

    public VirtualPort createVirtualPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber, ConnectPoint realizedBy) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)"Port description cannot be null");
        return this.store.addPort(networkId, deviceId, portNumber, realizedBy);
    }

    public void bindVirtualPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber, ConnectPoint realizedBy) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)"Port description cannot be null");
        Preconditions.checkNotNull((Object)realizedBy, (Object)"Physical port description cannot be null");
        this.store.bindPort(networkId, deviceId, portNumber, realizedBy);
    }

    public void removeVirtualPort(NetworkId networkId, DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)"Port number cannot be null");
        this.store.removePort(networkId, deviceId, portNumber);
    }

    public ServiceDirectory getServiceDirectory() {
        return this.serviceDirectory;
    }

    public Set<VirtualNetwork> getVirtualNetworks(TenantId tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)TENANT_NULL);
        return this.store.getNetworks(tenantId);
    }

    private VirtualNetwork getVirtualNetwork(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        return this.store.getNetwork(networkId);
    }

    public Set<VirtualDevice> getVirtualDevices(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        return this.store.getDevices(networkId);
    }

    public Set<VirtualHost> getVirtualHosts(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        return this.store.getHosts(networkId);
    }

    public Set<VirtualLink> getVirtualLinks(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        return this.store.getLinks(networkId);
    }

    public Set<VirtualPort> getVirtualPorts(NetworkId networkId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        return this.store.getPorts(networkId, deviceId);
    }

    public Set<DeviceId> getPhysicalDevices(NetworkId networkId, VirtualDevice virtualDevice) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        Preconditions.checkNotNull((Object)virtualDevice, (Object)"Virtual device cannot be null");
        Set<VirtualPort> virtualPortSet = this.getVirtualPorts(networkId, virtualDevice.id());
        Set physicalDeviceSet = Sets.newConcurrentHashSet();
        virtualPortSet.forEach(virtualPort -> {
            if (virtualPort.realizedBy() != null) {
                physicalDeviceSet.add(virtualPort.realizedBy().deviceId());
            }
        });
        return physicalDeviceSet;
    }

    public <T> T get(NetworkId networkId, Class<T> serviceClass) {
        Preconditions.checkNotNull((Object)networkId, (Object)NETWORK_NULL);
        ServiceKey serviceKey = this.networkServiceKey(networkId, serviceClass);
        VnetService service = this.lookup(serviceKey);
        if (service == null) {
            service = this.create(serviceKey);
        }
        return (T)service;
    }

    public ApplicationId getVirtualNetworkApplicationId(NetworkId networkId) {
        return this.appId;
    }

    private VnetService lookup(ServiceKey serviceKey) {
        return this.networkServices.get(serviceKey);
    }

    private <T> ServiceKey networkServiceKey(NetworkId networkId, Class<T> serviceClass) {
        return new ServiceKey(networkId, serviceClass);
    }

    private VnetService create(ServiceKey serviceKey) {
        Object service;
        VirtualNetwork network = this.getVirtualNetwork(serviceKey.networkId());
        Preconditions.checkNotNull((Object)network, (Object)NETWORK_NULL);
        if (serviceKey.serviceClass.equals(DeviceService.class)) {
            service = new VirtualNetworkDeviceManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(LinkService.class)) {
            service = new VirtualNetworkLinkManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(TopologyService.class)) {
            service = new VirtualNetworkTopologyManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(IntentService.class)) {
            service = new VirtualNetworkIntentManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(HostService.class)) {
            service = new VirtualNetworkHostManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(PathService.class)) {
            service = new VirtualNetworkPathManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(FlowRuleService.class)) {
            service = new VirtualNetworkFlowRuleManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(PacketService.class)) {
            service = new VirtualNetworkPacketManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(GroupService.class)) {
            service = new VirtualNetworkGroupManager(this, network.id());
        } else if (serviceKey.serviceClass.equals(FlowObjectiveService.class)) {
            service = new VirtualNetworkFlowObjectiveManager(this, network.id());
        } else {
            return null;
        }
        this.networkServices.put(serviceKey, (VnetService)service);
        return service;
    }

    protected VirtualNetworkProviderService createProviderService(VirtualNetworkProvider provider) {
        return new InternalVirtualNetworkProviderService(provider);
    }

    protected void bindStore(VirtualNetworkStore virtualNetworkStore) {
        this.store = virtualNetworkStore;
    }

    protected void unbindStore(VirtualNetworkStore virtualNetworkStore) {
        if (this.store == virtualNetworkStore) {
            this.store = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalVirtualNetworkProviderService
    extends AbstractProviderService<VirtualNetworkProvider>
    implements VirtualNetworkProviderService {
        InternalVirtualNetworkProviderService(VirtualNetworkProvider provider) {
            super((Provider)provider);
        }

        public void topologyChanged(Set<Set<ConnectPoint>> clusters) {
            Set<TenantId> tenantIds = VirtualNetworkManager.this.getTenantIds();
            tenantIds.forEach(tenantId -> {
                Set<VirtualNetwork> virtualNetworks = VirtualNetworkManager.this.getVirtualNetworks((TenantId)tenantId);
                virtualNetworks.forEach(virtualNetwork -> {
                    Set<VirtualLink> virtualLinks = VirtualNetworkManager.this.getVirtualLinks(virtualNetwork.id());
                    virtualLinks.forEach(virtualLink -> {
                        if (this.isVirtualLinkInCluster(virtualNetwork.id(), (VirtualLink)virtualLink, clusters)) {
                            VirtualNetworkManager.this.store.updateLink(virtualLink, virtualLink.tunnelId(), Link.State.ACTIVE);
                        } else {
                            VirtualNetworkManager.this.store.updateLink(virtualLink, virtualLink.tunnelId(), Link.State.INACTIVE);
                        }
                    });
                });
            });
        }

        private boolean isVirtualLinkInCluster(NetworkId networkId, VirtualLink virtualLink, Set<Set<ConnectPoint>> clusters) {
            ConnectPoint srcPhysicalCp = VirtualNetworkManager.this.mapVirtualToPhysicalPort(networkId, virtualLink.src());
            ConnectPoint dstPhysicalCp = VirtualNetworkManager.this.mapVirtualToPhysicalPort(networkId, virtualLink.dst());
            boolean[] foundSrc = new boolean[]{false};
            boolean[] foundDst = new boolean[]{false};
            clusters.forEach(connectPoints -> {
                connectPoints.forEach(connectPoint -> {
                    if (connectPoint.equals((Object)srcPhysicalCp)) {
                        foundSrc[0] = true;
                    } else if (connectPoint.equals((Object)dstPhysicalCp)) {
                        foundDst[0] = true;
                    }
                });
                if (foundSrc[0] && foundDst[0]) {
                    return;
                }
            });
            return foundSrc[0] && foundDst[0];
        }

        public void tunnelUp(NetworkId networkId, ConnectPoint src, ConnectPoint dst, TunnelId tunnelId) {
            VirtualLink virtualLink;
            ConnectPoint srcVirtualCp = VirtualNetworkManager.this.mapPhysicalToVirtualToPort(networkId, src);
            ConnectPoint dstVirtualCp = VirtualNetworkManager.this.mapPhysicalToVirtualToPort(networkId, dst);
            if (srcVirtualCp == null || dstVirtualCp == null) {
                VirtualNetworkManager.this.log.error("Src or dst virtual connection point was not found.");
            }
            if ((virtualLink = VirtualNetworkManager.this.store.getLink(networkId, srcVirtualCp, dstVirtualCp)) != null) {
                VirtualNetworkManager.this.store.updateLink(virtualLink, tunnelId, Link.State.ACTIVE);
            }
        }

        public void tunnelDown(NetworkId networkId, ConnectPoint src, ConnectPoint dst, TunnelId tunnelId) {
            VirtualLink virtualLink;
            ConnectPoint srcVirtualCp = VirtualNetworkManager.this.mapPhysicalToVirtualToPort(networkId, src);
            ConnectPoint dstVirtualCp = VirtualNetworkManager.this.mapPhysicalToVirtualToPort(networkId, dst);
            if (srcVirtualCp == null || dstVirtualCp == null) {
                VirtualNetworkManager.this.log.error("Src or dst virtual connection point was not found.");
            }
            if ((virtualLink = VirtualNetworkManager.this.store.getLink(networkId, srcVirtualCp, dstVirtualCp)) != null) {
                VirtualNetworkManager.this.store.updateLink(virtualLink, tunnelId, Link.State.INACTIVE);
            }
        }
    }

    private class InternalVirtualIntentListener
    implements IntentListener {
        private InternalVirtualIntentListener() {
        }

        public void event(IntentEvent event) {
            if (!this.isRelevant(event)) {
                return;
            }
            VirtualNetworkIntent intent = (VirtualNetworkIntent)event.subject();
            switch ((IntentEvent.Type)event.type()) {
                case INSTALL_REQ: {
                    VirtualNetworkManager.this.store.addOrUpdateIntent((Intent)intent, IntentState.INSTALL_REQ);
                    break;
                }
                case INSTALLED: {
                    VirtualNetworkManager.this.store.addOrUpdateIntent((Intent)intent, IntentState.INSTALLED);
                    break;
                }
                case WITHDRAW_REQ: {
                    VirtualNetworkManager.this.store.addOrUpdateIntent((Intent)intent, IntentState.WITHDRAW_REQ);
                    break;
                }
                case WITHDRAWN: {
                    VirtualNetworkManager.this.store.addOrUpdateIntent((Intent)intent, IntentState.WITHDRAWN);
                    break;
                }
                case FAILED: {
                    VirtualNetworkManager.this.store.addOrUpdateIntent((Intent)intent, IntentState.FAILED);
                    break;
                }
                case CORRUPT: {
                    VirtualNetworkManager.this.store.addOrUpdateIntent((Intent)intent, IntentState.CORRUPT);
                    break;
                }
                case PURGED: {
                    VirtualNetworkManager.this.store.removeIntent(intent.key());
                }
            }
        }

        public boolean isRelevant(IntentEvent event) {
            return event.subject() instanceof VirtualNetworkIntent;
        }
    }

    private static class ServiceKey {
        final NetworkId networkId;
        final Class serviceClass;

        ServiceKey(NetworkId networkId, Class serviceClass) {
            Preconditions.checkNotNull((Object)networkId, (Object)VirtualNetworkManager.NETWORK_NULL);
            this.networkId = networkId;
            this.serviceClass = serviceClass;
        }

        public NetworkId networkId() {
            return this.networkId;
        }

        public Class serviceClass() {
            return this.serviceClass;
        }

        public int hashCode() {
            return Objects.hash(this.networkId, this.serviceClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ServiceKey) {
                ServiceKey that = (ServiceKey)obj;
                return Objects.equals(this.networkId, that.networkId) && Objects.equals(this.serviceClass, that.serviceClass);
            }
            return false;
        }
    }
}

