/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;

public class VirtualNetworkLinkManager
extends AbstractVirtualListenerManager<LinkEvent, LinkListener>
implements LinkService {
    private static final String DEVICE_NULL = "Device cannot be null";
    private static final String CONNECT_POINT_NULL = "Connect point cannot be null";

    public VirtualNetworkLinkManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId, LinkEvent.class);
    }

    public int getLinkCount() {
        return this.manager.getVirtualLinks(this.networkId()).size();
    }

    public Iterable<Link> getLinks() {
        return this.manager.getVirtualLinks(this.networkId()).stream().collect(Collectors.toSet());
    }

    public Iterable<Link> getActiveLinks() {
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> link.state().equals((Object)Link.State.ACTIVE)).collect(Collectors.toSet());
    }

    public Set<Link> getDeviceLinks(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> deviceId.equals((Object)link.src().elementId()) || deviceId.equals((Object)link.dst().elementId())).collect(Collectors.toSet());
    }

    public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> deviceId.equals((Object)link.dst().elementId())).collect(Collectors.toSet());
    }

    public Set<Link> getDeviceIngressLinks(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> deviceId.equals((Object)link.src().elementId())).collect(Collectors.toSet());
    }

    public Set<Link> getLinks(ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECT_POINT_NULL);
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> connectPoint.equals((Object)link.src()) || connectPoint.equals((Object)link.dst())).collect(Collectors.toSet());
    }

    public Set<Link> getEgressLinks(ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECT_POINT_NULL);
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> connectPoint.equals((Object)link.dst())).collect(Collectors.toSet());
    }

    public Set<Link> getIngressLinks(ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECT_POINT_NULL);
        return this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> connectPoint.equals((Object)link.src())).collect(Collectors.toSet());
    }

    public Link getLink(ConnectPoint src, ConnectPoint dst) {
        Preconditions.checkNotNull((Object)src, (Object)CONNECT_POINT_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)CONNECT_POINT_NULL);
        Optional<VirtualLink> foundLink = this.manager.getVirtualLinks(this.networkId()).stream().filter(link -> src.equals((Object)link.src()) && dst.equals((Object)link.dst())).findFirst();
        if (foundLink.isPresent()) {
            return (Link)foundLink.get();
        }
        return null;
    }
}

