/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkIntent;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualNetworkStore;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.incubator.net.virtual.VnetService;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.WorkPartitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkIntentManager
extends AbstractVirtualListenerManager<IntentEvent, IntentListener>
implements IntentService,
VnetService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String NETWORK_ID_NULL = "Network ID cannot be null";
    private static final String DEVICE_NULL = "Device cannot be null";
    private static final String INTENT_NULL = "Intent cannot be null";
    private static final String KEY_NULL = "Key cannot be null";
    private static final String APP_ID_NULL = "Intent app identifier cannot be null";
    private static final String INTENT_KEY_NULL = "Intent key cannot be null";
    private static final String CP_NULL = "Connect Point cannot be null";
    protected IntentService intentService;
    protected VirtualNetworkStore store = (VirtualNetworkStore)this.serviceDirectory.get(VirtualNetworkStore.class);
    protected WorkPartitionService partitionService;

    public VirtualNetworkIntentManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId, IntentEvent.class);
        this.intentService = (IntentService)this.serviceDirectory.get(IntentService.class);
        this.partitionService = (WorkPartitionService)this.serviceDirectory.get(WorkPartitionService.class);
    }

    public void submit(Intent intent) {
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        Preconditions.checkState((boolean)(intent instanceof VirtualNetworkIntent), (Object)"Only VirtualNetworkIntent is supported.");
        Preconditions.checkArgument((boolean)this.validateIntent((VirtualNetworkIntent)intent), (Object)"Invalid Intent");
        this.intentService.submit(intent);
    }

    private boolean validateIntent(VirtualNetworkIntent intent) {
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        Preconditions.checkNotNull((Object)intent.networkId(), (Object)NETWORK_ID_NULL);
        Preconditions.checkNotNull((Object)intent.appId(), (Object)APP_ID_NULL);
        Preconditions.checkNotNull((Object)intent.key(), (Object)INTENT_KEY_NULL);
        ConnectPoint ingressPoint = intent.ingressPoint();
        ConnectPoint egressPoint = intent.egressPoint();
        return this.validateConnectPoint(ingressPoint) && this.validateConnectPoint(egressPoint);
    }

    private boolean validateConnectPoint(ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)CP_NULL);
        Port port = this.getPort(connectPoint.deviceId(), connectPoint.port());
        return port != null;
    }

    private Port getPort(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Optional<VirtualPort> foundPort = this.manager.getVirtualPorts(this.networkId(), deviceId).stream().filter(port -> port.number().equals((Object)portNumber)).findFirst();
        if (foundPort.isPresent()) {
            return (Port)foundPort.get();
        }
        return null;
    }

    public void withdraw(Intent intent) {
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        this.store.getTunnelIds(intent).forEach(tunnelId -> {
            Key intentKey = Key.of((String)((String)tunnelId.id()), (ApplicationId)intent.appId());
            Intent physicalIntent = this.intentService.getIntent(intentKey);
            Preconditions.checkNotNull((Object)physicalIntent, (Object)INTENT_NULL);
            this.log.debug("Withdrawing pt-pt intent: " + physicalIntent);
            this.intentService.withdraw(physicalIntent);
        });
        this.log.debug("Withdrawing virtual intent: " + intent);
        this.intentService.withdraw(intent);
    }

    public void purge(Intent intent) {
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        this.store.getTunnelIds(intent).forEach(tunnelId -> {
            Key intentKey = Key.of((String)((String)tunnelId.id()), (ApplicationId)intent.appId());
            Intent physicalIntent = this.intentService.getIntent(intentKey);
            Preconditions.checkNotNull((Object)physicalIntent, (Object)INTENT_NULL);
            this.intentService.purge(physicalIntent);
            this.store.removeTunnelId(intent, tunnelId);
        });
        this.intentService.purge(intent);
    }

    public Intent getIntent(Key key) {
        Preconditions.checkNotNull((Object)key, (Object)KEY_NULL);
        return this.store.getIntent(key);
    }

    public Iterable<Intent> getIntents() {
        return this.store.getIntents();
    }

    public void addPending(IntentData intentData) {
        this.intentService.addPending(intentData);
    }

    public Iterable<IntentData> getIntentData() {
        return this.store.getIntentData();
    }

    public long getIntentCount() {
        return Iterators.size(this.getIntents().iterator());
    }

    public IntentState getIntentState(Key intentKey) {
        Preconditions.checkNotNull((Object)intentKey, (Object)KEY_NULL);
        return Optional.ofNullable(this.store.getIntentData(intentKey)).map(IntentData::state).orElse(null);
    }

    public List<Intent> getInstallableIntents(Key intentKey) {
        ArrayList<Intent> intents = new ArrayList<Intent>();
        this.getIntentData().forEach(intentData -> {
            if (intentData.intent().key().equals((Object)intentKey)) {
                intents.addAll(intentData.installables());
            }
        });
        return intents;
    }

    public boolean isLocal(Key intentKey) {
        Preconditions.checkNotNull((Object)intentKey, (Object)INTENT_KEY_NULL);
        Intent intent = this.getIntent(intentKey);
        Preconditions.checkNotNull((Object)intent, (Object)INTENT_NULL);
        return this.partitionService.isMine((Object)intentKey, Key::hash);
    }

    public Iterable<Intent> getPending() {
        return null;
    }
}

