/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;

public class VirtualNetworkHostManager
extends AbstractVirtualListenerManager<HostEvent, HostListener>
implements HostService {
    private static final String HOST_NULL = "Host ID cannot be null";

    public VirtualNetworkHostManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId, HostEvent.class);
    }

    public int getHostCount() {
        return this.manager.getVirtualHosts(this.networkId()).size();
    }

    public Iterable<Host> getHosts() {
        return this.getHostsColl();
    }

    public Host getHost(HostId hostId) {
        Preconditions.checkNotNull((Object)hostId, (Object)HOST_NULL);
        Optional<VirtualHost> foundHost = this.manager.getVirtualHosts(this.networkId()).stream().filter(host -> hostId.equals((Object)host.id())).findFirst();
        if (foundHost.isPresent()) {
            return (Host)foundHost.get();
        }
        return null;
    }

    private Collection<Host> getHostsColl() {
        return this.manager.getVirtualHosts(this.networkId()).stream().collect(Collectors.toSet());
    }

    private Set<Host> filter(Collection<Host> collection, Predicate<Host> predicate) {
        return collection.stream().filter(predicate).collect(Collectors.toSet());
    }

    public Set<Host> getHostsByVlan(VlanId vlanId) {
        Preconditions.checkNotNull((Object)vlanId, (Object)"VLAN identifier cannot be null");
        return this.filter(this.getHostsColl(), host -> Objects.equals(host.vlan(), vlanId));
    }

    public Set<Host> getHostsByMac(MacAddress mac) {
        Preconditions.checkNotNull((Object)mac, (Object)"MAC address cannot be null");
        return this.filter(this.getHostsColl(), host -> Objects.equals(host.mac(), mac));
    }

    public Set<Host> getHostsByIp(IpAddress ip) {
        Preconditions.checkNotNull((Object)ip, (Object)"IP address cannot be null");
        return this.filter(this.getHostsColl(), host -> host.ipAddresses().contains(ip));
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)connectPoint, (Object)"Connect point cannot be null");
        return this.filter(this.getHostsColl(), host -> host.location().equals((Object)connectPoint));
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"Device identifier cannot be null");
        return this.filter(this.getHostsColl(), host -> host.location().deviceId().equals((Object)deviceId));
    }

    public void startMonitoringIp(IpAddress ip) {
    }

    public void stopMonitoringIp(IpAddress ip) {
    }

    public void requestMac(IpAddress ip) {
    }
}

