/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkGroupStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.incubator.net.virtual.provider.AbstractVirtualProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualGroupProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualGroupProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkGroupManager
extends AbstractVirtualListenerManager<GroupEvent, GroupListener>
implements GroupService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final VirtualNetworkGroupStore store = (VirtualNetworkGroupStore)this.serviceDirectory.get(VirtualNetworkGroupStore.class);
    private VirtualProviderRegistryService providerRegistryService = null;
    private VirtualGroupProviderService innerProviderService;
    private InternalStoreDelegate storeDelegate;
    private DeviceService deviceService;
    private boolean purgeOnDisconnection = false;

    public VirtualNetworkGroupManager(VirtualNetworkService manager, NetworkId networkId) {
        super(manager, networkId, GroupEvent.class);
        this.deviceService = (DeviceService)manager.get(networkId, DeviceService.class);
        this.providerRegistryService = (VirtualProviderRegistryService)this.serviceDirectory.get(VirtualProviderRegistryService.class);
        this.innerProviderService = new InternalGroupProviderService();
        this.providerRegistryService.registerProviderService(this.networkId(), (VirtualProviderService)this.innerProviderService);
        this.storeDelegate = new InternalStoreDelegate();
        this.store.setDelegate(networkId, (StoreDelegate)this.storeDelegate);
        this.log.info("Started");
    }

    public void addGroup(GroupDescription groupDesc) {
        this.store.storeGroupDescription(this.networkId(), groupDesc);
    }

    public Group getGroup(DeviceId deviceId, GroupKey appCookie) {
        return this.store.getGroup(this.networkId(), deviceId, appCookie);
    }

    public void addBucketsToGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
        this.store.updateGroupDescription(this.networkId(), deviceId, oldCookie, VirtualNetworkGroupStore.UpdateType.ADD, buckets, newCookie);
    }

    public void removeBucketsFromGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
        this.store.updateGroupDescription(this.networkId(), deviceId, oldCookie, VirtualNetworkGroupStore.UpdateType.REMOVE, buckets, newCookie);
    }

    public void setBucketsForGroup(DeviceId deviceId, GroupKey oldCookie, GroupBuckets buckets, GroupKey newCookie, ApplicationId appId) {
        this.store.updateGroupDescription(this.networkId(), deviceId, oldCookie, VirtualNetworkGroupStore.UpdateType.SET, buckets, newCookie);
    }

    public void purgeGroupEntries(DeviceId deviceId) {
        this.store.purgeGroupEntry(this.networkId(), deviceId);
    }

    public void purgeGroupEntries() {
        this.store.purgeGroupEntries(this.networkId());
    }

    public void removeGroup(DeviceId deviceId, GroupKey appCookie, ApplicationId appId) {
        this.store.deleteGroupDescription(this.networkId(), deviceId, appCookie);
    }

    public Iterable<Group> getGroups(DeviceId deviceId, ApplicationId appId) {
        return this.store.getGroups(this.networkId(), deviceId);
    }

    public Iterable<Group> getGroups(DeviceId deviceId) {
        return this.store.getGroups(this.networkId(), deviceId);
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_REMOVED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    DeviceId deviceId = ((Device)event.subject()).id();
                    if (VirtualNetworkGroupManager.this.deviceService.isAvailable(deviceId)) break;
                    VirtualNetworkGroupManager.this.log.debug("Device {} became un available; clearing initial audit status", (Object)event.type(), (Object)((Device)event.subject()).id());
                    VirtualNetworkGroupManager.this.store.deviceInitialAuditCompleted(VirtualNetworkGroupManager.this.networkId(), ((Device)event.subject()).id(), false);
                    if (!VirtualNetworkGroupManager.this.purgeOnDisconnection) break;
                    VirtualNetworkGroupManager.this.store.purgeGroupEntry(VirtualNetworkGroupManager.this.networkId(), deviceId);
                    break;
                }
            }
        }
    }

    private class InternalStoreDelegate
    implements GroupStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(GroupEvent event) {
            Group group = (Group)event.subject();
            VirtualGroupProvider groupProvider = (VirtualGroupProvider)VirtualNetworkGroupManager.this.innerProviderService.provider();
            GroupOperations groupOps = null;
            switch ((GroupEvent.Type)event.type()) {
                case GROUP_ADD_REQUESTED: {
                    VirtualNetworkGroupManager.this.log.debug("GROUP_ADD_REQUESTED for Group {} on device {}", (Object)group.id(), (Object)group.deviceId());
                    GroupOperation groupAddOp = GroupOperation.createAddGroupOperation((GroupId)group.id(), (GroupDescription.Type)group.type(), (GroupBuckets)group.buckets());
                    groupOps = new GroupOperations(Collections.singletonList(groupAddOp));
                    groupProvider.performGroupOperation(VirtualNetworkGroupManager.this.networkId(), group.deviceId(), groupOps);
                    break;
                }
                case GROUP_UPDATE_REQUESTED: {
                    VirtualNetworkGroupManager.this.log.debug("GROUP_UPDATE_REQUESTED for Group {} on device {}", (Object)group.id(), (Object)group.deviceId());
                    GroupOperation groupModifyOp = GroupOperation.createModifyGroupOperation((GroupId)group.id(), (GroupDescription.Type)group.type(), (GroupBuckets)group.buckets());
                    groupOps = new GroupOperations(Collections.singletonList(groupModifyOp));
                    groupProvider.performGroupOperation(VirtualNetworkGroupManager.this.networkId(), group.deviceId(), groupOps);
                    break;
                }
                case GROUP_REMOVE_REQUESTED: {
                    VirtualNetworkGroupManager.this.log.debug("GROUP_REMOVE_REQUESTED for Group {} on device {}", (Object)group.id(), (Object)group.deviceId());
                    GroupOperation groupDeleteOp = GroupOperation.createDeleteGroupOperation((GroupId)group.id(), (GroupDescription.Type)group.type());
                    groupOps = new GroupOperations(Collections.singletonList(groupDeleteOp));
                    groupProvider.performGroupOperation(VirtualNetworkGroupManager.this.networkId(), group.deviceId(), groupOps);
                    break;
                }
                case GROUP_ADDED: 
                case GROUP_UPDATED: 
                case GROUP_REMOVED: 
                case GROUP_ADD_FAILED: 
                case GROUP_UPDATE_FAILED: 
                case GROUP_REMOVE_FAILED: 
                case GROUP_BUCKET_FAILOVER: {
                    VirtualNetworkGroupManager.this.post((Event)event);
                    break;
                }
            }
        }
    }

    private class InternalGroupProviderService
    extends AbstractVirtualProviderService<VirtualGroupProvider>
    implements VirtualGroupProviderService {
        protected InternalGroupProviderService() {
            Set providerIds = VirtualNetworkGroupManager.this.providerRegistryService.getProvidersByService((VirtualProviderService)this);
            ProviderId providerId = (ProviderId)providerIds.stream().findFirst().get();
            VirtualGroupProvider provider = (VirtualGroupProvider)VirtualNetworkGroupManager.this.providerRegistryService.getProvider(providerId);
            this.setProvider((VirtualProvider)provider);
        }

        public void groupOperationFailed(DeviceId deviceId, GroupOperation operation) {
            VirtualNetworkGroupManager.this.store.groupOperationFailed(VirtualNetworkGroupManager.this.networkId(), deviceId, operation);
        }

        public void pushGroupMetrics(DeviceId deviceId, Collection<Group> groupEntries) {
            VirtualNetworkGroupManager.this.log.trace("Received group metrics from device {}", (Object)deviceId);
            this.checkValidity();
            VirtualNetworkGroupManager.this.store.pushGroupMetrics(VirtualNetworkGroupManager.this.networkId(), deviceId, groupEntries);
        }

        public void notifyOfFailovers(Collection<Group> failoverGroups) {
            VirtualNetworkGroupManager.this.store.notifyOfFailovers(VirtualNetworkGroupManager.this.networkId(), failoverGroups);
        }
    }
}

