/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkFlowRuleStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.incubator.net.virtual.provider.AbstractVirtualProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualFlowRuleProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualFlowRuleProviderService;
import org.onosproject.incubator.net.virtual.provider.VirtualProvider;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderRegistryService;
import org.onosproject.incubator.net.virtual.provider.VirtualProviderService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleOperation;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkFlowRuleManager
extends AbstractVirtualListenerManager<FlowRuleEvent, FlowRuleListener>
implements FlowRuleService {
    private static final String VIRTUAL_FLOW_OP_TOPIC = "virtual-flow-ops-ids";
    private static final String THREAD_GROUP_NAME = "onos/virtual-flowservice";
    private static final String DEVICE_INSTALLER_PATTERN = "device-installer-%d";
    private static final String OPERATION_PATTERN = "operations-%d";
    public static final String FLOW_RULE_NULL = "FlowRule cannot be null";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final VirtualNetworkFlowRuleStore store;
    private final DeviceService deviceService;
    protected ExecutorService deviceInstallers = Executors.newFixedThreadPool(32, Tools.groupedThreads((String)"onos/virtual-flowservice", (String)"device-installer-%d", (Logger)this.log));
    protected ExecutorService operationsService = Executors.newFixedThreadPool(32, Tools.groupedThreads((String)"onos/virtual-flowservice", (String)"operations-%d", (Logger)this.log));
    private IdGenerator idGenerator;
    private final Map<Long, FlowOperationsProcessor> pendingFlowOperations = new ConcurrentHashMap<Long, FlowOperationsProcessor>();
    private VirtualProviderRegistryService providerRegistryService = null;
    private InternalFlowRuleProviderService innerProviderService = null;
    private final FlowRuleStoreDelegate storeDelegate;

    public VirtualNetworkFlowRuleManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId, FlowRuleEvent.class);
        this.store = (VirtualNetworkFlowRuleStore)this.serviceDirectory.get(VirtualNetworkFlowRuleStore.class);
        this.idGenerator = ((CoreService)this.serviceDirectory.get(CoreService.class)).getIdGenerator(VIRTUAL_FLOW_OP_TOPIC + this.networkId().toString());
        this.providerRegistryService = (VirtualProviderRegistryService)this.serviceDirectory.get(VirtualProviderRegistryService.class);
        this.innerProviderService = new InternalFlowRuleProviderService();
        this.providerRegistryService.registerProviderService(this.networkId(), (VirtualProviderService)this.innerProviderService);
        this.deviceService = (DeviceService)this.manager.get(networkId, DeviceService.class);
        this.storeDelegate = new InternalStoreDelegate();
        this.store.setDelegate(networkId, (StoreDelegate)this.storeDelegate);
    }

    public int getFlowRuleCount() {
        return this.store.getFlowRuleCount(this.networkId());
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        return this.store.getFlowEntries(this.networkId(), deviceId);
    }

    public void applyFlowRules(FlowRule ... flowRules) {
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        for (FlowRule flowRule : flowRules) {
            builder.add(flowRule);
        }
        this.apply(builder.build());
    }

    public void purgeFlowRules(DeviceId deviceId) {
        this.store.purgeFlowRule(this.networkId(), deviceId);
    }

    public void removeFlowRules(FlowRule ... flowRules) {
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        for (FlowRule flowRule : flowRules) {
            builder.remove(flowRule);
        }
        this.apply(builder.build());
    }

    public void removeFlowRulesById(ApplicationId id) {
        this.removeFlowRules((FlowRule[])Iterables.toArray(this.getFlowRulesById(id), FlowRule.class));
    }

    public Iterable<FlowRule> getFlowRulesById(ApplicationId id) {
        DeviceService deviceService = (DeviceService)this.manager.get(this.networkId(), DeviceService.class);
        HashSet flowEntries = Sets.newHashSet();
        for (Device d : deviceService.getDevices()) {
            for (FlowEntry flowEntry : this.store.getFlowEntries(this.networkId(), d.id())) {
                if (flowEntry.appId() != id.id()) continue;
                flowEntries.add(flowEntry);
            }
        }
        return flowEntries;
    }

    public Iterable<FlowEntry> getFlowEntriesById(ApplicationId id) {
        DeviceService deviceService = (DeviceService)this.manager.get(this.networkId(), DeviceService.class);
        HashSet flowEntries = Sets.newHashSet();
        for (Device d : deviceService.getDevices()) {
            for (FlowEntry flowEntry : this.store.getFlowEntries(this.networkId(), d.id())) {
                if (flowEntry.appId() != id.id()) continue;
                flowEntries.add(flowEntry);
            }
        }
        return flowEntries;
    }

    public Iterable<FlowRule> getFlowRulesByGroupId(ApplicationId appId, short groupId) {
        DeviceService deviceService = (DeviceService)this.manager.get(this.networkId(), DeviceService.class);
        HashSet matches = Sets.newHashSet();
        long toLookUp = (long)appId.id() << 16 | (long)groupId;
        for (Device d : deviceService.getDevices()) {
            for (FlowEntry flowEntry : this.store.getFlowEntries(this.networkId(), d.id())) {
                if (flowEntry.id().value() >>> 32 != toLookUp) continue;
                matches.add(flowEntry);
            }
        }
        return matches;
    }

    public void apply(FlowRuleOperations ops) {
        this.operationsService.execute(new FlowOperationsProcessor(ops));
    }

    public Iterable<TableStatisticsEntry> getFlowTableStatistics(DeviceId deviceId) {
        return this.store.getTableStatistics(this.networkId(), deviceId);
    }

    private static FlowRuleBatchEntry.FlowRuleOperation mapOperationType(FlowRuleOperation.Type input) {
        switch (input) {
            case ADD: {
                return FlowRuleBatchEntry.FlowRuleOperation.ADD;
            }
            case MODIFY: {
                return FlowRuleBatchEntry.FlowRuleOperation.MODIFY;
            }
            case REMOVE: {
                return FlowRuleBatchEntry.FlowRuleOperation.REMOVE;
            }
        }
        throw new UnsupportedOperationException("Unknown flow rule type " + input);
    }

    private class InternalStoreDelegate
    implements FlowRuleStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(FlowRuleBatchEvent event) {
            FlowRuleBatchRequest request = (FlowRuleBatchRequest)event.subject();
            switch ((FlowRuleBatchEvent.Type)event.type()) {
                case BATCH_OPERATION_REQUESTED: {
                    request.ops().forEach(op -> {
                        switch ((FlowRuleBatchEntry.FlowRuleOperation)op.operator()) {
                            case ADD: {
                                VirtualNetworkFlowRuleManager.this.post((Event)new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADD_REQUESTED, (FlowRule)op.target()));
                                break;
                            }
                            case REMOVE: {
                                VirtualNetworkFlowRuleManager.this.post((Event)new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVE_REQUESTED, (FlowRule)op.target()));
                                break;
                            }
                            case MODIFY: {
                                break;
                            }
                            default: {
                                VirtualNetworkFlowRuleManager.this.log.warn("Unknown flow operation operator: {}", (Object)op.operator());
                            }
                        }
                    });
                    DeviceId deviceId = event.deviceId();
                    FlowRuleBatchOperation batchOperation = request.asBatchOperation(deviceId);
                    VirtualFlowRuleProvider provider = (VirtualFlowRuleProvider)VirtualNetworkFlowRuleManager.this.innerProviderService.provider();
                    if (provider == null) break;
                    provider.executeBatch(VirtualNetworkFlowRuleManager.this.networkId, batchOperation);
                    break;
                }
                case BATCH_OPERATION_COMPLETED: {
                    FlowOperationsProcessor fops = (FlowOperationsProcessor)VirtualNetworkFlowRuleManager.this.pendingFlowOperations.remove(((FlowRuleBatchRequest)event.subject()).batchId());
                    if (fops == null) {
                        return;
                    }
                    if (event.result().isSuccess()) {
                        fops.satisfy(event.deviceId());
                        break;
                    }
                    fops.fail(event.deviceId(), event.result().failedItems());
                    break;
                }
            }
        }
    }

    private final class InternalFlowRuleProviderService
    extends AbstractVirtualProviderService<VirtualFlowRuleProvider>
    implements VirtualFlowRuleProviderService {
        final Map<FlowEntry, Long> firstSeen = Maps.newConcurrentMap();
        final Map<FlowEntry, Long> lastSeen = Maps.newConcurrentMap();

        private InternalFlowRuleProviderService() {
            Set providerIds = VirtualNetworkFlowRuleManager.this.providerRegistryService.getProvidersByService((VirtualProviderService)this);
            ProviderId providerId = (ProviderId)providerIds.stream().findFirst().get();
            VirtualFlowRuleProvider provider = (VirtualFlowRuleProvider)VirtualNetworkFlowRuleManager.this.providerRegistryService.getProvider(providerId);
            this.setProvider((VirtualProvider)provider);
        }

        public void flowRemoved(FlowEntry flowEntry) {
            Preconditions.checkNotNull((Object)flowEntry, (Object)VirtualNetworkFlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            this.lastSeen.remove(flowEntry);
            this.firstSeen.remove(flowEntry);
            FlowEntry stored = VirtualNetworkFlowRuleManager.this.store.getFlowEntry(VirtualNetworkFlowRuleManager.this.networkId(), (FlowRule)flowEntry);
            if (stored == null) {
                VirtualNetworkFlowRuleManager.this.log.debug("Rule already evicted from store: {}", (Object)flowEntry);
                return;
            }
            if (flowEntry.reason() == FlowRule.FlowRemoveReason.HARD_TIMEOUT) {
                ((DefaultFlowEntry)stored).setState(FlowEntry.FlowEntryState.REMOVED);
            }
            FlowRuleEvent event = null;
            switch (stored.state()) {
                case ADDED: 
                case PENDING_ADD: {
                    ((VirtualFlowRuleProvider)this.provider()).applyFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), new FlowRule[]{stored});
                    break;
                }
                case PENDING_REMOVE: 
                case REMOVED: {
                    event = VirtualNetworkFlowRuleManager.this.store.removeFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), stored);
                    break;
                }
            }
            if (event != null) {
                VirtualNetworkFlowRuleManager.this.log.debug("Flow {} removed", (Object)flowEntry);
                VirtualNetworkFlowRuleManager.this.post((Event)event);
            }
        }

        private void flowMissing(FlowEntry flowRule) {
            Preconditions.checkNotNull((Object)flowRule, (Object)VirtualNetworkFlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            FlowRuleEvent event = null;
            switch (flowRule.state()) {
                case PENDING_REMOVE: 
                case REMOVED: {
                    event = VirtualNetworkFlowRuleManager.this.store.removeFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), flowRule);
                    break;
                }
                case ADDED: 
                case PENDING_ADD: {
                    event = VirtualNetworkFlowRuleManager.this.store.pendingFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), flowRule);
                    try {
                        ((VirtualFlowRuleProvider)this.provider()).applyFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), new FlowRule[]{flowRule});
                    }
                    catch (UnsupportedOperationException e) {
                        VirtualNetworkFlowRuleManager.this.log.warn(e.getMessage());
                        if (!(flowRule instanceof DefaultFlowEntry)) break;
                        ((DefaultFlowEntry)flowRule).setState(FlowEntry.FlowEntryState.FAILED);
                    }
                    break;
                }
                default: {
                    VirtualNetworkFlowRuleManager.this.log.debug("Flow {} has not been installed.", (Object)flowRule);
                }
            }
            if (event != null) {
                VirtualNetworkFlowRuleManager.this.log.debug("Flow {} removed", (Object)flowRule);
                VirtualNetworkFlowRuleManager.this.post((Event)event);
            }
        }

        private void extraneousFlow(FlowRule flowRule) {
            Preconditions.checkNotNull((Object)flowRule, (Object)VirtualNetworkFlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            ((VirtualFlowRuleProvider)this.provider()).removeFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), new FlowRule[]{flowRule});
            VirtualNetworkFlowRuleManager.this.log.debug("Flow {} is on switch but not in store.", (Object)flowRule);
        }

        private void flowAdded(FlowEntry flowEntry) {
            Preconditions.checkNotNull((Object)flowEntry, (Object)VirtualNetworkFlowRuleManager.FLOW_RULE_NULL);
            if (this.checkRuleLiveness(flowEntry, VirtualNetworkFlowRuleManager.this.store.getFlowEntry(VirtualNetworkFlowRuleManager.this.networkId(), (FlowRule)flowEntry))) {
                FlowRuleEvent event = VirtualNetworkFlowRuleManager.this.store.addOrUpdateFlowRule(VirtualNetworkFlowRuleManager.this.networkId(), flowEntry);
                if (event == null) {
                    VirtualNetworkFlowRuleManager.this.log.debug("No flow store event generated.");
                } else {
                    VirtualNetworkFlowRuleManager.this.log.trace("Flow {} {}", (Object)flowEntry, (Object)event.type());
                    VirtualNetworkFlowRuleManager.this.post((Event)event);
                }
            } else {
                VirtualNetworkFlowRuleManager.this.log.debug("Removing flow rules....");
                VirtualNetworkFlowRuleManager.this.removeFlowRules(new FlowRule[]{flowEntry});
            }
        }

        private boolean checkRuleLiveness(FlowEntry swRule, FlowEntry storedRule) {
            Long last;
            if (storedRule == null) {
                return false;
            }
            if (storedRule.isPermanent()) {
                return true;
            }
            long timeout = storedRule.timeout() * 1000;
            long currentTime = System.currentTimeMillis();
            if (storedRule.hardTimeout() != 0) {
                if (!this.firstSeen.containsKey(storedRule)) {
                    this.firstSeen.put(storedRule, currentTime);
                } else {
                    Long first = this.firstSeen.get(storedRule);
                    long hardTimeout = storedRule.hardTimeout() * 1000;
                    if (currentTime - first > hardTimeout) {
                        return false;
                    }
                }
            }
            if (storedRule.packets() != swRule.packets()) {
                this.lastSeen.put(storedRule, currentTime);
                return true;
            }
            if (!this.lastSeen.containsKey(storedRule)) {
                this.lastSeen.put(storedRule, storedRule.lastSeen());
            }
            return (last = this.lastSeen.get(storedRule)) != null && currentTime - last <= timeout;
        }

        public void pushFlowMetrics(DeviceId deviceId, Iterable<FlowEntry> flowEntries) {
            this.pushFlowMetricsInternal(deviceId, flowEntries, true);
        }

        public void pushFlowMetricsWithoutFlowMissing(DeviceId deviceId, Iterable<FlowEntry> flowEntries) {
            this.pushFlowMetricsInternal(deviceId, flowEntries, false);
        }

        private void pushFlowMetricsInternal(DeviceId deviceId, Iterable<FlowEntry> flowEntries, boolean useMissingFlow) {
            HashMap storedRules = Maps.newHashMap();
            VirtualNetworkFlowRuleManager.this.store.getFlowEntries(VirtualNetworkFlowRuleManager.this.networkId(), deviceId).forEach(f -> storedRules.put(f, f));
            for (FlowEntry rule : flowEntries) {
                try {
                    FlowEntry storedRule = (FlowEntry)storedRules.remove(rule);
                    if (storedRule == null) continue;
                    if (storedRule.id().equals((Object)rule.id())) {
                        this.flowAdded(rule);
                        continue;
                    }
                    this.extraneousFlow((FlowRule)rule);
                    this.flowMissing(storedRule);
                }
                catch (Exception e) {
                    VirtualNetworkFlowRuleManager.this.log.debug("Can't process added or extra rule {}", (Object)e.getMessage());
                }
            }
            if (useMissingFlow) {
                for (FlowEntry rule : storedRules.keySet()) {
                    try {
                        VirtualNetworkFlowRuleManager.this.log.debug("Adding rule in store, but not on switch {}", (Object)rule);
                        this.flowMissing(rule);
                    }
                    catch (Exception e) {
                        VirtualNetworkFlowRuleManager.this.log.debug("Can't add missing flow rule:", (Throwable)e);
                    }
                }
            }
        }

        public void batchOperationCompleted(long batchId, CompletedBatchOperation operation) {
            VirtualNetworkFlowRuleManager.this.store.batchOperationComplete(VirtualNetworkFlowRuleManager.this.networkId(), FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(batchId, Collections.emptySet()), (CompletedBatchOperation)operation));
        }

        public void pushTableStatistics(DeviceId deviceId, List<TableStatisticsEntry> tableStats) {
            VirtualNetworkFlowRuleManager.this.store.updateTableStatistics(VirtualNetworkFlowRuleManager.this.networkId(), deviceId, tableStats);
        }
    }

    private class FlowOperationsProcessor
    implements Runnable {
        private final FlowRuleOperations fops;
        private final List<Set<FlowRuleOperation>> stages;
        private final Set<DeviceId> pendingDevices = new HashSet<DeviceId>();
        private boolean hasFailed = false;

        FlowOperationsProcessor(FlowRuleOperations ops) {
            this.stages = Lists.newArrayList((Iterable)ops.stages());
            this.fops = ops;
        }

        @Override
        public synchronized void run() {
            if (!this.stages.isEmpty()) {
                this.process(this.stages.remove(0));
            } else if (!this.hasFailed) {
                this.fops.callback().onSuccess(this.fops);
            }
        }

        private void process(Set<FlowRuleOperation> ops) {
            ArrayListMultimap perDeviceBatches = ArrayListMultimap.create();
            for (FlowRuleOperation op : ops) {
                perDeviceBatches.put((Object)op.rule().deviceId(), (Object)new FlowRuleBatchEntry(VirtualNetworkFlowRuleManager.mapOperationType(op.type()), op.rule()));
            }
            this.pendingDevices.addAll(perDeviceBatches.keySet());
            for (DeviceId deviceId : perDeviceBatches.keySet()) {
                long id = VirtualNetworkFlowRuleManager.this.idGenerator.getNewId();
                FlowRuleBatchOperation b = new FlowRuleBatchOperation(perDeviceBatches.get((Object)deviceId), deviceId, id);
                VirtualNetworkFlowRuleManager.this.pendingFlowOperations.put(id, this);
                VirtualNetworkFlowRuleManager.this.deviceInstallers.execute(() -> VirtualNetworkFlowRuleManager.this.store.storeBatch(VirtualNetworkFlowRuleManager.this.networkId(), b));
            }
        }

        synchronized void satisfy(DeviceId devId) {
            this.pendingDevices.remove(devId);
            if (this.pendingDevices.isEmpty()) {
                VirtualNetworkFlowRuleManager.this.operationsService.execute(this);
            }
        }

        synchronized void fail(DeviceId devId, Set<? extends FlowRule> failures) {
            this.hasFailed = true;
            this.pendingDevices.remove(devId);
            if (this.pendingDevices.isEmpty()) {
                VirtualNetworkFlowRuleManager.this.operationsService.execute(this);
            }
            FlowRuleOperations.Builder failedOpsBuilder = FlowRuleOperations.builder();
            failures.forEach(arg_0 -> ((FlowRuleOperations.Builder)failedOpsBuilder).add(arg_0));
            this.fops.callback().onError(failedOpsBuilder.build());
        }
    }
}

