/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.virtual.AbstractVnetService;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkFlowObjectiveStore;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.FlowObjectiveStoreDelegate;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.flowobjective.ObjectiveEvent;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupKey;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkFlowObjectiveManager
extends AbstractVnetService
implements FlowObjectiveService {
    public static final int INSTALL_RETRY_ATTEMPTS = 5;
    public static final long INSTALL_RETRY_INTERVAL = 1000L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected DeviceService deviceService;
    protected FlowRuleService flowRuleService;
    protected VirtualNetworkFlowObjectiveStore virtualFlowObjectiveStore;
    protected FlowObjectiveStore flowObjectiveStore;
    private final FlowObjectiveStoreDelegate delegate;
    private final PipelinerContext context = new InnerPipelineContext();
    private final Map<DeviceId, Pipeliner> pipeliners = Maps.newConcurrentMap();
    private final Map<Integer, Set<PendingNext>> pendingForwards = Maps.newConcurrentMap();
    private Map<Integer, DeviceId> nextToDevice = Maps.newConcurrentMap();
    private ExecutorService executorService;

    public VirtualNetworkFlowObjectiveManager(VirtualNetworkService manager, NetworkId networkId) {
        super(manager, networkId);
        this.deviceService = (DeviceService)manager.get(this.networkId(), DeviceService.class);
        this.flowRuleService = (FlowRuleService)manager.get(this.networkId(), FlowRuleService.class);
        this.executorService = BoundedThreadPool.newFixedThreadPool((int)4, (ThreadFactory)Tools.groupedThreads((String)"onos/virtual/objective-installer", (String)"%d", (Logger)this.log));
        this.virtualFlowObjectiveStore = (VirtualNetworkFlowObjectiveStore)this.serviceDirectory.get(VirtualNetworkFlowObjectiveStore.class);
        this.delegate = new InternalStoreDelegate();
        this.virtualFlowObjectiveStore.setDelegate(this.networkId(), (StoreDelegate)this.delegate);
        this.flowObjectiveStore = new StoreConvertor();
    }

    public void filter(DeviceId deviceId, FilteringObjective filteringObjective) {
        this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)filteringObjective));
    }

    public void forward(DeviceId deviceId, ForwardingObjective forwardingObjective) {
        if (this.queueObjective(deviceId, forwardingObjective)) {
            return;
        }
        this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)forwardingObjective));
    }

    public void next(DeviceId deviceId, NextObjective nextObjective) {
        this.nextToDevice.put(nextObjective.id(), deviceId);
        this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)nextObjective));
    }

    public int allocateNextId() {
        return this.flowObjectiveStore.allocateNextId();
    }

    public void initPolicy(String policy) {
    }

    public List<String> getNextMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        Map allnexts = this.flowObjectiveStore.getAllGroups();
        for (Map.Entry e : allnexts.entrySet()) {
            Pipeliner pipeliner;
            List nextMappings;
            DeviceId deviceId = this.nextToDevice.get(e.getKey());
            mappings.add("NextId " + e.getKey() + ": " + (deviceId != null ? deviceId : "nextId not in this onos instance"));
            if (deviceId == null || (nextMappings = (pipeliner = this.getDevicePipeliner(deviceId)).getNextMappings((NextGroup)e.getValue())) == null) continue;
            mappings.addAll(nextMappings);
        }
        return mappings;
    }

    public List<String> getPendingFlowObjectives() {
        ArrayList<String> pendingNexts = new ArrayList<String>();
        for (Integer nextId : this.pendingForwards.keySet()) {
            Set<PendingNext> pnext = this.pendingForwards.get(nextId);
            StringBuilder pend = new StringBuilder();
            pend.append("Next Id: ").append(Integer.toString(nextId)).append(" :: ");
            for (PendingNext pn : pnext) {
                pend.append(Integer.toString(pn.forwardingObjective().id())).append(" ");
            }
            pendingNexts.add(pend.toString());
        }
        return pendingNexts;
    }

    public List<String> getPendingNexts() {
        return this.getPendingFlowObjectives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueObjective(DeviceId deviceId, ForwardingObjective fwd) {
        if (fwd.nextId() == null || this.flowObjectiveStore.getNextGroup(fwd.nextId()) != null) {
            return false;
        }
        boolean queued = false;
        Map<Integer, Set<PendingNext>> map = this.pendingForwards;
        synchronized (map) {
            if (this.flowObjectiveStore.getNextGroup(fwd.nextId()) == null) {
                this.pendingForwards.compute(fwd.nextId(), (id, pending) -> {
                    PendingNext next = new PendingNext(deviceId, fwd);
                    if (pending == null) {
                        return Sets.newHashSet((Object[])new PendingNext[]{next});
                    }
                    pending.add(next);
                    return pending;
                });
                queued = true;
            }
        }
        if (queued) {
            this.log.debug("Queued forwarding objective {} for nextId {} meant for device {}", new Object[]{fwd.id(), fwd.nextId(), deviceId});
        }
        return queued;
    }

    private Pipeliner getDevicePipeliner(DeviceId deviceId) {
        return this.pipeliners.computeIfAbsent(deviceId, this::initPipelineHandler);
    }

    private Pipeliner initPipelineHandler(DeviceId deviceId) {
        DefaultVirtualDevicePipeline pipeliner = new DefaultVirtualDevicePipeline();
        pipeliner.init(deviceId, this.context);
        return pipeliner;
    }

    private class DefaultVirtualDevicePipeline
    extends AbstractHandlerBehaviour
    implements Pipeliner {
        private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private DeviceId deviceId;
        private Cache<Integer, NextObjective> pendingNext;
        private KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{SingleGroup.class}).register(new Class[]{byte[].class}).build("DefaultVirtualDevicePipeline");

        private DefaultVirtualDevicePipeline() {
        }

        public void init(DeviceId deviceId, PipelinerContext context) {
            this.deviceId = deviceId;
            this.pendingNext = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
                if (notification.getCause() == RemovalCause.EXPIRED) {
                    ((NextObjective)notification.getValue()).context().ifPresent(c -> c.onError((Objective)notification.getValue(), ObjectiveError.FLOWINSTALLATIONFAILED));
                }
            }).build();
        }

        public void filter(FilteringObjective filter) {
            TrafficTreatment.Builder actions;
            switch (filter.type()) {
                case PERMIT: {
                    actions = filter.meta() == null ? DefaultTrafficTreatment.builder().punt() : DefaultTrafficTreatment.builder((TrafficTreatment)filter.meta());
                    break;
                }
                case DENY: {
                    actions = filter.meta() == null ? DefaultTrafficTreatment.builder() : DefaultTrafficTreatment.builder((TrafficTreatment)filter.meta());
                    actions.drop();
                    break;
                }
                default: {
                    this.log.warn("Unknown filter type: {}", (Object)filter.type());
                    actions = DefaultTrafficTreatment.builder().drop();
                }
            }
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            filter.conditions().forEach(arg_0 -> ((TrafficSelector.Builder)selector).add(arg_0));
            if (filter.key() != null) {
                selector.add(filter.key());
            }
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(actions.build()).fromApp(filter.appId()).withPriority(filter.priority());
            if (filter.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(filter.timeout());
            }
            this.installObjective(ruleBuilder, (Objective)filter);
        }

        public void forward(ForwardingObjective fwd) {
            TrafficSelector selector = fwd.selector();
            if (fwd.treatment() != null) {
                FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(fwd.treatment());
                if (fwd.permanent()) {
                    ruleBuilder.makePermanent();
                } else {
                    ruleBuilder.makeTemporary(fwd.timeout());
                }
                this.installObjective(ruleBuilder, (Objective)fwd);
            } else {
                NextObjective nextObjective = (NextObjective)this.pendingNext.getIfPresent((Object)fwd.nextId());
                if (nextObjective != null) {
                    this.pendingNext.invalidate((Object)fwd.nextId());
                    nextObjective.next().forEach(treat -> {
                        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(treat);
                        if (fwd.permanent()) {
                            ruleBuilder.makePermanent();
                        } else {
                            ruleBuilder.makeTemporary(fwd.timeout());
                        }
                        this.installObjective(ruleBuilder, (Objective)fwd);
                    });
                } else {
                    fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
                }
            }
        }

        private void installObjective(FlowRule.Builder ruleBuilder, final Objective objective) {
            FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
            switch (objective.op()) {
                case ADD: {
                    flowBuilder.add(ruleBuilder.build());
                    break;
                }
                case REMOVE: {
                    flowBuilder.remove(ruleBuilder.build());
                    break;
                }
                default: {
                    this.log.warn("Unknown operation {}", (Object)objective.op());
                }
            }
            VirtualNetworkFlowObjectiveManager.this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

                public void onSuccess(FlowRuleOperations ops) {
                    objective.context().ifPresent(context -> context.onSuccess(objective));
                }

                public void onError(FlowRuleOperations ops) {
                    objective.context().ifPresent(context -> context.onError(objective, ObjectiveError.FLOWINSTALLATIONFAILED));
                }
            }));
        }

        public void next(NextObjective nextObjective) {
            this.pendingNext.put((Object)nextObjective.id(), (Object)nextObjective);
            VirtualNetworkFlowObjectiveManager.this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new SingleGroup((GroupKey)new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()))));
            nextObjective.context().ifPresent(context -> context.onSuccess((Objective)nextObjective));
        }

        public List<String> getNextMappings(NextGroup nextGroup) {
            return null;
        }

        private class SingleGroup
        implements NextGroup {
            private final GroupKey key;

            public SingleGroup(GroupKey key) {
                this.key = key;
            }

            public GroupKey key() {
                return this.key;
            }

            public byte[] data() {
                return DefaultVirtualDevicePipeline.this.appKryo.serialize((Object)this.key);
            }
        }
    }

    private class StoreConvertor
    implements FlowObjectiveStore {
        private StoreConvertor() {
        }

        public void setDelegate(FlowObjectiveStoreDelegate delegate) {
            VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.setDelegate(VirtualNetworkFlowObjectiveManager.this.networkId(), (StoreDelegate)delegate);
        }

        public void unsetDelegate(FlowObjectiveStoreDelegate delegate) {
            VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.unsetDelegate(VirtualNetworkFlowObjectiveManager.this.networkId(), (StoreDelegate)delegate);
        }

        public boolean hasDelegate() {
            return VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.hasDelegate(VirtualNetworkFlowObjectiveManager.this.networkId());
        }

        public void putNextGroup(Integer nextId, NextGroup group) {
            VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.putNextGroup(VirtualNetworkFlowObjectiveManager.this.networkId(), nextId, group);
        }

        public NextGroup getNextGroup(Integer nextId) {
            return VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.getNextGroup(VirtualNetworkFlowObjectiveManager.this.networkId(), nextId);
        }

        public NextGroup removeNextGroup(Integer nextId) {
            return VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.removeNextGroup(VirtualNetworkFlowObjectiveManager.this.networkId(), nextId);
        }

        public Map<Integer, NextGroup> getAllGroups() {
            return VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.getAllGroups(VirtualNetworkFlowObjectiveManager.this.networkId());
        }

        public int allocateNextId() {
            return VirtualNetworkFlowObjectiveManager.this.virtualFlowObjectiveStore.allocateNextId(VirtualNetworkFlowObjectiveManager.this.networkId());
        }
    }

    private class PendingNext {
        private final DeviceId deviceId;
        private final ForwardingObjective fwd;

        public PendingNext(DeviceId deviceId, ForwardingObjective fwd) {
            this.deviceId = deviceId;
            this.fwd = fwd;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public ForwardingObjective forwardingObjective() {
            return this.fwd;
        }

        public int hashCode() {
            return Objects.hash(this.deviceId, this.fwd);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PendingNext)) {
                return false;
            }
            PendingNext other = (PendingNext)obj;
            return this.deviceId.equals((Object)other.deviceId) && this.fwd.equals(other.fwd);
        }
    }

    private class InnerPipelineContext
    implements PipelinerContext {
        private InnerPipelineContext() {
        }

        public ServiceDirectory directory() {
            return VirtualNetworkFlowObjectiveManager.this.serviceDirectory;
        }

        public FlowObjectiveStore store() {
            return VirtualNetworkFlowObjectiveManager.this.flowObjectiveStore;
        }
    }

    private class InternalStoreDelegate
    implements FlowObjectiveStoreDelegate {
        private InternalStoreDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(ObjectiveEvent event) {
            if (event.type() == ObjectiveEvent.Type.ADD) {
                Set pending;
                VirtualNetworkFlowObjectiveManager.this.log.debug("Received notification of obj event {}", (Object)event);
                Map map = VirtualNetworkFlowObjectiveManager.this.pendingForwards;
                synchronized (map) {
                    pending = (Set)VirtualNetworkFlowObjectiveManager.this.pendingForwards.remove(event.subject());
                }
                if (pending == null) {
                    VirtualNetworkFlowObjectiveManager.this.log.debug("Nothing pending for this obj event {}", (Object)event);
                    return;
                }
                VirtualNetworkFlowObjectiveManager.this.log.debug("Processing {} pending forwarding objectives for nextId {}", (Object)pending.size(), event.subject());
                pending.forEach(p -> VirtualNetworkFlowObjectiveManager.this.getDevicePipeliner(p.deviceId()).forward(p.forwardingObjective()));
            }
        }
    }

    private class ObjectiveInstaller
    implements Runnable {
        private final DeviceId deviceId;
        private final Objective objective;
        private final int numAttempts;

        public ObjectiveInstaller(DeviceId deviceId, Objective objective) {
            this(deviceId, objective, 1);
        }

        public ObjectiveInstaller(DeviceId deviceId, Objective objective, int attemps) {
            this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
            this.objective = (Objective)Preconditions.checkNotNull((Object)objective);
            this.numAttempts = (Integer)Preconditions.checkNotNull((Object)attemps);
        }

        @Override
        public void run() {
            try {
                Pipeliner pipeliner = VirtualNetworkFlowObjectiveManager.this.getDevicePipeliner(this.deviceId);
                if (pipeliner != null) {
                    if (this.objective instanceof NextObjective) {
                        pipeliner.next((NextObjective)this.objective);
                    } else if (this.objective instanceof ForwardingObjective) {
                        pipeliner.forward((ForwardingObjective)this.objective);
                    } else {
                        pipeliner.filter((FilteringObjective)this.objective);
                    }
                } else if (this.numAttempts < 5) {
                    Thread.sleep(1000L);
                    VirtualNetworkFlowObjectiveManager.this.executorService.execute(new ObjectiveInstaller(this.deviceId, this.objective, this.numAttempts + 1));
                } else {
                    this.objective.context().ifPresent(c -> c.onError(this.objective, ObjectiveError.NOPIPELINER));
                }
            }
            catch (Exception e) {
                VirtualNetworkFlowObjectiveManager.this.log.warn("Exception while installing flow objective", (Throwable)e);
            }
        }
    }
}

