/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.virtual.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkListener;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.incubator.net.virtual.event.AbstractVirtualListenerManager;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;

public class VirtualNetworkDeviceManager
extends AbstractVirtualListenerManager<DeviceEvent, DeviceListener>
implements DeviceService {
    private static final String TYPE_NULL = "Type cannot be null";
    private static final String DEVICE_NULL = "Device cannot be null";
    private static final String PORT_NUMBER_NULL = "PortNumber cannot be null";
    private VirtualNetworkListener virtualNetworkListener = new InternalVirtualNetworkListener();

    public VirtualNetworkDeviceManager(VirtualNetworkService virtualNetworkManager, NetworkId networkId) {
        super(virtualNetworkManager, networkId, DeviceEvent.class);
        this.manager.addListener((EventListener)this.virtualNetworkListener);
    }

    public int getDeviceCount() {
        return this.manager.getVirtualDevices(this.networkId).size();
    }

    public Iterable<Device> getDevices() {
        return this.manager.getVirtualDevices(this.networkId).stream().collect(Collectors.toSet());
    }

    public Iterable<Device> getDevices(Device.Type type) {
        Preconditions.checkNotNull((Object)type, (Object)TYPE_NULL);
        return this.manager.getVirtualDevices(this.networkId).stream().filter(device -> type.equals((Object)device.type())).collect(Collectors.toSet());
    }

    public Iterable<Device> getAvailableDevices() {
        return this.getDevices();
    }

    public Iterable<Device> getAvailableDevices(Device.Type type) {
        return this.getDevices(type);
    }

    public Device getDevice(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Optional<VirtualDevice> foundDevice = this.manager.getVirtualDevices(this.networkId).stream().filter(device -> deviceId.equals((Object)device.id())).findFirst();
        if (foundDevice.isPresent()) {
            return (Device)foundDevice.get();
        }
        return null;
    }

    public MastershipRole getRole(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return MastershipRole.MASTER;
    }

    public List<Port> getPorts(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return this.manager.getVirtualPorts(this.networkId, deviceId).stream().collect(Collectors.toList());
    }

    public List<PortStatistics> getPortStatistics(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return ImmutableList.of();
    }

    public List<PortStatistics> getPortDeltaStatistics(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        return ImmutableList.of();
    }

    public PortStatistics getStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)PORT_NUMBER_NULL);
        return null;
    }

    public PortStatistics getDeltaStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)PORT_NUMBER_NULL);
        return null;
    }

    public Port getPort(DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_NULL);
        Optional<VirtualPort> foundPort = this.manager.getVirtualPorts(this.networkId, deviceId).stream().filter(port -> port.number().equals((Object)portNumber)).findFirst();
        if (foundPort.isPresent()) {
            return (Port)foundPort.get();
        }
        return null;
    }

    public boolean isAvailable(DeviceId deviceId) {
        return this.getDevice(deviceId) != null;
    }

    public String localStatus(DeviceId deviceId) {
        return null;
    }

    private class InternalVirtualNetworkListener
    implements VirtualNetworkListener {
        private InternalVirtualNetworkListener() {
        }

        public boolean isRelevant(VirtualNetworkEvent event) {
            return VirtualNetworkDeviceManager.this.networkId().equals(event.subject());
        }

        public void event(VirtualNetworkEvent event) {
            switch ((VirtualNetworkEvent.Type)event.type()) {
                case VIRTUAL_DEVICE_ADDED: {
                    VirtualNetworkDeviceManager.this.post((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, (Device)event.virtualDevice()));
                    break;
                }
                case VIRTUAL_DEVICE_UPDATED: {
                    VirtualNetworkDeviceManager.this.post((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_UPDATED, (Device)event.virtualDevice()));
                    break;
                }
                case VIRTUAL_DEVICE_REMOVED: {
                    VirtualNetworkDeviceManager.this.post((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, (Device)event.virtualDevice()));
                    break;
                }
                case VIRTUAL_PORT_ADDED: {
                    VirtualNetworkDeviceManager.this.post((Event)new DeviceEvent(DeviceEvent.Type.PORT_ADDED, (Device)event.virtualDevice(), (Port)event.virtualPort()));
                    break;
                }
                case VIRTUAL_PORT_UPDATED: {
                    VirtualNetworkDeviceManager.this.post((Event)new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, (Device)event.virtualDevice(), (Port)event.virtualPort()));
                    break;
                }
                case VIRTUAL_PORT_REMOVED: {
                    VirtualNetworkDeviceManager.this.post((Event)new DeviceEvent(DeviceEvent.Type.PORT_REMOVED, (Device)event.virtualDevice(), (Port)event.virtualPort()));
                    break;
                }
            }
        }
    }
}

