/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.tunnel.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelAdminService;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelEvent;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelListener;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelProviderRegistry;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.incubator.net.tunnel.TunnelStore;
import org.onosproject.incubator.net.tunnel.TunnelStoreDelegate;
import org.onosproject.incubator.net.tunnel.TunnelSubscription;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Path;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class TunnelManager
extends AbstractListenerProviderRegistry<TunnelEvent, TunnelListener, TunnelProvider, TunnelProviderService>
implements TunnelService,
TunnelAdminService,
TunnelProviderRegistry {
    private static final String TUNNNEL_ID_NULL = "Tunnel ID cannot be null";
    private static final String TUNNNEL_NULL = "Tunnel cannot be null";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TunnelStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelStore store;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(TunnelEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(TunnelEvent.class);
        this.log.info("Stopped");
    }

    public void removeTunnel(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNNEL_ID_NULL);
        Tunnel tunnel = this.store.queryTunnel(tunnelId);
        if (tunnel != null) {
            this.store.deleteTunnel(tunnelId);
            if (tunnel.providerId() != null) {
                TunnelProvider provider = (TunnelProvider)this.getProvider(tunnel.providerId());
                if (provider != null) {
                    provider.releaseTunnel(tunnel);
                }
            } else {
                Set ids = this.getProviders();
                for (ProviderId providerId : ids) {
                    TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                    provider.releaseTunnel(tunnel);
                }
            }
        }
    }

    public void updateTunnel(Tunnel tunnel, Path path) {
        this.store.createOrUpdateTunnel(tunnel);
        if (tunnel.providerId() != null) {
            TunnelProvider provider = (TunnelProvider)this.getProvider(tunnel.providerId());
            if (provider != null) {
                provider.updateTunnel(tunnel, path);
            }
        } else {
            Set ids = this.getProviders();
            for (ProviderId providerId : ids) {
                TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                provider.updateTunnel(tunnel, path);
            }
        }
    }

    public void updateTunnelState(Tunnel tunnel, Tunnel.State state) {
        Tunnel storedTunnel = this.store.queryTunnel(tunnel.tunnelId());
        this.store.createOrUpdateTunnel(storedTunnel, state);
    }

    public void removeTunnels(TunnelEndPoint src, TunnelEndPoint dst, ProviderId producerName) {
        Collection setTunnels = this.store.queryTunnel(src, dst);
        if (!setTunnels.isEmpty()) {
            this.store.deleteTunnel(src, dst, producerName);
            for (Tunnel tunnel : setTunnels) {
                if (producerName != null && !tunnel.providerId().equals((Object)producerName)) continue;
                if (tunnel.providerId() != null) {
                    TunnelProvider provider = (TunnelProvider)this.getProvider(tunnel.providerId());
                    if (provider == null) continue;
                    provider.releaseTunnel(tunnel);
                    continue;
                }
                Set ids = this.getProviders();
                for (ProviderId providerId : ids) {
                    TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                    provider.releaseTunnel(tunnel);
                }
            }
        }
    }

    public void removeTunnels(TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, ProviderId producerName) {
        Collection setTunnels = this.store.queryTunnel(src, dst);
        if (!setTunnels.isEmpty()) {
            this.store.deleteTunnel(src, dst, type, producerName);
            for (Tunnel tunnel : setTunnels) {
                if (producerName != null && !tunnel.providerId().equals((Object)producerName) || !type.equals((Object)tunnel.type())) continue;
                if (tunnel.providerId() != null) {
                    TunnelProvider provider = (TunnelProvider)this.getProvider(tunnel.providerId());
                    if (provider == null) continue;
                    provider.releaseTunnel(tunnel);
                    continue;
                }
                Set ids = this.getProviders();
                for (ProviderId providerId : ids) {
                    TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                    provider.releaseTunnel(tunnel);
                }
            }
        }
    }

    public Tunnel borrowTunnel(ApplicationId consumerId, TunnelId tunnelId, Annotations ... annotations) {
        return this.store.borrowTunnel(consumerId, tunnelId, annotations);
    }

    public Collection<Tunnel> borrowTunnel(ApplicationId consumerId, TunnelName tunnelName, Annotations ... annotations) {
        return this.store.borrowTunnel(consumerId, tunnelName, annotations);
    }

    public Collection<Tunnel> borrowTunnel(ApplicationId consumerId, TunnelEndPoint src, TunnelEndPoint dst, Annotations ... annotations) {
        Collection tunnels = this.store.borrowTunnel(consumerId, src, dst, annotations);
        if (tunnels == null || tunnels.isEmpty()) {
            DefaultTunnel tunnel = new DefaultTunnel(null, src, dst, null, null, null, null, null, annotations);
            Set ids = this.getProviders();
            for (ProviderId providerId : ids) {
                TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                provider.setupTunnel((Tunnel)tunnel, null);
            }
        }
        return tunnels;
    }

    public Collection<Tunnel> borrowTunnel(ApplicationId consumerId, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, Annotations ... annotations) {
        Collection tunnels = this.store.borrowTunnel(consumerId, src, dst, type, annotations);
        if (tunnels == null || tunnels.isEmpty()) {
            DefaultTunnel tunnel = new DefaultTunnel(null, src, dst, type, null, null, null, null, annotations);
            Set ids = this.getProviders();
            for (ProviderId providerId : ids) {
                TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                provider.setupTunnel((Tunnel)tunnel, null);
            }
        }
        return tunnels;
    }

    public TunnelId setupTunnel(ApplicationId producerId, ElementId srcElementId, Tunnel tunnel, Path path) {
        Preconditions.checkNotNull((Object)tunnel, (Object)TUNNNEL_NULL);
        TunnelId tunnelId = this.store.createOrUpdateTunnel(tunnel, Tunnel.State.INIT);
        if (tunnelId != null) {
            Set ids = this.getProviders();
            Tunnel newT = this.queryTunnel(tunnelId);
            for (ProviderId providerId : ids) {
                TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                provider.setupTunnel(srcElementId, newT, path);
            }
        }
        return tunnelId;
    }

    public boolean downTunnel(ApplicationId producerId, TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNNEL_ID_NULL);
        Tunnel tunnel = this.store.queryTunnel(tunnelId);
        if (tunnel != null) {
            TunnelId updtTunnelId = this.store.createOrUpdateTunnel(tunnel, Tunnel.State.INACTIVE);
            if (updtTunnelId != null) {
                Set ids = this.getProviders();
                for (ProviderId providerId : ids) {
                    TunnelProvider provider = (TunnelProvider)this.getProvider(providerId);
                    provider.releaseTunnel(tunnel);
                }
            }
            return true;
        }
        return false;
    }

    public boolean returnTunnel(ApplicationId consumerId, TunnelId tunnelId, Annotations ... annotations) {
        return this.store.returnTunnel(consumerId, tunnelId, annotations);
    }

    public boolean returnTunnel(ApplicationId consumerId, TunnelName tunnelName, Annotations ... annotations) {
        return this.store.returnTunnel(consumerId, tunnelName, annotations);
    }

    public boolean returnTunnel(ApplicationId consumerId, TunnelEndPoint src, TunnelEndPoint dst, Tunnel.Type type, Annotations ... annotations) {
        return this.store.returnTunnel(consumerId, src, dst, type, annotations);
    }

    public boolean returnTunnel(ApplicationId consumerId, TunnelEndPoint src, TunnelEndPoint dst, Annotations ... annotations) {
        return this.store.returnTunnel(consumerId, src, dst, annotations);
    }

    public Tunnel queryTunnel(TunnelId tunnelId) {
        return this.store.queryTunnel(tunnelId);
    }

    public Collection<TunnelSubscription> queryTunnelSubscription(ApplicationId consumerId) {
        return this.store.queryTunnelSubscription(consumerId);
    }

    public Collection<Tunnel> queryTunnel(Tunnel.Type type) {
        return this.store.queryTunnel(type);
    }

    public Collection<Tunnel> queryTunnel(TunnelEndPoint src, TunnelEndPoint dst) {
        return this.store.queryTunnel(src, dst);
    }

    public Collection<Tunnel> queryAllTunnels() {
        return this.store.queryAllTunnels();
    }

    public int tunnelCount() {
        return this.store.tunnelCount();
    }

    protected TunnelProviderService createProviderService(TunnelProvider provider) {
        return new InternalTunnelProviderService(provider);
    }

    public Iterable<Tunnel> getTunnels(DeviceId deviceId) {
        return Collections.emptyList();
    }

    protected void bindStore(TunnelStore tunnelStore) {
        this.store = tunnelStore;
    }

    protected void unbindStore(TunnelStore tunnelStore) {
        if (this.store == tunnelStore) {
            this.store = null;
        }
    }

    private class InternalStoreDelegate
    implements TunnelStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(TunnelEvent event) {
            if (event != null) {
                TunnelManager.this.post((Event)event);
            }
        }
    }

    private class InternalTunnelProviderService
    extends AbstractProviderService<TunnelProvider>
    implements TunnelProviderService {
        protected InternalTunnelProviderService(TunnelProvider provider) {
            super((Provider)provider);
        }

        public TunnelId tunnelAdded(TunnelDescription tunnel) {
            DefaultTunnel storedTunnel = new DefaultTunnel(((TunnelProvider)this.provider()).id(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), tunnel.id(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
            return TunnelManager.this.store.createOrUpdateTunnel((Tunnel)storedTunnel);
        }

        public TunnelId tunnelAdded(TunnelDescription tunnel, Tunnel.State state) {
            DefaultTunnel storedTunnel = new DefaultTunnel(((TunnelProvider)this.provider()).id(), tunnel.src(), tunnel.dst(), tunnel.type(), state, tunnel.groupId(), tunnel.id(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
            return TunnelManager.this.store.createOrUpdateTunnel((Tunnel)storedTunnel);
        }

        public void tunnelUpdated(TunnelDescription tunnel) {
            DefaultTunnel storedTunnel = new DefaultTunnel(((TunnelProvider)this.provider()).id(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), tunnel.id(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
            TunnelManager.this.store.createOrUpdateTunnel((Tunnel)storedTunnel);
        }

        public void tunnelUpdated(TunnelDescription tunnel, Tunnel.State state) {
            DefaultTunnel storedTunnel = new DefaultTunnel(((TunnelProvider)this.provider()).id(), tunnel.src(), tunnel.dst(), tunnel.type(), state, tunnel.groupId(), tunnel.id(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
            TunnelManager.this.store.createOrUpdateTunnel((Tunnel)storedTunnel, state);
        }

        public void tunnelRemoved(TunnelDescription tunnel) {
            if (tunnel.id() != null) {
                TunnelManager.this.store.deleteTunnel(tunnel.id());
                return;
            }
            if (tunnel.src() != null && tunnel.dst() != null && tunnel.type() != null) {
                TunnelManager.this.store.deleteTunnel(tunnel.src(), tunnel.dst(), tunnel.type(), ((TunnelProvider)this.provider()).id());
                return;
            }
            if (tunnel.src() != null && tunnel.dst() != null && tunnel.type() == null) {
                TunnelManager.this.store.deleteTunnel(tunnel.src(), tunnel.dst(), ((TunnelProvider)this.provider()).id());
                return;
            }
        }

        public Tunnel tunnelQueryById(TunnelId tunnelId) {
            return TunnelManager.this.store.queryTunnel(tunnelId);
        }
    }
}

