/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.routing.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.routing.InternalRouteEvent;
import org.onosproject.incubator.net.routing.NextHop;
import org.onosproject.incubator.net.routing.NextHopData;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteAdminService;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteInfo;
import org.onosproject.incubator.net.routing.RouteListener;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.incubator.net.routing.RouteSet;
import org.onosproject.incubator.net.routing.RouteStore;
import org.onosproject.incubator.net.routing.RouteStoreDelegate;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.incubator.net.routing.impl.DefaultResolvedRouteStore;
import org.onosproject.incubator.net.routing.impl.ListenerQueue;
import org.onosproject.incubator.net.routing.impl.ResolvedRouteStore;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class RouteManager
implements RouteService,
RouteAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RouteStoreDelegate delegate = new InternalRouteStoreDelegate();
    private InternalHostListener hostListener = new InternalHostListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteStore routeStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    private ResolvedRouteStore resolvedRouteStore;
    @GuardedBy(value="this")
    private Map<RouteListener, ListenerQueue> listeners = new HashMap<RouteListener, ListenerQueue>();
    private ThreadFactory threadFactory;

    @Activate
    protected void activate() {
        this.threadFactory = Tools.groupedThreads((String)"onos/route", (String)"listener-%d", (Logger)this.log);
        this.resolvedRouteStore = new DefaultResolvedRouteStore();
        this.routeStore.setDelegate((StoreDelegate)this.delegate);
        this.hostService.addListener((EventListener)this.hostListener);
        this.routeStore.getRouteTables().stream().flatMap(id -> this.routeStore.getRoutes(id).stream()).forEach(this::resolve);
    }

    @Deactivate
    protected void deactivate() {
        this.listeners.values().forEach(ListenerQueue::stop);
        this.routeStore.unsetDelegate((StoreDelegate)this.delegate);
        this.hostService.removeListener((EventListener)this.hostListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RouteListener listener) {
        RouteManager routeManager = this;
        synchronized (routeManager) {
            this.log.debug("Synchronizing current routes to new listener");
            ListenerQueue l = this.createListenerQueue(listener);
            this.resolvedRouteStore.getRouteTables().stream().map(this.resolvedRouteStore::getRoutes).flatMap(Collection::stream).map(route -> new RouteEvent(RouteEvent.Type.ROUTE_ADDED, route, this.resolvedRouteStore.getAllRoutes(route.prefix()))).forEach(l::post);
            this.listeners.put(listener, l);
            l.start();
            this.log.debug("Route synchronization complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RouteListener listener) {
        RouteManager routeManager = this;
        synchronized (routeManager) {
            ListenerQueue l = this.listeners.remove(listener);
            if (l != null) {
                l.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(RouteEvent event) {
        if (event != null) {
            this.log.debug("Sending event {}", (Object)event);
            RouteManager routeManager = this;
            synchronized (routeManager) {
                this.listeners.values().forEach(l -> l.post(event));
            }
        }
    }

    public Map<RouteTableId, Collection<Route>> getAllRoutes() {
        return this.routeStore.getRouteTables().stream().collect(Collectors.toMap(Function.identity(), table -> table == null ? Collections.emptySet() : this.reformatRoutes(this.routeStore.getRoutes(table))));
    }

    private Collection<Route> reformatRoutes(Collection<RouteSet> routeSets) {
        return routeSets.stream().flatMap(r -> r.routes().stream()).collect(Collectors.toList());
    }

    public Collection<RouteTableId> getRouteTables() {
        return this.routeStore.getRouteTables();
    }

    public Collection<RouteInfo> getRoutes(RouteTableId id) {
        return this.routeStore.getRoutes(id).stream().map(routeSet -> new RouteInfo(routeSet.prefix(), (ResolvedRoute)this.resolvedRouteStore.getRoute(routeSet.prefix()).orElse(null), this.resolveRouteSet((RouteSet)routeSet))).collect(Collectors.toList());
    }

    private Set<ResolvedRoute> resolveRouteSet(RouteSet routeSet) {
        return routeSet.routes().stream().map(this::tryResolve).collect(Collectors.toSet());
    }

    private ResolvedRoute tryResolve(Route route) {
        ResolvedRoute resolvedRoute = this.resolve(route);
        if (resolvedRoute == null) {
            resolvedRoute = new ResolvedRoute(route, null, null);
        }
        return resolvedRoute;
    }

    public Route longestPrefixMatch(IpAddress ip) {
        return this.longestPrefixLookup(ip).map(r -> new Route(Route.Source.STATIC, r.prefix(), r.nextHop())).orElse(null);
    }

    public Optional<ResolvedRoute> longestPrefixLookup(IpAddress ip) {
        return this.resolvedRouteStore.longestPrefixMatch(ip);
    }

    public Collection<Route> getRoutesForNextHop(IpAddress nextHop) {
        return this.routeStore.getRoutesForNextHop(nextHop);
    }

    public Set<NextHop> getNextHops() {
        return this.routeStore.getNextHops().entrySet().stream().map(entry -> new NextHop((IpAddress)entry.getKey(), (NextHopData)entry.getValue())).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<Route> routes) {
        RouteManager routeManager = this;
        synchronized (routeManager) {
            routes.forEach(route -> {
                this.log.debug("Received update {}", route);
                this.routeStore.updateRoute(route);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdraw(Collection<Route> routes) {
        RouteManager routeManager = this;
        synchronized (routeManager) {
            routes.forEach(route -> {
                this.log.debug("Received withdraw {}", route);
                this.routeStore.removeRoute(route);
            });
        }
    }

    private ResolvedRoute resolve(Route route) {
        this.hostService.startMonitoringIp(route.nextHop());
        Set hosts = this.hostService.getHostsByIp(route.nextHop());
        Optional host = hosts.stream().findFirst();
        if (host.isPresent()) {
            return new ResolvedRoute(route, ((Host)host.get()).mac(), ((Host)host.get()).vlan(), (ConnectPoint)((Host)host.get()).location());
        }
        return null;
    }

    private ResolvedRoute decide(ResolvedRoute route1, ResolvedRoute route2) {
        return Comparator.comparing(ResolvedRoute::nextHop).compare(route1, route2) <= 0 ? route1 : route2;
    }

    private void store(ResolvedRoute route, Set<ResolvedRoute> alternatives) {
        this.post(this.resolvedRouteStore.updateRoute(route, alternatives));
    }

    private void remove(IpPrefix prefix) {
        this.post(this.resolvedRouteStore.removeRoute(prefix));
    }

    private void resolve(RouteSet routes) {
        Set<ResolvedRoute> resolvedRoutes = routes.routes().stream().map(this::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
        Optional bestRoute = resolvedRoutes.stream().reduce(this::decide);
        if (bestRoute.isPresent()) {
            this.store((ResolvedRoute)bestRoute.get(), resolvedRoutes);
        } else {
            this.remove(routes.prefix());
        }
    }

    private void hostUpdated(Host host) {
        this.hostChanged(host);
    }

    private void hostRemoved(Host host) {
        this.hostChanged(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hostChanged(Host host) {
        RouteManager routeManager = this;
        synchronized (routeManager) {
            host.ipAddresses().stream().flatMap(ip -> this.routeStore.getRoutesForNextHop(ip).stream()).map(route -> this.routeStore.getRoutes(route.prefix())).forEach(this::resolve);
        }
    }

    ListenerQueue createListenerQueue(RouteListener listener) {
        return new DefaultListenerQueue(listener);
    }

    protected void bindRouteStore(RouteStore routeStore) {
        this.routeStore = routeStore;
    }

    protected void unbindRouteStore(RouteStore routeStore) {
        if (this.routeStore == routeStore) {
            this.routeStore = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: 
                case HOST_UPDATED: {
                    RouteManager.this.hostUpdated((Host)event.subject());
                    break;
                }
                case HOST_REMOVED: {
                    RouteManager.this.hostRemoved((Host)event.subject());
                    break;
                }
                case HOST_MOVED: {
                    break;
                }
            }
        }
    }

    private class InternalRouteStoreDelegate
    implements RouteStoreDelegate {
        private InternalRouteStoreDelegate() {
        }

        public void notify(InternalRouteEvent event) {
            switch ((InternalRouteEvent.Type)event.type()) {
                case ROUTE_ADDED: {
                    RouteManager.this.resolve((RouteSet)event.subject());
                    break;
                }
                case ROUTE_REMOVED: {
                    RouteManager.this.resolve((RouteSet)event.subject());
                    break;
                }
            }
        }
    }

    private class DefaultListenerQueue
    implements ListenerQueue {
        private final ExecutorService executorService;
        private final BlockingQueue<RouteEvent> queue;
        private final RouteListener listener;

        public DefaultListenerQueue(RouteListener listener) {
            this.listener = listener;
            this.queue = new LinkedBlockingQueue<RouteEvent>();
            this.executorService = Executors.newSingleThreadExecutor(RouteManager.this.threadFactory);
        }

        @Override
        public void post(RouteEvent event) {
            this.queue.add(event);
        }

        @Override
        public void start() {
            this.executorService.execute(this::poll);
        }

        @Override
        public void stop() {
            this.executorService.shutdown();
        }

        private void poll() {
            while (true) {
                try {
                    while (true) {
                        this.listener.event((Event)this.queue.take());
                    }
                }
                catch (InterruptedException e) {
                    RouteManager.this.log.info("Route listener event thread shutting down: {}", (Object)e.getMessage());
                }
                catch (Exception e) {
                    RouteManager.this.log.warn("Exception during route event handler", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

