/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.routing.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultByteArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteTableId;
import org.onosproject.incubator.net.routing.RouteTools;
import org.onosproject.incubator.net.routing.impl.ResolvedRouteStore;

public class DefaultResolvedRouteStore
implements ResolvedRouteStore {
    private Map<RouteTableId, RouteTable> routeTables = new ConcurrentHashMap<RouteTableId, RouteTable>();
    private static final RouteTableId IPV4 = new RouteTableId("ipv4");
    private static final RouteTableId IPV6 = new RouteTableId("ipv6");

    public DefaultResolvedRouteStore() {
        this.routeTables.put(IPV4, new RouteTable());
        this.routeTables.put(IPV6, new RouteTable());
    }

    @Override
    public RouteEvent updateRoute(ResolvedRoute route, Set<ResolvedRoute> alternatives) {
        return this.getDefaultRouteTable(route).update(route, alternatives);
    }

    @Override
    public RouteEvent removeRoute(IpPrefix prefix) {
        RouteTable table = this.getDefaultRouteTable(prefix.address());
        return table.remove(prefix);
    }

    @Override
    public Set<RouteTableId> getRouteTables() {
        return this.routeTables.keySet();
    }

    @Override
    public Collection<ResolvedRoute> getRoutes(RouteTableId table) {
        RouteTable routeTable = this.routeTables.get(table);
        if (routeTable == null) {
            return Collections.emptySet();
        }
        return routeTable.getRoutes();
    }

    @Override
    public Optional<ResolvedRoute> getRoute(IpPrefix prefix) {
        return this.getDefaultRouteTable(prefix.address()).getRoute(prefix);
    }

    @Override
    public Collection<ResolvedRoute> getAllRoutes(IpPrefix prefix) {
        return this.getDefaultRouteTable(prefix.address()).getAllRoutes(prefix);
    }

    @Override
    public Optional<ResolvedRoute> longestPrefixMatch(IpAddress ip) {
        return this.getDefaultRouteTable(ip).longestPrefixMatch(ip);
    }

    private RouteTable getDefaultRouteTable(ResolvedRoute route) {
        return this.getDefaultRouteTable(route.prefix().address());
    }

    private RouteTable getDefaultRouteTable(IpAddress ip) {
        RouteTableId routeTableId = ip.isIp4() ? IPV4 : IPV6;
        return this.routeTables.get(routeTableId);
    }

    private class RouteTable {
        private final InvertedRadixTree<ResolvedRoute> routeTable = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultByteArrayNodeFactory());
        private final Map<IpPrefix, Set<ResolvedRoute>> alternativeRoutes = Maps.newHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RouteEvent update(ResolvedRoute route, Set<ResolvedRoute> alternatives) {
            Set<ResolvedRoute> immutableAlternatives = this.checkAlternatives(route, alternatives);
            RouteTable routeTable = this;
            synchronized (routeTable) {
                ResolvedRoute oldRoute = (ResolvedRoute)this.routeTable.put((CharSequence)RouteTools.createBinaryString((IpPrefix)route.prefix()), (Object)route);
                Set<ResolvedRoute> oldRoutes = this.alternativeRoutes.put(route.prefix(), immutableAlternatives);
                if (!route.equals((Object)oldRoute)) {
                    if (oldRoute == null) {
                        return new RouteEvent(RouteEvent.Type.ROUTE_ADDED, route, immutableAlternatives);
                    }
                    return new RouteEvent(RouteEvent.Type.ROUTE_UPDATED, route, oldRoute, immutableAlternatives);
                }
                if (!immutableAlternatives.equals(oldRoutes)) {
                    return new RouteEvent(RouteEvent.Type.ALTERNATIVE_ROUTES_CHANGED, route, immutableAlternatives);
                }
                return null;
            }
        }

        private Set<ResolvedRoute> checkAlternatives(ResolvedRoute route, Set<ResolvedRoute> alternatives) {
            if (!alternatives.contains(route)) {
                return ImmutableSet.builder().addAll(alternatives).add((Object)route).build();
            }
            return ImmutableSet.copyOf(alternatives);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RouteEvent remove(IpPrefix prefix) {
            RouteTable routeTable = this;
            synchronized (routeTable) {
                String key = RouteTools.createBinaryString((IpPrefix)prefix);
                ResolvedRoute route = (ResolvedRoute)this.routeTable.getValueForExactKey((CharSequence)key);
                this.alternativeRoutes.remove(prefix);
                if (route != null) {
                    this.routeTable.remove((CharSequence)key);
                    return new RouteEvent(RouteEvent.Type.ROUTE_REMOVED, route);
                }
                return null;
            }
        }

        public Collection<ResolvedRoute> getRoutes() {
            return (Collection)Tools.stream((Iterable)this.routeTable.getKeyValuePairsForKeysStartingWith((CharSequence)"")).map(KeyValuePair::getValue).collect(GuavaCollectors.toImmutableList());
        }

        public Optional<ResolvedRoute> getRoute(IpPrefix prefix) {
            return Optional.ofNullable(this.routeTable.getValueForExactKey((CharSequence)RouteTools.createBinaryString((IpPrefix)prefix)));
        }

        public Collection<ResolvedRoute> getAllRoutes(IpPrefix prefix) {
            return this.alternativeRoutes.getOrDefault(prefix, Collections.emptySet());
        }

        public Optional<ResolvedRoute> longestPrefixMatch(IpAddress ip) {
            return Tools.stream((Iterable)this.routeTable.getValuesForKeysPrefixing((CharSequence)RouteTools.createBinaryString((IpPrefix)ip.toIpPrefix()))).reduce((a, b) -> b);
        }
    }
}

