/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.routing.impl;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.routing.RouteAdminService;
import org.onosproject.incubator.net.routing.RouteConfig;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;

@Component(immediate=true)
public class ConfigurationRouteSource {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netcfgRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteAdminService routeService;
    private final ConfigFactory<ApplicationId, RouteConfig> routeConfigFactory = new ConfigFactory<ApplicationId, RouteConfig>(SubjectFactories.APP_SUBJECT_FACTORY, RouteConfig.class, "routes", true){

        public RouteConfig createConfig() {
            return new RouteConfig();
        }
    };
    private final InternalNetworkConfigListener netcfgListener = new InternalNetworkConfigListener();

    @Activate
    protected void activate() {
        this.netcfgRegistry.addListener((EventListener)this.netcfgListener);
        this.netcfgRegistry.registerConfigFactory(this.routeConfigFactory);
    }

    @Deactivate
    protected void deactivate() {
        this.netcfgRegistry.removeListener((EventListener)this.netcfgListener);
        this.netcfgRegistry.unregisterConfigFactory(this.routeConfigFactory);
    }

    private void processRouteConfigAdded(NetworkConfigEvent event) {
        Set routes = ((RouteConfig)event.config().get()).getRoutes();
        this.routeService.update((Collection)routes);
    }

    private void processRouteConfigUpdated(NetworkConfigEvent event) {
        Set routes = ((RouteConfig)event.config().get()).getRoutes();
        Set prevRoutes = ((RouteConfig)event.prevConfig().get()).getRoutes();
        Set pendingRemove = prevRoutes.stream().filter(prevRoute -> routes.stream().noneMatch(route -> route.prefix().equals((Object)prevRoute.prefix()))).collect(Collectors.toSet());
        Set pendingUpdate = routes.stream().filter(route -> !pendingRemove.contains(route)).collect(Collectors.toSet());
        this.routeService.update(pendingUpdate);
        this.routeService.withdraw(pendingRemove);
    }

    private void processRouteConfigRemoved(NetworkConfigEvent event) {
        Set prevRoutes = ((RouteConfig)event.prevConfig().get()).getRoutes();
        this.routeService.withdraw((Collection)prevRoutes);
    }

    protected void bindNetcfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.netcfgRegistry = networkConfigRegistry;
    }

    protected void unbindNetcfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netcfgRegistry == networkConfigRegistry) {
            this.netcfgRegistry = null;
        }
    }

    protected void bindRouteService(RouteAdminService routeAdminService) {
        this.routeService = routeAdminService;
    }

    protected void unbindRouteService(RouteAdminService routeAdminService) {
        if (this.routeService == routeAdminService) {
            this.routeService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(RouteConfig.class)) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: {
                        ConfigurationRouteSource.this.processRouteConfigAdded(event);
                        break;
                    }
                    case CONFIG_UPDATED: {
                        ConfigurationRouteSource.this.processRouteConfigUpdated(event);
                        break;
                    }
                    case CONFIG_REMOVED: {
                        ConfigurationRouteSource.this.processRouteConfigRemoved(event);
                        break;
                    }
                }
            }
        }
    }
}

