/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.resource.label.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceDelegate;
import org.onosproject.incubator.net.resource.label.LabelResourceEvent;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceListener;
import org.onosproject.incubator.net.resource.label.LabelResourcePool;
import org.onosproject.incubator.net.resource.label.LabelResourceProvider;
import org.onosproject.incubator.net.resource.label.LabelResourceProviderRegistry;
import org.onosproject.incubator.net.resource.label.LabelResourceProviderService;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.resource.label.LabelResourceStore;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class LabelResourceManager
extends AbstractListenerProviderRegistry<LabelResourceEvent, LabelResourceListener, LabelResourceProvider, LabelResourceProviderService>
implements LabelResourceService,
LabelResourceAdminService,
LabelResourceProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final LabelResourceDelegate delegate = new InternalLabelResourceDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LabelResourceStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private DeviceListener deviceListener = new InternalDeviceListener();

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(LabelResourceEvent.class, (EventSink)this.listenerRegistry);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(LabelResourceEvent.class);
        this.log.info("Stopped");
    }

    public boolean createDevicePool(DeviceId deviceId, LabelResourceId beginLabel, LabelResourceId endLabel) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
        Preconditions.checkNotNull((Object)beginLabel, (Object)"beginLabel is not null");
        Preconditions.checkNotNull((Object)endLabel, (Object)"endLabel is not null");
        Preconditions.checkArgument((beginLabel.labelId() >= 0L || endLabel.labelId() >= 0L ? 1 : 0) != 0, (Object)"The value of beginLabel and the value of endLabel must be both positive number.");
        Preconditions.checkArgument((beginLabel.labelId() < endLabel.labelId() ? 1 : 0) != 0, (Object)"The value of endLabel must be greater than the value of beginLabel.");
        return this.store.createDevicePool(deviceId, beginLabel, endLabel);
    }

    public boolean createGlobalPool(LabelResourceId beginLabel, LabelResourceId endLabel) {
        Preconditions.checkNotNull((Object)beginLabel, (Object)"beginLabel is not null");
        Preconditions.checkNotNull((Object)endLabel, (Object)"endLabel is not null");
        Preconditions.checkArgument((beginLabel.labelId() >= 0L && endLabel.labelId() >= 0L ? 1 : 0) != 0, (Object)"The value of beginLabel and the value of endLabel must be both positive number.");
        Preconditions.checkArgument((beginLabel.labelId() < endLabel.labelId() ? 1 : 0) != 0, (Object)"The value of endLabel must be greater than the value of beginLabel.");
        return this.store.createGlobalPool(beginLabel, endLabel);
    }

    public boolean destroyDevicePool(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
        return this.store.destroyDevicePool(deviceId);
    }

    public boolean destroyGlobalPool() {
        return this.store.destroyGlobalPool();
    }

    public Collection<LabelResource> applyFromDevicePool(DeviceId deviceId, long applyNum) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
        Preconditions.checkNotNull((Object)applyNum, (Object)"applyNum is not null");
        return this.store.applyFromDevicePool(deviceId, applyNum);
    }

    public Collection<LabelResource> applyFromGlobalPool(long applyNum) {
        Preconditions.checkNotNull((Object)applyNum, (Object)"applyNum is not null");
        return this.store.applyFromGlobalPool(applyNum);
    }

    public boolean releaseToDevicePool(Multimap<DeviceId, LabelResource> release) {
        Preconditions.checkNotNull(release, (Object)"release is not null");
        return this.store.releaseToDevicePool(release);
    }

    public boolean releaseToGlobalPool(Set<LabelResourceId> release) {
        Preconditions.checkNotNull(release, (Object)"release is not null");
        return this.store.releaseToGlobalPool(release);
    }

    public boolean isDevicePoolFull(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
        return this.store.isDevicePoolFull(deviceId);
    }

    public boolean isGlobalPoolFull() {
        return this.store.isGlobalPoolFull();
    }

    public long getFreeNumOfDevicePool(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
        return this.store.getFreeNumOfDevicePool(deviceId);
    }

    public long getFreeNumOfGlobalPool() {
        return this.store.getFreeNumOfGlobalPool();
    }

    public LabelResourcePool getDeviceLabelResourcePool(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
        return this.store.getDeviceLabelResourcePool(deviceId);
    }

    public LabelResourcePool getGlobalLabelResourcePool() {
        return this.store.getGlobalLabelResourcePool();
    }

    protected LabelResourceProviderService createProviderService(LabelResourceProvider provider) {
        return new InternalLabelResourceProviderService(provider);
    }

    protected void bindStore(LabelResourceStore labelResourceStore) {
        this.store = labelResourceStore;
    }

    protected void unbindStore(LabelResourceStore labelResourceStore) {
        if (this.store == labelResourceStore) {
            this.store = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class InternalLabelResourceProviderService
    extends AbstractProviderService<LabelResourceProvider>
    implements LabelResourceProviderService {
        protected InternalLabelResourceProviderService(LabelResourceProvider provider) {
            super((Provider)provider);
        }

        public void deviceLabelResourcePoolDetected(DeviceId deviceId, LabelResourceId beginLabel, LabelResourceId endLabel) {
            Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
            Preconditions.checkNotNull((Object)beginLabel, (Object)"beginLabel is not null");
            Preconditions.checkNotNull((Object)endLabel, (Object)"endLabel is not null");
            LabelResourceManager.this.createDevicePool(deviceId, beginLabel, endLabel);
        }

        public void deviceLabelResourcePoolDestroyed(DeviceId deviceId) {
            Preconditions.checkNotNull((Object)deviceId, (Object)"deviceId is not null");
            LabelResourceManager.this.destroyDevicePool(deviceId);
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            Device device = (Device)event.subject();
            if (DeviceEvent.Type.DEVICE_REMOVED.equals((Object)event.type())) {
                LabelResourceManager.this.destroyDevicePool(device.id());
            }
        }
    }

    private class InternalLabelResourceDelegate
    implements LabelResourceDelegate {
        private InternalLabelResourceDelegate() {
        }

        public void notify(LabelResourceEvent event) {
            LabelResourceManager.this.post((Event)event);
        }
    }
}

