/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.neighbour.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv6;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.neighbour.NeighbourHandlerRegistration;
import org.onosproject.incubator.net.neighbour.NeighbourMessageActions;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.incubator.net.neighbour.impl.DefaultNeighbourMessageActions;
import org.onosproject.incubator.net.neighbour.impl.DefaultNeighbourMessageContext;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class NeighbourResolutionManager
implements NeighbourResolutionService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EdgePortService edgeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Property(name="arpEnabled", boolValue={true}, label="Enable Address resolution protocol")
    protected boolean arpEnabled = true;
    @Property(name="ndpEnabled", boolValue={false}, label="Enable IPv6 neighbour discovery")
    protected boolean ndpEnabled = false;
    @Property(name="requestInterceptsEnabled", boolValue={true}, label="Enable requesting packet intercepts")
    private boolean requestInterceptsEnabled = true;
    private static final String APP_NAME = "org.onosproject.neighbour";
    private ApplicationId appId;
    private final SetMultimap<ConnectPoint, NeighbourHandlerRegistration> packetHandlers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final InternalPacketProcessor processor = new InternalPacketProcessor();
    private NeighbourMessageActions actions;

    @Activate
    protected void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.componentConfigService.registerProperties(this.getClass());
        this.modified(context);
        this.actions = new DefaultNeighbourMessageActions(this.packetService, this.edgeService);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)1));
    }

    @Deactivate
    protected void deactivate() {
        this.cancelPackets();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.componentConfigService.unregisterProperties(this.getClass(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"ndpEnabled");
        if (flag != null) {
            this.ndpEnabled = flag;
            this.log.info("IPv6 neighbor discovery is {}", (Object)(this.ndpEnabled ? "enabled" : "disabled"));
        }
        if ((flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"arpEnabled")) != null) {
            this.arpEnabled = flag;
            this.log.info("Address resolution protocol is {}", (Object)(this.arpEnabled ? "enabled" : "disabled"));
        }
        if ((flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"requestInterceptsEnabled")) == null) {
            this.log.info("Request intercepts is not configured, using current value of {}", (Object)this.requestInterceptsEnabled);
        } else {
            this.requestInterceptsEnabled = flag;
            this.log.info("Configured. Request intercepts is {}", (Object)(this.requestInterceptsEnabled ? "enabled" : "disabled"));
        }
        SetMultimap<ConnectPoint, NeighbourHandlerRegistration> setMultimap = this.packetHandlers;
        synchronized (setMultimap) {
            if (!this.packetHandlers.isEmpty() && this.requestInterceptsEnabled) {
                this.requestPackets();
            } else {
                this.cancelPackets();
            }
        }
    }

    private void requestPackets() {
        if (this.arpEnabled) {
            this.packetService.requestPackets(this.buildArpSelector(), PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(this.buildArpSelector(), PacketPriority.CONTROL, this.appId);
        }
        if (this.ndpEnabled) {
            this.packetService.requestPackets(this.buildNeighborSolicitationSelector(), PacketPriority.CONTROL, this.appId);
            this.packetService.requestPackets(this.buildNeighborAdvertisementSelector(), PacketPriority.CONTROL, this.appId);
        } else {
            this.packetService.cancelPackets(this.buildNeighborSolicitationSelector(), PacketPriority.CONTROL, this.appId);
            this.packetService.cancelPackets(this.buildNeighborAdvertisementSelector(), PacketPriority.CONTROL, this.appId);
        }
    }

    private void cancelPackets() {
        this.packetService.cancelPackets(this.buildArpSelector(), PacketPriority.CONTROL, this.appId);
        this.packetService.cancelPackets(this.buildNeighborSolicitationSelector(), PacketPriority.CONTROL, this.appId);
        this.packetService.cancelPackets(this.buildNeighborAdvertisementSelector(), PacketPriority.CONTROL, this.appId);
    }

    private TrafficSelector buildArpSelector() {
        return DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP).build();
    }

    private TrafficSelector buildNeighborSolicitationSelector() {
        return DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58).matchIcmpv6Type((byte)-121).build();
    }

    private TrafficSelector buildNeighborAdvertisementSelector() {
        return DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58).matchIcmpv6Type((byte)-120).build();
    }

    public void registerNeighbourHandler(ConnectPoint connectPoint, NeighbourMessageHandler handler, ApplicationId appId) {
        this.register(connectPoint, new HandlerRegistration(handler, appId));
    }

    public void registerNeighbourHandler(Interface intf, NeighbourMessageHandler handler, ApplicationId appId) {
        this.register(intf.connectPoint(), new HandlerRegistration(handler, intf, appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ConnectPoint connectPoint, HandlerRegistration registration) {
        SetMultimap<ConnectPoint, NeighbourHandlerRegistration> setMultimap = this.packetHandlers;
        synchronized (setMultimap) {
            if (this.packetHandlers.isEmpty() && this.requestInterceptsEnabled) {
                this.requestPackets();
            }
            this.packetHandlers.put((Object)connectPoint, (Object)registration);
        }
    }

    public void unregisterNeighbourHandler(ConnectPoint connectPoint, NeighbourMessageHandler handler, ApplicationId appId) {
        this.unregister(connectPoint, new HandlerRegistration(handler, appId));
    }

    public void unregisterNeighbourHandler(Interface intf, NeighbourMessageHandler handler, ApplicationId appId) {
        this.unregister(intf.connectPoint(), new HandlerRegistration(handler, intf, appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ConnectPoint connectPoint, HandlerRegistration registration) {
        SetMultimap<ConnectPoint, NeighbourHandlerRegistration> setMultimap = this.packetHandlers;
        synchronized (setMultimap) {
            this.packetHandlers.remove((Object)connectPoint, (Object)registration);
            if (this.packetHandlers.isEmpty()) {
                this.cancelPackets();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterNeighbourHandlers(ApplicationId appId) {
        SetMultimap<ConnectPoint, NeighbourHandlerRegistration> setMultimap = this.packetHandlers;
        synchronized (setMultimap) {
            Iterator it = this.packetHandlers.values().iterator();
            while (it.hasNext()) {
                NeighbourHandlerRegistration registration = (NeighbourHandlerRegistration)it.next();
                if (!registration.appId().equals(appId)) continue;
                it.remove();
            }
            if (this.packetHandlers.isEmpty()) {
                this.cancelPackets();
            }
        }
    }

    public Map<ConnectPoint, Collection<NeighbourHandlerRegistration>> getHandlerRegistrations() {
        return ImmutableMap.copyOf((Map)Multimaps.asMap(this.packetHandlers));
    }

    private void handlePacket(PacketContext context) {
        InboundPacket pkt = context.inPacket();
        Ethernet ethPkt = pkt.parsed();
        NeighbourMessageContext msgContext = DefaultNeighbourMessageContext.createContext(ethPkt, pkt.receivedFrom(), this.actions);
        if (msgContext == null) {
            return;
        }
        if (this.handleMessage(msgContext)) {
            context.block();
        }
    }

    private boolean handleMessage(NeighbourMessageContext context) {
        Set handlers = this.packetHandlers.get((Object)context.inPort());
        Collection handled = handlers.stream().filter(registration -> registration.intf() == null || this.matches(context, registration.intf())).collect(Collectors.toSet());
        handled.forEach(registration -> registration.handler().handleMessage(context, this.hostService));
        return !handled.isEmpty();
    }

    private boolean matches(NeighbourMessageContext context, Interface intf) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)intf);
        boolean matches = true;
        if (!(context.dstMac().isBroadcast() || intf.mac().equals((Object)MacAddress.NONE) || intf.mac().equals((Object)context.dstMac()))) {
            matches = false;
        }
        if (!intf.vlan().equals((Object)VlanId.NONE) && !intf.vlan().equals((Object)context.vlan())) {
            matches = false;
        }
        if (!intf.ipAddressesList().isEmpty() && !this.hasIp(intf, context.target())) {
            matches = false;
        }
        return matches;
    }

    private boolean hasIp(Interface intf, IpAddress ip) {
        return intf.ipAddressesList().stream().anyMatch(intfAddress -> intfAddress.ipAddress().equals((Object)ip));
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindEdgeService(EdgePortService edgePortService) {
        this.edgeService = edgePortService;
    }

    protected void unbindEdgeService(EdgePortService edgePortService) {
        if (this.edgeService == edgePortService) {
            this.edgeService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            ICMP6 icmp6;
            IPv6 ipv6;
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            if (ethPkt.getEtherType() == Ethernet.TYPE_ARP) {
                NeighbourResolutionManager.this.handlePacket(context);
            } else if (ethPkt.getEtherType() == Ethernet.TYPE_IPV6 && (ipv6 = (IPv6)ethPkt.getPayload()).getNextHeader() == 58 && ((icmp6 = (ICMP6)ipv6.getPayload()).getIcmpType() == -121 || icmp6.getIcmpType() == -120)) {
                NeighbourResolutionManager.this.handlePacket(context);
            }
        }
    }

    private class HandlerRegistration
    implements NeighbourHandlerRegistration {
        private final Interface intf;
        private final NeighbourMessageHandler handler;
        private final ApplicationId appId;

        public HandlerRegistration(NeighbourMessageHandler handler, ApplicationId appId) {
            this(handler, null, appId);
        }

        public HandlerRegistration(NeighbourMessageHandler handler, Interface intf, ApplicationId appId) {
            this.intf = intf;
            this.handler = handler;
            this.appId = appId;
        }

        public Interface intf() {
            return this.intf;
        }

        public NeighbourMessageHandler handler() {
            return this.handler;
        }

        public ApplicationId appId() {
            return this.appId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HandlerRegistration)) {
                return false;
            }
            HandlerRegistration that = (HandlerRegistration)other;
            return Objects.equals(this.intf, that.intf) && Objects.equals(this.handler, that.handler) && Objects.equals(this.appId, that.appId);
        }

        public int hashCode() {
            return Objects.hash(this.intf, this.handler, this.appId);
        }
    }
}

