/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.neighbour.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.neighbour.NeighbourMessageActions;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageType;
import org.onosproject.incubator.net.neighbour.NeighbourProtocol;
import org.onosproject.net.ConnectPoint;

@Beta
public class DefaultNeighbourMessageContext
implements NeighbourMessageContext {
    private final NeighbourProtocol protocol;
    private final NeighbourMessageType type;
    private final IpAddress target;
    private final IpAddress sender;
    private final Ethernet eth;
    private final ConnectPoint inPort;
    private final NeighbourMessageActions actions;

    DefaultNeighbourMessageContext(NeighbourMessageActions actions, Ethernet eth, ConnectPoint inPort, NeighbourProtocol protocol, NeighbourMessageType type, IpAddress target, IpAddress sender) {
        this.actions = actions;
        this.eth = eth;
        this.inPort = inPort;
        this.protocol = protocol;
        this.type = type;
        this.target = target;
        this.sender = sender;
    }

    public ConnectPoint inPort() {
        return this.inPort;
    }

    public Ethernet packet() {
        return this.eth;
    }

    public NeighbourProtocol protocol() {
        return this.protocol;
    }

    public NeighbourMessageType type() {
        return this.type;
    }

    public VlanId vlan() {
        return VlanId.vlanId((short)this.eth.getVlanID());
    }

    public MacAddress srcMac() {
        return this.eth.getSourceMAC();
    }

    public MacAddress dstMac() {
        return this.eth.getDestinationMAC();
    }

    public IpAddress target() {
        return this.target;
    }

    public IpAddress sender() {
        return this.sender;
    }

    public void forward(ConnectPoint outPort) {
        this.actions.forward((NeighbourMessageContext)this, outPort);
    }

    public void forward(Interface outIntf) {
        this.actions.forward((NeighbourMessageContext)this, outIntf);
    }

    public void reply(MacAddress targetMac) {
        Preconditions.checkState((this.type == NeighbourMessageType.REQUEST ? 1 : 0) != 0, (Object)"can only reply to requests");
        this.actions.reply((NeighbourMessageContext)this, targetMac);
    }

    public void flood() {
        this.actions.flood((NeighbourMessageContext)this);
    }

    public void drop() {
        this.actions.drop((NeighbourMessageContext)this);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.type, this.target, this.sender, this.eth, this.inPort);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultNeighbourMessageContext)) {
            return false;
        }
        DefaultNeighbourMessageContext that = (DefaultNeighbourMessageContext)obj;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.type, that.type) && Objects.equals(this.target, that.target) && Objects.equals(this.sender, that.sender) && Objects.equals(this.eth, that.eth) && Objects.equals(this.inPort, that.inPort);
    }

    public static NeighbourMessageContext createContext(Ethernet eth, ConnectPoint inPort, NeighbourMessageActions actions) {
        if (eth.getEtherType() == Ethernet.TYPE_ARP) {
            return DefaultNeighbourMessageContext.createArpContext(eth, inPort, actions);
        }
        if (eth.getEtherType() == Ethernet.TYPE_IPV6) {
            return DefaultNeighbourMessageContext.createNdpContext(eth, inPort, actions);
        }
        return null;
    }

    private static NeighbourMessageContext createArpContext(Ethernet eth, ConnectPoint inPort, NeighbourMessageActions actions) {
        NeighbourMessageType type;
        if (eth.getEtherType() != Ethernet.TYPE_ARP) {
            return null;
        }
        ARP arp = (ARP)eth.getPayload();
        Ip4Address target = Ip4Address.valueOf((byte[])arp.getTargetProtocolAddress());
        Ip4Address sender = Ip4Address.valueOf((byte[])arp.getSenderProtocolAddress());
        if (arp.getOpCode() == 1) {
            type = NeighbourMessageType.REQUEST;
        } else if (arp.getOpCode() == 2) {
            type = NeighbourMessageType.REPLY;
        } else {
            return null;
        }
        return new DefaultNeighbourMessageContext(actions, eth, inPort, NeighbourProtocol.ARP, type, (IpAddress)target, (IpAddress)sender);
    }

    private static NeighbourMessageContext createNdpContext(Ethernet eth, ConnectPoint inPort, NeighbourMessageActions actions) {
        Ip6Address target;
        NeighbourMessageType type;
        if (eth.getEtherType() != Ethernet.TYPE_IPV6) {
            return null;
        }
        IPv6 ipv6 = (IPv6)eth.getPayload();
        if (ipv6.getNextHeader() != 58) {
            return null;
        }
        ICMP6 icmpv6 = (ICMP6)ipv6.getPayload();
        Ip6Address sender = Ip6Address.valueOf((byte[])ipv6.getSourceAddress());
        if (icmpv6.getIcmpType() == -121) {
            type = NeighbourMessageType.REQUEST;
            NeighborSolicitation nsol = (NeighborSolicitation)icmpv6.getPayload();
            target = Ip6Address.valueOf((byte[])nsol.getTargetAddress());
        } else if (icmpv6.getIcmpType() == -120) {
            type = NeighbourMessageType.REPLY;
            target = Ip6Address.valueOf((byte[])ipv6.getDestinationAddress());
        } else {
            return null;
        }
        return new DefaultNeighbourMessageContext(actions, eth, inPort, NeighbourProtocol.NDP, type, (IpAddress)target, (IpAddress)sender);
    }
}

