/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.neighbour.impl;

import java.nio.ByteBuffer;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.util.Tools;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.neighbour.NeighbourMessageActions;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketService;

public class DefaultNeighbourMessageActions
implements NeighbourMessageActions {
    private final EdgePortService edgeService;
    private final PacketService packetService;

    public DefaultNeighbourMessageActions(PacketService packetService, EdgePortService edgeService) {
        this.packetService = packetService;
        this.edgeService = edgeService;
    }

    public void reply(NeighbourMessageContext context, MacAddress targetMac) {
        this.replyInternal(context, targetMac);
    }

    public void forward(NeighbourMessageContext context, ConnectPoint outPort) {
        this.sendTo(context.packet(), outPort);
    }

    public void forward(NeighbourMessageContext context, Interface outIntf) {
        Ethernet packetOut = (Ethernet)context.packet().clone();
        if (outIntf.vlan().equals((Object)VlanId.NONE)) {
            packetOut.setVlanID((short)-1);
        } else {
            packetOut.setVlanID(outIntf.vlan().toShort());
        }
        this.sendTo(packetOut, outIntf.connectPoint());
    }

    public void flood(NeighbourMessageContext context) {
        Tools.stream((Iterable)this.edgeService.getEdgePoints()).filter(cp -> !cp.equals((Object)context.inPort())).forEach(cp -> this.sendTo(context.packet(), (ConnectPoint)cp));
    }

    public void drop(NeighbourMessageContext context) {
    }

    private void replyInternal(NeighbourMessageContext context, MacAddress targetMac) {
        switch (context.protocol()) {
            case ARP: {
                this.sendTo(ARP.buildArpReply((Ip4Address)((Ip4Address)context.target()), (MacAddress)targetMac, (Ethernet)context.packet()), context.inPort());
                break;
            }
            case NDP: {
                this.sendTo(this.buildNdpReply((Ip6Address)context.target(), targetMac, context.packet()), context.inPort());
                break;
            }
        }
    }

    private void sendTo(Ethernet packet, ConnectPoint outPort) {
        this.sendTo(ByteBuffer.wrap(packet.serialize()), outPort);
    }

    private void sendTo(ByteBuffer packet, ConnectPoint outPort) {
        if (!this.edgeService.isEdgePoint(outPort)) {
            return;
        }
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        builder.setOutput(outPort.port());
        this.packetService.emit((OutboundPacket)new DefaultOutboundPacket(outPort.deviceId(), builder.build(), packet));
    }

    private Ethernet buildNdpReply(Ip6Address srcIp, MacAddress srcMac, Ethernet request) {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(request.getSourceMAC());
        eth.setSourceMACAddress(srcMac);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setVlanID(request.getVlanID());
        IPv6 requestIp = (IPv6)request.getPayload();
        IPv6 ipv6 = new IPv6();
        ipv6.setSourceAddress(srcIp.toOctets());
        ipv6.setDestinationAddress(requestIp.getSourceAddress());
        ipv6.setHopLimit((byte)-1);
        ICMP6 icmp6 = new ICMP6();
        icmp6.setIcmpType((byte)-120);
        icmp6.setIcmpCode((byte)0);
        NeighborAdvertisement nadv = new NeighborAdvertisement();
        nadv.setTargetAddress(srcIp.toOctets());
        nadv.setSolicitedFlag((byte)1);
        nadv.setOverrideFlag((byte)1);
        nadv.addOption((byte)2, srcMac.toBytes());
        icmp6.setPayload((IPacket)nadv);
        ipv6.setPayload((IPacket)icmp6);
        eth.setPayload((IPacket)ipv6);
        return eth;
    }
}

