/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.meter.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.TriConsumer;
import org.onosproject.event.EventSink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.MeterQuery;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterEvent;
import org.onosproject.net.meter.MeterFailReason;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterFeaturesKey;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterKey;
import org.onosproject.net.meter.MeterListener;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterProvider;
import org.onosproject.net.meter.MeterProviderRegistry;
import org.onosproject.net.meter.MeterProviderService;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterService;
import org.onosproject.net.meter.MeterState;
import org.onosproject.net.meter.MeterStore;
import org.onosproject.net.meter.MeterStoreDelegate;
import org.onosproject.net.meter.MeterStoreResult;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class MeterManager
extends AbstractListenerProviderRegistry<MeterEvent, MeterListener, MeterProvider, MeterProviderService>
implements MeterService,
MeterProviderRegistry {
    private static final String METERCOUNTERIDENTIFIER = "meter-id-counter-%s";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MeterStoreDelegate delegate = new InternalMeterStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MeterStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private Map<DeviceId, AtomicCounter> meterIdCounters = Maps.newConcurrentMap();
    private TriConsumer<MeterRequest, MeterStoreResult, Throwable> onComplete;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(MeterEvent.class, (EventSink)this.listenerRegistry);
        this.onComplete = (request, result, error) -> request.context().ifPresent(c -> {
            if (error != null) {
                c.onError(request, MeterFailReason.UNKNOWN);
            } else if (result.reason().isPresent()) {
                c.onError(request, (MeterFailReason)result.reason().get());
            } else {
                c.onSuccess(request);
            }
        });
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(MeterEvent.class);
        this.log.info("Stopped");
    }

    protected MeterProviderService createProviderService(MeterProvider provider) {
        return new InternalMeterProviderService(provider);
    }

    public Meter submit(MeterRequest request) {
        MeterId id = this.allocateMeterId(request.deviceId());
        Meter.Builder mBuilder = DefaultMeter.builder().forDevice(request.deviceId()).fromApp(request.appId()).withBands(request.bands()).withId(id).withUnit(request.unit());
        if (request.isBurst()) {
            mBuilder.burst();
        }
        DefaultMeter m = (DefaultMeter)mBuilder.build();
        m.setState(MeterState.PENDING_ADD);
        this.store.storeMeter((Meter)m).whenComplete((result, error) -> this.onComplete.accept((Object)request, result, error));
        return m;
    }

    public void withdraw(MeterRequest request, MeterId meterId) {
        Meter.Builder mBuilder = DefaultMeter.builder().forDevice(request.deviceId()).fromApp(request.appId()).withBands(request.bands()).withId(meterId).withUnit(request.unit());
        if (request.isBurst()) {
            mBuilder.burst();
        }
        DefaultMeter m = (DefaultMeter)mBuilder.build();
        m.setState(MeterState.PENDING_REMOVE);
        this.store.deleteMeter((Meter)m).whenComplete((result, error) -> this.onComplete.accept((Object)request, result, error));
    }

    public Meter getMeter(DeviceId deviceId, MeterId id) {
        MeterKey key = MeterKey.key((DeviceId)deviceId, (MeterId)id);
        return this.store.getMeter(key);
    }

    public Collection<Meter> getMeters(DeviceId deviceId) {
        return this.store.getAllMeters().stream().filter(m -> m.deviceId().equals((Object)deviceId)).collect(Collectors.toList());
    }

    public Collection<Meter> getAllMeters() {
        return this.store.getAllMeters();
    }

    private long queryMeters(DeviceId device) {
        DriverHandler handler = this.driverService.createHandler(device, new String[0]);
        if (handler == null || !handler.hasBehaviour(MeterQuery.class)) {
            return 0L;
        }
        MeterQuery query = (MeterQuery)handler.behaviour(MeterQuery.class);
        return query.getMaxMeters();
    }

    private MeterId allocateMeterId(DeviceId deviceId) {
        MeterId meterid = this.store.firstReusableMeterId(deviceId);
        if (meterid != null) {
            return meterid;
        }
        long maxMeters = this.store.getMaxMeters(MeterFeaturesKey.key((DeviceId)deviceId));
        if (maxMeters == 0L) {
            maxMeters = this.queryMeters(deviceId);
        }
        if (maxMeters == 0L) {
            throw new IllegalStateException("Meters not supported by device " + deviceId);
        }
        long mmeters = maxMeters;
        long id = this.meterIdCounters.compute(deviceId, (k, v) -> {
            if (v == null) {
                return this.allocateCounter((DeviceId)k);
            }
            if (v.get() >= mmeters) {
                throw new IllegalStateException("Maximum number of meters " + this.meterIdCounters.get(deviceId).get() + " reached for device " + deviceId);
            }
            return v;
        }).incrementAndGet();
        return MeterId.meterId((long)id);
    }

    private AtomicCounter allocateCounter(DeviceId deviceId) {
        return this.storageService.getAtomicCounter(String.format(METERCOUNTERIDENTIFIER, deviceId));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindStore(MeterStore meterStore) {
        this.store = meterStore;
    }

    protected void unbindStore(MeterStore meterStore) {
        if (this.store == meterStore) {
            this.store = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class InternalMeterStoreDelegate
    implements MeterStoreDelegate {
        private InternalMeterStoreDelegate() {
        }

        public void notify(MeterEvent event) {
            DeviceId deviceId = ((Meter)event.subject()).deviceId();
            MeterProvider p = (MeterProvider)MeterManager.this.getProvider(((Meter)event.subject()).deviceId());
            switch ((MeterEvent.Type)event.type()) {
                case METER_ADD_REQ: {
                    p.performMeterOperation(deviceId, new MeterOperation((Meter)event.subject(), MeterOperation.Type.ADD));
                    break;
                }
                case METER_REM_REQ: {
                    p.performMeterOperation(deviceId, new MeterOperation((Meter)event.subject(), MeterOperation.Type.REMOVE));
                    break;
                }
                case METER_ADDED: {
                    MeterManager.this.log.info("Meter added {}", event.subject());
                    break;
                }
                case METER_REMOVED: {
                    MeterManager.this.log.info("Meter removed {}", event.subject());
                    break;
                }
                default: {
                    MeterManager.this.log.warn("Unknown meter event {}", (Object)event.type());
                }
            }
        }
    }

    private class InternalMeterProviderService
    extends AbstractProviderService<MeterProvider>
    implements MeterProviderService {
        protected InternalMeterProviderService(MeterProvider provider) {
            super((Provider)provider);
        }

        public void meterOperationFailed(MeterOperation operation, MeterFailReason reason) {
            MeterManager.this.store.failedMeter(operation, reason);
        }

        public void pushMeterMetrics(DeviceId deviceId, Collection<Meter> meterEntries) {
            Map storedMeterMap = MeterManager.this.store.getAllMeters().stream().collect(Collectors.toMap(m -> Pair.of((Object)m.deviceId(), (Object)m.id()), Function.identity()));
            Map<MeterId, Meter> meterEntriesMap = meterEntries.stream().collect(Collectors.toMap(Meter::id, Meter2 -> Meter2));
            storedMeterMap.keySet().stream().filter(m -> ((DeviceId)m.getLeft()).equals((Object)deviceId)).forEach(m -> {
                if (!meterEntriesMap.containsKey(m.getRight())) {
                    Meter meter = (Meter)storedMeterMap.get(Pair.of((Object)deviceId, (Object)m.getRight()));
                    ((MeterProvider)this.provider()).performMeterOperation(deviceId, new MeterOperation(meter, MeterOperation.Type.ADD));
                }
            });
            meterEntries.stream().filter(m -> storedMeterMap.remove(Pair.of((Object)m.deviceId(), (Object)m.id())) != null).forEach(m -> MeterManager.this.store.updateMeterState(m));
            storedMeterMap.values().forEach(m -> {
                if (m.state() == MeterState.PENDING_ADD) {
                    ((MeterProvider)this.provider()).performMeterOperation(m.deviceId(), new MeterOperation(m, MeterOperation.Type.MODIFY));
                } else if (m.state() == MeterState.PENDING_REMOVE) {
                    MeterManager.this.store.deleteMeterNow(m);
                }
            });
        }

        public void pushMeterFeatures(DeviceId deviceId, MeterFeatures meterfeatures) {
            MeterManager.this.store.storeMeterFeatures(meterfeatures);
        }

        public void deleteMeterFeatures(DeviceId deviceId) {
            MeterManager.this.store.deleteMeterFeatures(deviceId);
        }
    }
}

