/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.mcast.impl;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastListener;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.McastStore;
import org.onosproject.net.mcast.McastStoreDelegate;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class MulticastRouteManager
extends AbstractListenerManager<McastEvent, McastListener>
implements MulticastRouteService {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final McastStoreDelegate delegate = new InternalMcastStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected McastStore store;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(McastEvent.class, (EventSink)this.listenerRegistry);
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(McastEvent.class);
        this.log.info("Stopped");
    }

    public void add(McastRoute route) {
        Preconditions.checkNotNull((Object)route, (Object)"Route cannot be null");
        this.store.storeRoute(route, McastStore.Type.ADD);
    }

    public void remove(McastRoute route) {
        Preconditions.checkNotNull((Object)route, (Object)"Route cannot be null");
        this.store.storeRoute(route, McastStore.Type.REMOVE);
    }

    public Set<McastRoute> getRoutes() {
        return this.store.getRoutes();
    }

    public void addSource(McastRoute route, ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)route, (Object)"Route cannot be null");
        Preconditions.checkNotNull((Object)connectPoint, (Object)"Source cannot be null");
        this.store.storeSource(route, connectPoint);
    }

    public void addSink(McastRoute route, ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)route, (Object)"Route cannot be null");
        Preconditions.checkNotNull((Object)connectPoint, (Object)"Sink cannot be null");
        this.store.storeSink(route, connectPoint, McastStore.Type.ADD);
    }

    public void removeSink(McastRoute route, ConnectPoint connectPoint) {
        Preconditions.checkNotNull((Object)route, (Object)"Route cannot be null");
        Preconditions.checkNotNull((Object)connectPoint, (Object)"Sink cannot be null");
        this.store.storeSink(route, connectPoint, McastStore.Type.REMOVE);
    }

    public ConnectPoint fetchSource(McastRoute route) {
        return this.store.sourceFor(route);
    }

    public Set<ConnectPoint> fetchSinks(McastRoute route) {
        return this.store.sinksFor(route);
    }

    protected void bindStore(McastStore mcastStore) {
        this.store = mcastStore;
    }

    protected void unbindStore(McastStore mcastStore) {
        if (this.store == mcastStore) {
            this.store = null;
        }
    }

    private class InternalMcastStoreDelegate
    implements McastStoreDelegate {
        private InternalMcastStoreDelegate() {
        }

        public void notify(McastEvent event) {
            MulticastRouteManager.this.post((Event)event);
        }
    }
}

