/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.intf.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.incubator.net.config.basics.InterfaceConfig;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceAdminService;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class InterfaceManager
extends ListenerRegistry<InterfaceEvent, InterfaceListener>
implements InterfaceService,
InterfaceAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Class<ConnectPoint> SUBJECT_CLASS = ConnectPoint.class;
    private static final Class<InterfaceConfig> CONFIG_CLASS = InterfaceConfig.class;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    private final InternalConfigListener listener = new InternalConfigListener();
    private final Map<ConnectPoint, Set<Interface>> interfaces = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.configService.addListener((EventListener)this.listener);
        for (ConnectPoint subject : this.configService.getSubjects(SUBJECT_CLASS, CONFIG_CLASS)) {
            InterfaceConfig config = (InterfaceConfig)this.configService.getConfig((Object)subject, CONFIG_CLASS);
            if (config == null) continue;
            this.updateInterfaces(config);
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.configService.removeListener((EventListener)this.listener);
        this.log.info("Stopped");
    }

    public Set<Interface> getInterfaces() {
        return (Set)this.interfaces.values().stream().flatMap(set -> set.stream()).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    }

    public Interface getInterfaceByName(ConnectPoint connectPoint, String name) {
        Optional<Interface> intf = this.interfaces.getOrDefault(connectPoint, Collections.emptySet()).stream().filter(i -> i.name().equals(name)).findAny();
        return intf.orElse(null);
    }

    public Set<Interface> getInterfacesByPort(ConnectPoint port) {
        Set<Interface> intfs = this.interfaces.get(port);
        if (intfs == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(intfs);
    }

    public Set<Interface> getInterfacesByIp(IpAddress ip) {
        return (Set)this.interfaces.values().stream().flatMap(Collection::stream).filter(intf -> intf.ipAddressesList().stream().anyMatch(ia -> ia.ipAddress().equals((Object)ip))).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    }

    public Interface getMatchingInterface(IpAddress ip) {
        return this.getMatchingInterfacesStream(ip).findFirst().orElse(null);
    }

    public Set<Interface> getMatchingInterfaces(IpAddress ip) {
        return this.getMatchingInterfacesStream(ip).collect(Collectors.toSet());
    }

    private Stream<Interface> getMatchingInterfacesStream(IpAddress ip) {
        return this.interfaces.values().stream().flatMap(Collection::stream).filter(intf -> intf.ipAddressesList().stream().anyMatch(intfIp -> intfIp.subnetAddress().contains(ip)));
    }

    public Set<Interface> getInterfacesByVlan(VlanId vlan) {
        return (Set)this.interfaces.values().stream().flatMap(Collection::stream).filter(intf -> intf.vlan().equals((Object)vlan)).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    }

    private void updateInterfaces(InterfaceConfig intfConfig) {
        try {
            Set<Object> old = this.interfaces.put((ConnectPoint)intfConfig.subject(), Sets.newHashSet((Iterable)intfConfig.getInterfaces()));
            if (old == null) {
                old = Collections.emptySet();
            }
            for (Interface interface_ : intfConfig.getInterfaces()) {
                if (interface_.name().equals("")) {
                    this.process((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_ADDED, interface_));
                    continue;
                }
                Optional<Interface> oldIntf = this.findInterface(interface_, old);
                if (oldIntf.isPresent()) {
                    old.remove(oldIntf.get());
                    if (oldIntf.get().equals((Object)interface_)) continue;
                    this.process((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_UPDATED, interface_, oldIntf.get()));
                    continue;
                }
                this.process((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_ADDED, interface_));
            }
            for (Interface interface_ : old) {
                if (interface_.name().equals("")) continue;
                this.process((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_REMOVED, interface_));
            }
        }
        catch (ConfigException e) {
            this.log.error("Error in interface config", (Throwable)e);
        }
    }

    private Optional<Interface> findInterface(Interface intf, Set<Interface> set) {
        return set.stream().filter(i -> i.name().equals(intf.name())).findAny();
    }

    private void removeInterfaces(ConnectPoint port) {
        Set<Interface> old = this.interfaces.remove(port);
        old.stream().filter(i -> !i.name().equals("")).forEach(i -> this.process((Event)new InterfaceEvent(InterfaceEvent.Type.INTERFACE_REMOVED, i)));
    }

    public void add(Interface intf) {
        InterfaceConfig config = (InterfaceConfig)this.configService.addConfig((Object)intf.connectPoint(), CONFIG_CLASS);
        config.addInterface(intf);
        this.configService.applyConfig((Object)intf.connectPoint(), CONFIG_CLASS, config.node());
    }

    public boolean remove(ConnectPoint connectPoint, String name) {
        InterfaceConfig config = (InterfaceConfig)this.configService.addConfig((Object)connectPoint, CONFIG_CLASS);
        config.removeInterface(name);
        try {
            if (config.getInterfaces().isEmpty()) {
                this.configService.removeConfig((Object)connectPoint, CONFIG_CLASS);
            } else {
                this.configService.applyConfig((Object)connectPoint, CONFIG_CLASS, config.node());
            }
        }
        catch (ConfigException e) {
            this.log.error("Error reading interfaces JSON", (Throwable)e);
            return false;
        }
        return true;
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass() == CONFIG_CLASS) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: {
                        InterfaceConfig config = (InterfaceConfig)InterfaceManager.this.configService.getConfig((Object)((ConnectPoint)event.subject()), InterfaceConfig.class);
                        InterfaceManager.this.updateInterfaces(config);
                        break;
                    }
                    case CONFIG_REMOVED: {
                        InterfaceManager.this.removeInterfaces((ConnectPoint)event.subject());
                        break;
                    }
                }
            }
        }
    }
}

