/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.Load;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PortStatisticsManager
implements PortStatisticsService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long POLL_FREQUENCY = 10000L;
    private static final long STALE_LIMIT = 15000L;
    private static final int SECOND = 1000;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private Map<ConnectPoint, DataPoint> current = Maps.newConcurrentMap();
    private Map<ConnectPoint, DataPoint> previous = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.log.info("Stopped");
    }

    public Load load(ConnectPoint connectPoint) {
        return this.load(connectPoint, PortStatisticsService.MetricType.BYTES);
    }

    public Load load(ConnectPoint connectPoint, PortStatisticsService.MetricType metricType) {
        DataPoint c = this.current.get(connectPoint);
        DataPoint p = this.previous.get(connectPoint);
        long now = System.currentTimeMillis();
        if (c != null && p != null && now - c.time < 15000L && c.time > p.time + 1000L) {
            long cve = this.getEgressValue(c.stats, metricType);
            long cvi = this.getIngressValue(c.stats, metricType);
            long pve = this.getEgressValue(p.stats, metricType);
            long pvi = this.getIngressValue(p.stats, metricType);
            DefaultLoad load = null;
            if (cve >= pve) {
                load = new DefaultLoad(cve, pve, (long)((int)(c.time - p.time) / 1000));
            }
            if (cvi >= pvi) {
                DefaultLoad rcvLoad = new DefaultLoad(cvi, pvi, (long)((int)(c.time - p.time) / 1000));
                load = load == null || rcvLoad.rate() > load.rate() ? rcvLoad : load;
            }
            return load;
        }
        return null;
    }

    private long getEgressValue(PortStatistics stats, PortStatisticsService.MetricType metricType) {
        return metricType == PortStatisticsService.MetricType.BYTES ? stats.bytesSent() : stats.packetsSent();
    }

    private long getIngressValue(PortStatistics stats, PortStatisticsService.MetricType metricType) {
        return metricType == PortStatisticsService.MetricType.BYTES ? stats.bytesReceived() : stats.packetsReceived();
    }

    private void updateDeviceData(DeviceId deviceId) {
        this.deviceService.getPortStatistics(deviceId).forEach(stats -> this.updatePortData(deviceId, (PortStatistics)stats));
    }

    private void updatePortData(DeviceId deviceId, PortStatistics stats) {
        ConnectPoint cp = new ConnectPoint((ElementId)deviceId, PortNumber.portNumber((long)stats.port()));
        DataPoint c = this.current.get(cp);
        this.current.put(cp, new DataPoint(stats));
        if (c != null) {
            this.previous.put(cp, c);
        }
    }

    private void pruneDeviceData(DeviceId deviceId) {
        this.pruneMap(this.current, deviceId);
        this.pruneMap(this.previous, deviceId);
    }

    private void pruneMap(Map<ConnectPoint, DataPoint> map, DeviceId deviceId) {
        map.keySet().stream().filter(cp -> deviceId.equals((Object)cp.deviceId())).collect(Collectors.toSet()).forEach(map::remove);
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class DataPoint {
        long time = System.currentTimeMillis();
        PortStatistics stats;

        DataPoint(PortStatistics stats) {
            this.stats = stats;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            DeviceEvent.Type type = (DeviceEvent.Type)event.type();
            DeviceId deviceId = ((Device)event.subject()).id();
            if (type == DeviceEvent.Type.PORT_STATS_UPDATED) {
                PortStatisticsManager.this.updateDeviceData(deviceId);
            } else if (type == DeviceEvent.Type.DEVICE_REMOVED || type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED && !PortStatisticsManager.this.deviceService.isAvailable(deviceId)) {
                PortStatisticsManager.this.pruneDeviceData(deviceId);
            }
        }
    }
}

