/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.dpi.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.dpi.DpiStatInfo;
import org.onosproject.incubator.net.dpi.DpiStatistics;
import org.onosproject.incubator.net.dpi.DpiStatisticsManagerService;
import org.onosproject.incubator.net.dpi.FlowStatInfo;
import org.onosproject.incubator.net.dpi.ProtocolStatInfo;
import org.onosproject.incubator.net.dpi.TrafficStatInfo;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DpiStatisticsManager
implements DpiStatisticsManagerService {
    private static ServerSocket serverSocket;
    private static int port;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private ApplicationId appId;
    private final ExecutorService dpiListenerThread = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/apps/dpi", (String)"dpi-listener"));
    DpiStatisticsListener dpiStatisticsListener = null;
    private static final int MAX_DPI_STATISTICS_ENTRY = 1071360;
    private SortedMap<String, DpiStatistics> dpiStatisticsMap = new TreeMap<String, DpiStatistics>(new MapComparator());
    private static final String DATE_FMT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_ZONE = "GMT";
    public static final int MAX_DPI_STATISTICS_REQUEST = 100;
    public static final int MAX_DPI_STATISTICS_TOPN = 100;

    private long convertTimeToLong(String timeString) {
        long timeLong = 0L;
        try {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FMT, Locale.KOREA);
            df.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
            timeLong = df.parse(timeString).getTime();
        }
        catch (ParseException e) {
            this.log.error("Time parse error! Exception={}", (Object)e.toString());
        }
        return timeLong;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication("org.onosproject.dpi");
        this.dpiStatisticsListener = new DpiStatisticsListener();
        this.dpiListenerThread.execute(this.dpiStatisticsListener);
        this.log.info("Started", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Deactivated...");
        this.dpiListenerThread.shutdownNow();
        this.log.info("Stopped");
    }

    public DpiStatistics getDpiStatisticsLatest() {
        if (this.dpiStatisticsMap.size() > 0) {
            return (DpiStatistics)this.dpiStatisticsMap.get(this.dpiStatisticsMap.firstKey());
        }
        return null;
    }

    public DpiStatistics getDpiStatisticsLatest(int topnProtocols, int topnFlows) {
        DpiStatistics ds = this.getDpiStatisticsLatest();
        DpiStatistics topnDs = this.processTopn(ds, topnProtocols, topnFlows);
        return topnDs;
    }

    public List<DpiStatistics> getDpiStatistics(int lastN) {
        ArrayList<DpiStatistics> dsList = new ArrayList<DpiStatistics>();
        if (lastN > 100) {
            lastN = 100;
        }
        TreeMap<String, DpiStatistics> tempMap = new TreeMap<String, DpiStatistics>(new MapComparator());
        tempMap.putAll(this.dpiStatisticsMap);
        for (int i = 0; i < lastN && i < tempMap.size(); ++i) {
            DpiStatistics ds = (DpiStatistics)tempMap.get(tempMap.firstKey());
            dsList.add(i, new DpiStatistics(ds.receivedTime(), ds.dpiStatInfo()));
            tempMap.remove(tempMap.firstKey());
        }
        return dsList;
    }

    public List<DpiStatistics> getDpiStatistics(int lastN, int topnProtocols, int topnFlows) {
        ArrayList<DpiStatistics> topnDsList = new ArrayList<DpiStatistics>();
        List<DpiStatistics> dsList = this.getDpiStatistics(lastN);
        for (int i = 0; i < dsList.size(); ++i) {
            DpiStatistics ds = dsList.get(i);
            DpiStatistics topnDs = this.processTopn(ds, topnProtocols, topnFlows);
            topnDsList.add(i, topnDs);
        }
        return topnDsList;
    }

    public DpiStatistics getDpiStatistics(String receivedTime) {
        if (receivedTime == null) {
            return null;
        }
        if (!this.dpiStatisticsMap.containsKey(receivedTime)) {
            return null;
        }
        DpiStatistics ds = (DpiStatistics)this.dpiStatisticsMap.get(receivedTime);
        return ds;
    }

    public DpiStatistics getDpiStatistics(String receivedTime, int topnProtocols, int topnFlows) {
        DpiStatistics ds = this.getDpiStatistics(receivedTime);
        DpiStatistics topnDs = this.processTopn(ds, topnProtocols, topnFlows);
        return topnDs;
    }

    public DpiStatistics addDpiStatistics(DpiStatistics ds) {
        if (ds == null) {
            return ds;
        }
        if (this.dpiStatisticsMap.size() > 0) {
            long inputTimeLong;
            String lastTime = ((DpiStatistics)this.dpiStatisticsMap.get(this.dpiStatisticsMap.firstKey())).receivedTime();
            String inputTime = ds.receivedTime();
            long lastTimeLong = this.convertTimeToLong(lastTime);
            if (lastTimeLong >= (inputTimeLong = this.convertTimeToLong(inputTime))) {
                return null;
            }
        }
        if (this.dpiStatisticsMap.size() >= 1071360) {
            this.dpiStatisticsMap.remove(this.dpiStatisticsMap.lastKey());
        }
        if (this.dpiStatisticsMap.containsKey(ds.receivedTime())) {
            this.log.warn("addDpiStatistics(), {} dpiStatistics is already existing!", (Object)ds.receivedTime());
            return null;
        }
        this.dpiStatisticsMap.put(ds.receivedTime(), ds);
        this.log.debug("addDpiStatistics: dpiResultJson data[time={}] is added into DpiStatisticsMap size={}.", (Object)ds.receivedTime(), (Object)this.dpiStatisticsMap.size());
        return ds;
    }

    private DpiStatistics processTopn(DpiStatistics ds, int topnProtocols, int topnFlows) {
        if (ds == null) {
            return null;
        }
        if (topnProtocols <= 0) {
            topnProtocols = 0;
        } else if (topnProtocols > 100) {
            topnProtocols = 100;
        }
        if (topnFlows <= 0) {
            topnFlows = 0;
        } else if (topnFlows > 100) {
            topnFlows = 100;
        }
        if (topnProtocols == 0 && topnFlows == 0) {
            return ds;
        }
        TrafficStatInfo tsi = ds.dpiStatInfo().trafficStatistics();
        List pList = ds.dpiStatInfo().detectedProtos();
        Collections.sort(pList, new ProtocolComparator());
        List psiList = topnProtocols > 0 && topnProtocols < pList.size() ? pList.subList(0, topnProtocols) : pList;
        List fList = ds.dpiStatInfo().knownFlows();
        Collections.sort(fList, new FlowComparator());
        List kfList = topnFlows > 0 && topnFlows < fList.size() ? fList.subList(0, topnFlows) : fList;
        fList = ds.dpiStatInfo().unknownFlows();
        Collections.sort(fList, new FlowComparator());
        List ufList = topnFlows > 0 && topnFlows < fList.size() ? fList.subList(0, topnFlows) : fList;
        DpiStatInfo dsi = new DpiStatInfo();
        dsi.setTrafficStatistics(tsi);
        dsi.setDetectedProtos(psiList);
        dsi.setKnownFlows(kfList);
        dsi.setUnknownFlows(ufList);
        DpiStatistics retDs = new DpiStatistics(ds.receivedTime(), dsi);
        return retDs;
    }

    static {
        port = 11990;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class DpiStatisticsListener
    implements Runnable {
        Socket clientSocket = null;
        BufferedReader in = null;
        PrintWriter out = null;
        String resultJsonString = null;
        static final int MAX_SLEEP_COUNT = 10;
        int sleepCount = 0;

        private DpiStatisticsListener() {
        }

        @Override
        public void run() {
            DpiStatisticsManager.this.log.info("DpiStatisticsListener: Receiving thread started...");
            this.receiveDpiResult();
        }

        private void receiveDpiResult() {
            try {
                serverSocket = new ServerSocket(port);
            }
            catch (Exception e) {
                DpiStatisticsManager.this.log.error("DpiStatisticsListener: ServerSocket listening error from port={} in localhost, exception={}", (Object)port, (Object)e.toString());
                return;
            }
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    if (this.clientSocket == null) {
                        DpiStatisticsManager.this.log.info("DpiStatisticsListener: Waiting for accepting from dpi client...");
                        this.clientSocket = serverSocket.accept();
                        DpiStatisticsManager.this.log.info("DpiStatisticsListener: Accepted from dpi client={}", (Object)this.clientSocket.getRemoteSocketAddress().toString());
                        this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                        this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
                        this.resultJsonString = null;
                    }
                    this.sleepCount = 0;
                    while (!this.in.ready()) {
                        Thread.sleep(1000L);
                        if (!this.out.checkError() && ++this.sleepCount < 10) continue;
                        DpiStatisticsManager.this.log.debug("DpiStatisticsListener: server and socket connect is lost...");
                        this.in.close();
                        this.in = null;
                        this.out.close();
                        this.out = null;
                        this.clientSocket.close();
                        this.clientSocket = null;
                        break;
                    }
                    if (this.in == null) continue;
                    this.resultJsonString = this.in.readLine();
                    DpiStatisticsManager.this.log.trace("DpiStatisticsListener: resultJsonString={}", (Object)this.resultJsonString);
                    this.processResultJson(this.resultJsonString);
                }
            }
            catch (Exception e) {
                DpiStatisticsManager.this.log.error("DpiStatisticsListener: Exception = {}", (Object)e.toString());
                return;
            }
            finally {
                try {
                    if (serverSocket != null) {
                        if (this.clientSocket != null) {
                            if (this.in != null) {
                                this.in.close();
                            }
                            if (this.out != null) {
                                this.out.close();
                            }
                            this.clientSocket.close();
                        }
                        serverSocket.close();
                    }
                }
                catch (Exception e) {
                    DpiStatisticsManager.this.log.error("DpiStatisticsListener: stop(): Server Socket closing error, exception={}", (Object)e.toString());
                }
            }
        }

        private void processResultJson(String resultJsonString) {
            DpiStatInfo dpiStatInfo;
            Date tr = new Date(System.currentTimeMillis());
            SimpleDateFormat df = new SimpleDateFormat(DpiStatisticsManager.DATE_FMT, Locale.KOREA);
            df.setTimeZone(TimeZone.getTimeZone(DpiStatisticsManager.TIME_ZONE));
            String curReceivedTime = new String(df.format(tr));
            String curResultJson = new String(resultJsonString);
            ObjectMapper mapper = new ObjectMapper();
            try {
                dpiStatInfo = (DpiStatInfo)mapper.readValue(curResultJson, DpiStatInfo.class);
            }
            catch (IOException e) {
                DpiStatisticsManager.this.log.error("DpiStatisticsListener: ObjectMapper Exception = {}", (Object)e.toString());
                return;
            }
            DpiStatistics dpiStatistics = new DpiStatistics(curReceivedTime, dpiStatInfo);
            DpiStatisticsManager.this.addDpiStatistics(dpiStatistics);
        }
    }

    private class FlowComparator
    implements Comparator<FlowStatInfo> {
        private FlowComparator() {
        }

        @Override
        public int compare(FlowStatInfo f1, FlowStatInfo f2) {
            if (f1.bytes() > f2.bytes()) {
                return -1;
            }
            if (f1.bytes() < f2.bytes()) {
                return 1;
            }
            return 0;
        }
    }

    private class ProtocolComparator
    implements Comparator<ProtocolStatInfo> {
        private ProtocolComparator() {
        }

        @Override
        public int compare(ProtocolStatInfo p1, ProtocolStatInfo p2) {
            if (p1.bytes() > p2.bytes()) {
                return -1;
            }
            if (p1.bytes() < p2.bytes()) {
                return 1;
            }
            return 0;
        }
    }

    private class MapComparator
    implements Comparator<String> {
        private MapComparator() {
        }

        @Override
        public int compare(String rt1, String rt2) {
            long rt2Long;
            long rt1Long = DpiStatisticsManager.this.convertTimeToLong(rt1);
            if (rt1Long > (rt2Long = DpiStatisticsManager.this.convertTimeToLong(rt2))) {
                return -1;
            }
            if (rt1Long < rt2Long) {
                return 1;
            }
            return 0;
        }
    }
}

