/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.domain.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.incubator.net.domain.IntentDomain;
import org.onosproject.incubator.net.domain.IntentDomainEvent;
import org.onosproject.incubator.net.domain.IntentDomainId;
import org.onosproject.incubator.net.domain.IntentDomainListener;
import org.onosproject.incubator.net.domain.IntentDomainProvider;
import org.onosproject.incubator.net.domain.IntentDomainProviderRegistry;
import org.onosproject.incubator.net.domain.IntentDomainProviderService;
import org.onosproject.incubator.net.domain.IntentDomainService;
import org.onosproject.incubator.net.domain.IntentPrimitive;
import org.onosproject.incubator.net.domain.IntentResource;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class IntentDomainManager
extends AbstractListenerProviderRegistry<IntentDomainEvent, IntentDomainListener, IntentDomainProvider, IntentDomainProviderService>
implements IntentDomainService,
IntentDomainProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<IntentDomainId, IntentDomain> domains = Maps.newConcurrentMap();

    @Activate
    protected void activate() {
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    public IntentDomain getDomain(IntentDomainId id) {
        return (IntentDomain)this.domains.get(id);
    }

    public Set<IntentDomain> getDomains() {
        return ImmutableSet.copyOf(this.domains.values());
    }

    public Set<IntentDomain> getDomains(DeviceId deviceId) {
        return this.domains.values().stream().filter(domain -> domain.internalDevices().contains(deviceId) || domain.edgePorts().stream().map(ConnectPoint::deviceId).anyMatch(d -> d.equals((Object)deviceId))).collect(Collectors.toSet());
    }

    public List<IntentResource> request(IntentDomainId domainId, IntentPrimitive primitive) {
        IntentDomain domain = this.getDomain(domainId);
        return domain.provider().request(domain, primitive);
    }

    public void submit(IntentDomainId domainId, IntentResource resource) {
        this.getDomain(domainId).provider().apply(resource);
    }

    protected IntentDomainProviderService createProviderService(IntentDomainProvider provider) {
        return new InternalDomainProviderService(provider);
    }

    private class InternalDomainProviderService
    extends AbstractProviderService<IntentDomainProvider>
    implements IntentDomainProviderService {
        InternalDomainProviderService(IntentDomainProvider provider) {
            super((Provider)provider);
        }
    }
}

