/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.config.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ExtraNetworkConfigs {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<ConfigFactory> factories = ImmutableSet.of();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry registry;

    @Activate
    public void activate() {
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.registry).registerConfigFactory(arg_0));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.registry).unregisterConfigFactory(arg_0));
        this.log.info("Stopped");
    }

    protected void bindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.registry = networkConfigRegistry;
    }

    protected void unbindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.registry == networkConfigRegistry) {
            this.registry = null;
        }
    }
}

