/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.CoreService;
import org.onosproject.yang.model.ModelConverter;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaContextProvider;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.CompositeStream;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.RuntimeContext;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.onosproject.yang.runtime.YangRuntimeService;
import org.onosproject.yang.runtime.YangSerializer;
import org.onosproject.yang.runtime.YangSerializerRegistry;
import org.onosproject.yang.runtime.impl.DefaultModelConverter;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.DefaultYangRuntimeHandler;
import org.onosproject.yang.runtime.impl.DefaultYangSerializerRegistry;
import org.onosproject.yang.serializers.json.JsonSerializer;
import org.onosproject.yang.serializers.xml.XmlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Service
@Component(immediate=true)
public class YangRuntimeManager
implements YangModelRegistry,
YangSerializerRegistry,
YangRuntimeService,
ModelConverter,
SchemaContextProvider {
    private static final String APP_ID = "org.onosproject.yang";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private DefaultYangModelRegistry modelRegistry;
    private DefaultYangSerializerRegistry serializerRegistry;
    private DefaultYangRuntimeHandler runtimeService;
    private DefaultModelConverter modelConverter;

    @Activate
    public void activate() {
        this.coreService.registerApplication(APP_ID);
        this.serializerRegistry = new DefaultYangSerializerRegistry();
        this.modelRegistry = new DefaultYangModelRegistry();
        this.runtimeService = new DefaultYangRuntimeHandler((YangSerializerRegistry)this.serializerRegistry, (SchemaContext)this.modelRegistry);
        this.serializerRegistry.registerSerializer((YangSerializer)new JsonSerializer());
        this.serializerRegistry.registerSerializer((YangSerializer)new XmlSerializer());
        this.modelConverter = new DefaultModelConverter(this.modelRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void registerModel(ModelRegistrationParam p) {
        this.modelRegistry.registerModel(p);
    }

    public void unregisterModel(ModelRegistrationParam p) {
        this.modelRegistry.unregisterModel(p);
    }

    public Set<YangModel> getModels() {
        return this.modelRegistry.getModels();
    }

    public void registerSerializer(YangSerializer ys) {
        this.serializerRegistry.registerSerializer(ys);
    }

    public void unregisterSerializer(YangSerializer ys) {
        this.serializerRegistry.unregisterSerializer(ys);
    }

    public Set<YangSerializer> getSerializers() {
        return this.serializerRegistry.getSerializers();
    }

    public CompositeData decode(CompositeStream cs, RuntimeContext rc) {
        return this.runtimeService.decode(cs, rc);
    }

    public CompositeStream encode(CompositeData cd, RuntimeContext rc) {
        return this.runtimeService.encode(cd, rc);
    }

    public ModelObjectData createModel(ResourceData resourceData) {
        return this.modelConverter.createModel(resourceData);
    }

    public ResourceData createDataNode(ModelObjectData modelObjectData) {
        return this.modelConverter.createDataNode(modelObjectData);
    }

    public SchemaContext getSchemaContext(ResourceId resourceId) {
        Preconditions.checkNotNull((Object)resourceId, (Object)" resource id can't be null.");
        NodeKey key = (NodeKey)resourceId.nodeKeys().get(0);
        if (resourceId.nodeKeys().size() == 1 && "/".equals(key.schemaId().name())) {
            return this.modelRegistry;
        }
        this.log.info("To be implemented.");
        return null;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

