/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.runtime.YangModelRegistry;

@Command(scope="onos", name="models", description="Lists registered YANG models")
public class YangModelsListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "moduleName=%s moduleRevision=%s modelId=%s";
    private static final String MODULE_NAME = "moduleName";
    private static final String MODULE_REVISION = "moduleRevision";

    protected void execute() {
        YangModelRegistry service = (YangModelRegistry)YangModelsListCommand.get(YangModelRegistry.class);
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.json(service)});
        } else {
            for (YangModel model : service.getModels()) {
                for (YangModule module : model.getYangModules()) {
                    this.print(FORMAT, new Object[]{module.getYangModuleId().moduleName(), module.getYangModuleId().revision(), this.modelId(model)});
                }
            }
        }
    }

    private JsonNode json(YangModelRegistry service) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode();
        for (YangModel model : service.getModels()) {
            ArrayNode modelNode = mapper.createArrayNode();
            result.set(this.modelId(model), (JsonNode)modelNode);
            for (YangModule module : model.getYangModules()) {
                ObjectNode moduleNode = mapper.createObjectNode();
                modelNode.add((JsonNode)moduleNode);
                moduleNode.put(MODULE_NAME, module.getYangModuleId().moduleName());
                moduleNode.put(MODULE_REVISION, module.getYangModuleId().revision());
            }
        }
        return result;
    }

    private String modelId(YangModel m) {
        return "YM" + Math.abs(m.hashCode());
    }
}

