/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.AppModuleInfo;
import org.onosproject.yang.runtime.DefaultModelRegistrationParam;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.onosproject.yang.runtime.helperutils.YangApacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public abstract class AbstractYangModelRegistrator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<?> loaderClass;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected YangModelRegistry modelRegistry;
    private Map<YangModuleId, AppModuleInfo> appInfo;
    private YangModel model;
    private ModelRegistrationParam registrationParam;

    protected AbstractYangModelRegistrator(Class<?> loaderClass) {
        this.loaderClass = loaderClass;
    }

    protected AbstractYangModelRegistrator(Class<?> loaderClass, Map<YangModuleId, AppModuleInfo> appInfo) {
        this.loaderClass = loaderClass;
        this.appInfo = appInfo;
    }

    @Activate
    protected void activate() {
        this.model = YangApacheUtils.getYangModel(this.loaderClass);
        ModelRegistrationParam.Builder b = DefaultModelRegistrationParam.builder().setYangModel(this.model);
        this.registrationParam = this.getAppInfo(b).setYangModel(this.model).build();
        this.modelRegistry.registerModel(this.registrationParam);
        this.log.info("Started");
    }

    private ModelRegistrationParam.Builder getAppInfo(ModelRegistrationParam.Builder b) {
        if (this.appInfo != null) {
            this.appInfo.entrySet().stream().filter(entry -> this.model.getYangModule((YangModuleId)entry.getKey()) != null).forEach(entry -> b.addAppModuleInfo((YangModuleId)entry.getKey(), (AppModuleInfo)entry.getValue()));
        }
        return b;
    }

    @Deactivate
    protected void deactivate() {
        this.modelRegistry.unregisterModel(this.registrationParam);
        this.log.info("Stopped");
    }

    protected void bindModelRegistry(YangModelRegistry yangModelRegistry) {
        this.modelRegistry = yangModelRegistry;
    }

    protected void unbindModelRegistry(YangModelRegistry yangModelRegistry) {
        if (this.modelRegistry == yangModelRegistry) {
            this.modelRegistry = null;
        }
    }
}

