/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.alarms.gui;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.faultmanagement.alarms.gui.AlarmMonitor;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.TopoJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmTopovMessageHandler
extends UiMessageHandler {
    private static final String ALARM_TOPOV_DISPLAY_START = "alarmTopovDisplayStart";
    private static final String ALARM_TOPOV_DISPLAY_STOP = "alarmTopovDisplayStop";
    private static final int DELAY_MS = 500;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected AlarmService alarmService;
    private DeviceService deviceService;
    private AlarmMonitor alarmMonitor;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.alarmService = (AlarmService)directory.get(AlarmService.class);
        this.alarmMonitor = new AlarmMonitor(this);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new DisplayStartHandler()), (Object)((Object)new DisplayStopHandler()));
    }

    protected void sendDelayedAlarmHighlights() {
        this.createAndSendHighlights(true);
    }

    protected void sendAlarmHighlights() {
        this.createAndSendHighlights(false);
    }

    private void createAndSendHighlights(boolean toDelay) {
        Highlights highlights = new Highlights();
        this.createBadges(highlights);
        if (toDelay) {
            highlights.delay(500);
        }
        this.sendHighlights(highlights);
    }

    private void sendHighlights(Highlights highlights) {
        this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
    }

    private void createBadges(Highlights highlights) {
        this.deviceService.getAvailableDevices().forEach(d -> {
            Set alarmsOnDevice = this.alarmService.getAlarms(d.id());
            int alarmSize = alarmsOnDevice.size();
            this.log.debug("{} Alarms on device {}", (Object)alarmSize, (Object)d.id());
            if (alarmSize > 0) {
                this.addDeviceBadge(highlights, d.id(), alarmSize);
            }
        });
    }

    private void clearHighlights() {
        this.sendHighlights(new Highlights());
    }

    private void addDeviceBadge(Highlights h, DeviceId devId, int n) {
        DeviceHighlight dh = new DeviceHighlight(devId.toString());
        dh.setBadge(this.createBadge(n));
        h.add(dh);
    }

    private NodeBadge createBadge(int n) {
        NodeBadge.Status status = n > 0 ? NodeBadge.Status.ERROR : NodeBadge.Status.INFO;
        String noun = n > 0 ? "(Alarmed)" : "(Normal)";
        String msg = "Alarms: " + n + " " + noun;
        return NodeBadge.number((NodeBadge.Status)status, (int)n, (String)msg);
    }

    private final class DisplayStopHandler
    extends RequestHandler {
        public DisplayStopHandler() {
            super(AlarmTopovMessageHandler.ALARM_TOPOV_DISPLAY_STOP);
        }

        public void process(ObjectNode payload) {
            AlarmTopovMessageHandler.this.log.debug("Stop Display");
            AlarmTopovMessageHandler.this.alarmMonitor.stopMonitoring();
            AlarmTopovMessageHandler.this.clearHighlights();
        }
    }

    private final class DisplayStartHandler
    extends RequestHandler {
        public DisplayStartHandler() {
            super(AlarmTopovMessageHandler.ALARM_TOPOV_DISPLAY_START);
        }

        public void process(ObjectNode payload) {
            AlarmTopovMessageHandler.this.log.debug("Start Display");
            AlarmTopovMessageHandler.this.sendDelayedAlarmHighlights();
            AlarmTopovMessageHandler.this.alarmMonitor.startMonitorig();
        }
    }
}

