/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.codec.CodecContext;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteAdminService;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="routes")
public class RoutesWebResource
extends AbstractWebResource {
    @GET
    @Produces(value={"application/json"})
    public Response getRoutes() {
        RouteService service = (RouteService)this.get(RouteService.class);
        ObjectNode root = this.mapper().createObjectNode();
        service.getRouteTables().forEach(table -> {
            List routes = service.getRoutes(table).stream().flatMap(ri -> ri.allRoutes().stream()).map(ResolvedRoute::route).collect(Collectors.toList());
            root.put(table.name(), (JsonNode)this.codec(Route.class).encode(routes, (CodecContext)this));
        });
        return RoutesWebResource.ok((Object)root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRoute(InputStream route) {
        RouteAdminService service = (RouteAdminService)this.get(RouteAdminService.class);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(route);
            Route r = (Route)this.codec(Route.class).decode(jsonTree, (CodecContext)this);
            service.update(Collections.singletonList(r));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.created((URI)URI.create("")).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response deleteRoute(InputStream route) {
        RouteAdminService service = (RouteAdminService)this.get(RouteAdminService.class);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(route);
            Route r = (Route)this.codec(Route.class).decode(jsonTree, (CodecContext)this);
            service.withdraw(Collections.singletonList(r));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.noContent().build();
    }
}

