/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="mcast")
@Beta
public class MulticastRouteWebResource
extends AbstractWebResource {
    @GET
    @Produces(value={"application/json"})
    public Response getRoutes() {
        Set routes = ((MulticastRouteService)this.get(MulticastRouteService.class)).getRoutes();
        ObjectNode root = this.encodeArray(McastRoute.class, "routes", (Iterable)routes);
        return MulticastRouteWebResource.ok((Object)root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRoute(InputStream stream) {
        MulticastRouteService service = (MulticastRouteService)this.get(MulticastRouteService.class);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            McastRoute route = (McastRoute)this.codec(McastRoute.class).decode(jsonTree, (CodecContext)this);
            service.add(route);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.created((URI)URI.create("")).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response deleteRoute(InputStream stream) {
        MulticastRouteService service = (MulticastRouteService)this.get(MulticastRouteService.class);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            McastRoute route = (McastRoute)this.codec(McastRoute.class).decode(jsonTree, (CodecContext)this);
            service.remove(route);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="sinks/{group}/{source}")
    public Response addSinks(@PathParam(value="group") String group, @PathParam(value="source") String source, InputStream stream) {
        MulticastRouteService service = (MulticastRouteService)this.get(MulticastRouteService.class);
        try {
            McastRoute route = new McastRoute(IpAddress.valueOf((String)source), IpAddress.valueOf((String)group), McastRoute.Type.STATIC);
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            jsonTree.path("sinks").forEach(node -> {
                ConnectPoint sink = ConnectPoint.deviceConnectPoint((String)node.asText());
                service.addSink(route, sink);
            });
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.created((URI)URI.create("")).build();
    }
}

