/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.net.intent.util.IntentFilter;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.rest.resources.IntentsWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="intents")
public class IntentsWebResource
extends AbstractWebResource {
    private static final Logger log = LoggerFactory.getLogger(IntentsWebResource.class);
    private static final int WITHDRAW_EVENT_TIMEOUT_SECONDS = 5;
    private static final String APP_ID_NOT_FOUND = "Application Id not found";
    private static final String HOST_TO_HOST_INTENT = "HostToHostIntent";
    private static final String POINT_TO_POINT_INTENT = "PointToPointIntent";
    private static final String SINGLE_TO_MULTI_POINT_INTENT = "SinglePointToMultiPointIntent";
    private static final String INTENT = "Intent";
    private static final String APP_ID = "appId";
    private static final String ID = "id";
    private static final String INTENT_PATHS = "paths";
    private static final String INTENT_TYPE = "type";
    private static final String INTENT_NOT_FOUND = "Intent is not found";
    @Context
    private UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response getIntents() {
        Iterable intents = ((IntentService)this.get(IntentService.class)).getIntents();
        ObjectNode root = this.encodeArray(Intent.class, "intents", intents);
        return IntentsWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{appId}/{key}")
    public Response getIntentById(@PathParam(value="appId") String appId, @PathParam(value="key") String key) {
        ApplicationId app = ((CoreService)this.get(CoreService.class)).getAppId(appId);
        Tools.nullIsNotFound((Object)app, (String)"Application Id not found");
        Intent intent = ((IntentService)this.get(IntentService.class)).getIntent(Key.of((String)key, (ApplicationId)app));
        if (intent == null) {
            long numericalKey = Long.decode(key);
            intent = ((IntentService)this.get(IntentService.class)).getIntent(Key.of((long)numericalKey, (ApplicationId)app));
        }
        Tools.nullIsNotFound((Object)intent, (String)"Intent is not found");
        ObjectNode root = intent instanceof HostToHostIntent ? this.codec(HostToHostIntent.class).encode((Object)((HostToHostIntent)intent), (CodecContext)this) : (intent instanceof PointToPointIntent ? this.codec(PointToPointIntent.class).encode((Object)((PointToPointIntent)intent), (CodecContext)this) : (intent instanceof SinglePointToMultiPointIntent ? this.codec(SinglePointToMultiPointIntent.class).encode((Object)((SinglePointToMultiPointIntent)intent), (CodecContext)this) : this.codec(Intent.class).encode((Object)intent, (CodecContext)this)));
        return IntentsWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="relatedflows/{appId}/{key}")
    public Response getIntentFlowsById(@PathParam(value="appId") String appId, @PathParam(value="key") String key) {
        ApplicationId applicationId = ((CoreService)this.get(CoreService.class)).getAppId(appId);
        Tools.nullIsNotFound((Object)applicationId, (String)"Application Id not found");
        IntentService intentService = (IntentService)this.get(IntentService.class);
        FlowRuleService flowService = (FlowRuleService)this.get(FlowRuleService.class);
        Intent intent = intentService.getIntent(Key.of((String)key, (ApplicationId)applicationId));
        if (intent == null) {
            long numericalKey = Long.decode(key);
            intent = intentService.getIntent(Key.of((long)numericalKey, (ApplicationId)applicationId));
        }
        Tools.nullIsNotFound((Object)intent, (String)"Intent is not found");
        ObjectNode root = this.mapper().createObjectNode();
        root.put("appId", appId);
        root.put("id", key);
        IntentFilter intentFilter = new IntentFilter(intentService, flowService);
        List installables = intentService.getInstallableIntents(intent.key());
        if (intent instanceof HostToHostIntent) {
            root.put("type", "HostToHostIntent");
        } else if (intent instanceof PointToPointIntent) {
            root.put("type", "PointToPointIntent");
        } else if (intent instanceof SinglePointToMultiPointIntent) {
            root.put("type", "SinglePointToMultiPointIntent");
        } else {
            root.put("type", "Intent");
        }
        ArrayNode pathsNode = root.putArray("paths");
        for (List flowEntries : intentFilter.readIntentFlows(installables)) {
            ArrayNode flowNode = pathsNode.addArray();
            for (FlowEntry entry : flowEntries) {
                flowNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
            }
        }
        return IntentsWebResource.ok((Object)root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createIntent(InputStream stream) {
        try {
            IntentService service = (IntentService)this.get(IntentService.class);
            ObjectNode root = (ObjectNode)this.mapper().readTree(stream);
            Intent intent = (Intent)this.codec(Intent.class).decode(root, (CodecContext)this);
            service.submit(intent);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("intents").path(intent.appId().name()).path(Long.toString(intent.id().fingerprint()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{appId}/{key}")
    public Response deleteIntentById(@PathParam(value="appId") String appId, @PathParam(value="key") String key) {
        ApplicationId app = ((CoreService)this.get(CoreService.class)).getAppId(appId);
        Tools.nullIsNotFound((Object)app, (String)"Application Id not found");
        Intent intent = ((IntentService)this.get(IntentService.class)).getIntent(Key.of((String)key, (ApplicationId)app));
        IntentService service = (IntentService)this.get(IntentService.class);
        if (intent == null) {
            intent = service.getIntent(Key.of((long)Long.decode(key), (ApplicationId)app));
        }
        if (intent == null) {
            return Response.noContent().build();
        }
        Key k = intent.key();
        CountDownLatch latch = new CountDownLatch(1);
        DeleteListener listener = new DeleteListener(this, k, latch);
        service.addListener((EventListener)listener);
        try {
            service.withdraw(intent);
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.info("REST Delete operation timed out waiting for intent {}", (Object)k);
                Thread.currentThread().interrupt();
            }
            IntentState state = service.getIntentState(k);
            if (state == IntentState.WITHDRAWN || state == IntentState.FAILED) {
                service.purge(intent);
            }
        }
        finally {
            service.removeListener((EventListener)listener);
        }
        return Response.noContent().build();
    }
}

