/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.HexString;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="groups")
public class GroupsWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String DEVICE_INVALID = "Invalid deviceId in group creation request";
    private static final String GROUP_NOT_FOUND = "Group was not found";
    private final GroupService groupService = (GroupService)this.get(GroupService.class);
    private final ObjectNode root = this.mapper().createObjectNode();
    private final ArrayNode groupsNode = this.root.putArray("groups");

    @GET
    @Produces(value={"application/json"})
    public Response getGroups() {
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        devices.forEach(device -> {
            Iterable groups = this.groupService.getGroups(device.id());
            if (groups != null) {
                groups.forEach(group -> this.groupsNode.add((JsonNode)this.codec(Group.class).encode(group, (CodecContext)this)));
            }
        });
        return GroupsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}")
    public Response getGroupsByDeviceId(@PathParam(value="deviceId") String deviceId) {
        Iterable groups = this.groupService.getGroups(DeviceId.deviceId((String)deviceId));
        groups.forEach(group -> this.groupsNode.add((JsonNode)this.codec(Group.class).encode(group, (CodecContext)this)));
        return GroupsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/{appCookie}")
    public Response getGroupByDeviceIdAndAppCookie(@PathParam(value="deviceId") String deviceId, @PathParam(value="appCookie") String appCookie) {
        DeviceId deviceIdInstance = DeviceId.deviceId((String)deviceId);
        if (!appCookie.startsWith("0x")) {
            throw new IllegalArgumentException("APP_COOKIE must be a hex string starts with 0x");
        }
        DefaultGroupKey appCookieInstance = new DefaultGroupKey(HexString.fromHexString((String)appCookie.split("0x")[1], (String)""));
        Group group = (Group)Tools.nullIsNotFound((Object)this.groupService.getGroup(deviceIdInstance, (GroupKey)appCookieInstance), (String)"Group was not found");
        this.groupsNode.add((JsonNode)this.codec(Group.class).encode((Object)group, (CodecContext)this));
        return GroupsWebResource.ok((Object)this.root).build();
    }

    @POST
    @Path(value="{deviceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createGroup(@PathParam(value="deviceId") String deviceId, InputStream stream) {
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode specifiedDeviceId = jsonTree.get("deviceId");
            if (specifiedDeviceId != null && !specifiedDeviceId.asText().equals(deviceId)) {
                throw new IllegalArgumentException("Invalid deviceId in group creation request");
            }
            jsonTree.put("deviceId", deviceId);
            Group group = (Group)this.codec(Group.class).decode(jsonTree, (CodecContext)this);
            DefaultGroupDescription description = new DefaultGroupDescription(group.deviceId(), group.type(), group.buckets(), group.appCookie(), (Integer)group.id().id(), group.appId());
            this.groupService.addGroup((GroupDescription)description);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("groups").path(deviceId).path(Long.toString(((Integer)group.id().id()).intValue()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @DELETE
    @Path(value="{deviceId}/{appCookie}")
    public Response deleteGroupByDeviceIdAndAppCookie(@PathParam(value="deviceId") String deviceId, @PathParam(value="appCookie") String appCookie) {
        DeviceId deviceIdInstance = DeviceId.deviceId((String)deviceId);
        if (!appCookie.startsWith("0x")) {
            throw new IllegalArgumentException("APP_COOKIE must be a hex string starts with 0x");
        }
        DefaultGroupKey appCookieInstance = new DefaultGroupKey(HexString.fromHexString((String)appCookie.split("0x")[1], (String)""));
        this.groupService.removeGroup(deviceIdInstance, (GroupKey)appCookieInstance, null);
        return Response.noContent().build();
    }
}

