/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyAdminService;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="keys")
public class DeviceKeyWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String DEVICE_KEY_NOT_FOUND = "Device key was not found";

    @GET
    @Produces(value={"application/json"})
    public Response getDeviceKeys() {
        Collection deviceKeys = ((DeviceKeyService)this.get(DeviceKeyService.class)).getDeviceKeys();
        return DeviceKeyWebResource.ok((Object)this.encodeArray(DeviceKey.class, "keys", (Iterable)deviceKeys)).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getDeviceKey(@PathParam(value="id") String id) {
        DeviceKey deviceKey = (DeviceKey)Tools.nullIsNotFound((Object)((DeviceKeyService)this.get(DeviceKeyService.class)).getDeviceKey(DeviceKeyId.deviceKeyId((String)id)), (String)"Device key was not found");
        return DeviceKeyWebResource.ok((Object)this.codec(DeviceKey.class).encode((Object)deviceKey, (CodecContext)this)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDeviceKey(InputStream stream) {
        try {
            DeviceKeyAdminService service = (DeviceKeyAdminService)this.get(DeviceKeyAdminService.class);
            ObjectNode root = (ObjectNode)this.mapper().readTree(stream);
            DeviceKey deviceKey = (DeviceKey)this.codec(DeviceKey.class).decode(root, (CodecContext)this);
            service.addKey(deviceKey);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("keys").path((String)deviceKey.deviceKeyId().id());
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response removeDeviceKey(@PathParam(value="id") String id) {
        DeviceKey deviceKey = (DeviceKey)Tools.nullIsNotFound((Object)((DeviceKeyService)this.get(DeviceKeyService.class)).getDeviceKey(DeviceKeyId.deviceKeyId((String)id)), (String)"Device key was not found");
        ((DeviceKeyAdminService)this.get(DeviceKeyAdminService.class)).removeKey(DeviceKeyId.deviceKeyId((String)id));
        return DeviceKeyWebResource.ok((Object)this.codec(DeviceKey.class).encode((Object)deviceKey, (CodecContext)this)).build();
    }
}

