/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cfg.ConfigProperty;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="configuration")
public class ComponentConfigWebResource
extends AbstractWebResource {
    private static final int MULTI_STATUS_RESPONE = 207;

    @GET
    @Produces(value={"application/json"})
    public Response getComponentConfigs() {
        ComponentConfigService service = (ComponentConfigService)this.get(ComponentConfigService.class);
        Set components = service.getComponentNames();
        ObjectNode root = this.mapper().createObjectNode();
        components.forEach(c -> this.encodeConfigs(c, service.getProperties(c), root));
        return ComponentConfigWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="{component}")
    @Produces(value={"application/json"})
    public Response getComponentConfigs(@PathParam(value="component") String component) {
        ComponentConfigService service = (ComponentConfigService)this.get(ComponentConfigService.class);
        ObjectNode root = this.mapper().createObjectNode();
        this.encodeConfigs(component, (Set)Tools.nullIsNotFound((Object)service.getProperties(component), (String)"No such component"), root);
        return ComponentConfigWebResource.ok((Object)root).build();
    }

    private void encodeConfigs(String component, Set<ConfigProperty> props, ObjectNode node) {
        ObjectNode compNode = this.mapper().createObjectNode();
        node.set(component, (JsonNode)compNode);
        props.forEach(p -> compNode.put(p.name(), p.value()));
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{component}")
    public Response setConfigs(@PathParam(value="component") String component, @DefaultValue(value="false") @QueryParam(value="preset") boolean preset, InputStream request) throws IOException {
        ComponentConfigService service = (ComponentConfigService)this.get(ComponentConfigService.class);
        ObjectNode props = (ObjectNode)this.mapper().readTree(request);
        ArrayList errorMsgs = new ArrayList();
        if (preset) {
            props.fieldNames().forEachRemaining(k -> {
                try {
                    service.preSetProperty(component, k, props.path(k).asText());
                }
                catch (IllegalArgumentException e) {
                    errorMsgs.add(e.getMessage());
                }
            });
        } else {
            props.fieldNames().forEachRemaining(k -> {
                try {
                    service.setProperty(component, k, props.path(k).asText());
                }
                catch (IllegalArgumentException e) {
                    errorMsgs.add(e.getMessage());
                }
            });
        }
        if (!errorMsgs.isEmpty()) {
            return Response.status((int)207).entity((Object)this.produceErrorJson(errorMsgs)).build();
        }
        return Response.ok().build();
    }

    private ObjectNode produceErrorJson(List<String> errorMsgs) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode().put("code", 207).putPOJO("message", errorMsgs);
        return result;
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="{component}")
    public Response unsetConfigs(@PathParam(value="component") String component, InputStream request) throws IOException {
        ComponentConfigService service = (ComponentConfigService)this.get(ComponentConfigService.class);
        ObjectNode props = (ObjectNode)this.mapper().readTree(request);
        props.fieldNames().forEachRemaining(k -> service.unsetProperty(component, k));
        return Response.noContent().build();
    }
}

