/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulLspErrorCodeTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(StatefulLspErrorCodeTlv.class);
    public static final short TYPE = 20;
    public static final short LENGTH = 4;
    private final int rawValue;

    public StatefulLspErrorCodeTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static StatefulLspErrorCodeTlv of(int raw) {
        return new StatefulLspErrorCodeTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getLength() {
        return 4;
    }

    @Override
    public short getType() {
        return 20;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatefulLspErrorCodeTlv) {
            StatefulLspErrorCodeTlv other = (StatefulLspErrorCodeTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(20);
        c.writeShort(4);
        c.writeInt(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static StatefulLspErrorCodeTlv read(ChannelBuffer c) {
        return StatefulLspErrorCodeTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 20).add("Length", 4).add("Value", this.rawValue).toString();
    }
}

