/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrPceCapabilityTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(SrPceCapabilityTlv.class);
    public static final short TYPE = 26;
    public static final short LENGTH = 4;
    private final byte msd;

    public SrPceCapabilityTlv(byte msd) {
        this.msd = msd;
    }

    public static SrPceCapabilityTlv of(byte msd) {
        return new SrPceCapabilityTlv(msd);
    }

    public byte msd() {
        return this.msd;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 26;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.msd);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SrPceCapabilityTlv) {
            SrPceCapabilityTlv other = (SrPceCapabilityTlv)obj;
            return Objects.equals(this.msd, other.msd);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(26);
        c.writeShort(4);
        c.writeInt((int)this.msd);
        return c.writerIndex() - iLenStartIndex;
    }

    public static SrPceCapabilityTlv read(ChannelBuffer cb) {
        cb.readShort();
        cb.readByte();
        return SrPceCapabilityTlv.of(cb.readByte());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 26).add("Length", 4).add("msd", (int)this.msd).toString();
    }
}

