/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingUniverseTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(RoutingUniverseTlv.class);
    public static final short TYPE = -255;
    public static final short LENGTH = 8;
    private final long rawValue;

    public RoutingUniverseTlv(long rawValue) {
        this.rawValue = rawValue;
    }

    public static RoutingUniverseTlv of(long raw) {
        return new RoutingUniverseTlv(raw);
    }

    public long getLong() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -255;
    }

    @Override
    public short getLength() {
        return 8;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RoutingUniverseTlv) {
            RoutingUniverseTlv other = (RoutingUniverseTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(-255);
        c.writeShort(8);
        c.writeLong(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static RoutingUniverseTlv read(ChannelBuffer c) {
        return RoutingUniverseTlv.of(c.readLong());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -255).add("Length", 8).add("Value", this.rawValue).toString();
    }
}

