/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepNai;

public class PcepNaiIpv4Adjacency
implements PcepNai {
    public static final byte ST_TYPE = 3;
    private final int localIpv4Addr;
    private final int remoteIpv4Addr;

    public PcepNaiIpv4Adjacency(int localIpv4, int remoteIpv4) {
        this.localIpv4Addr = localIpv4;
        this.remoteIpv4Addr = remoteIpv4;
    }

    public static PcepNaiIpv4Adjacency of(int localIpv4Addr, int remoteIpv4Addr) {
        return new PcepNaiIpv4Adjacency(localIpv4Addr, remoteIpv4Addr);
    }

    @Override
    public byte getType() {
        return 3;
    }

    public int getLocalIpv4Addr() {
        return this.localIpv4Addr;
    }

    public int getRemoteIpv4Addr() {
        return this.remoteIpv4Addr;
    }

    @Override
    public int write(ChannelBuffer bb) {
        int iLenStartIndex = bb.writerIndex();
        bb.writeInt(this.localIpv4Addr);
        bb.writeInt(this.remoteIpv4Addr);
        return bb.writerIndex() - iLenStartIndex;
    }

    public static PcepNaiIpv4Adjacency read(ChannelBuffer cb) {
        int localIpv4 = cb.readInt();
        int remoteIpv4 = cb.readInt();
        return new PcepNaiIpv4Adjacency(localIpv4, remoteIpv4);
    }

    public int hashCode() {
        return Objects.hash(this.localIpv4Addr, this.remoteIpv4Addr);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PcepNaiIpv4Adjacency) {
            PcepNaiIpv4Adjacency other = (PcepNaiIpv4Adjacency)obj;
            return Objects.equals(this.localIpv4Addr, other.localIpv4Addr) && Objects.equals(this.remoteIpv4Addr, other.remoteIpv4Addr);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localIPv4Address", this.localIpv4Addr).add("remoteIPv4Address", this.remoteIpv4Addr).toString();
    }
}

