/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PceccCapabilityTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(PceccCapabilityTlv.class);
    public static final short TYPE = -249;
    public static final short LENGTH = 4;
    public static final int SET = 1;
    public static final byte SBIT_CHECK = 1;
    private final boolean sBit;
    private final int rawValue;
    private final boolean isRawValueSet;

    public PceccCapabilityTlv(int rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        this.sBit = (rawValue & 1) == 1;
    }

    public PceccCapabilityTlv(boolean sBit) {
        this.sBit = sBit;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public static PceccCapabilityTlv of(int raw) {
        return new PceccCapabilityTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public boolean sBit() {
        return this.sBit;
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getType() {
        return -249;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.sBit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PceccCapabilityTlv) {
            PceccCapabilityTlv other = (PceccCapabilityTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.sBit, other.sBit);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        int temp = 0;
        c.writeShort(-249);
        c.writeShort(4);
        if (this.isRawValueSet) {
            c.writeInt(this.rawValue);
        } else {
            if (this.sBit) {
                temp |= 1;
            }
            c.writeInt(temp);
        }
        return c.writerIndex() - iLenStartIndex;
    }

    public static PceccCapabilityTlv read(ChannelBuffer c) {
        return PceccCapabilityTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -249).add("Length", 4).add("rawValue", this.rawValue).toString();
    }
}

