/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathSetupTypeTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(PathSetupTypeTlv.class);
    public static final short TYPE = 28;
    public static final short LENGTH = 4;
    private final byte pst;
    private final int rawValue;
    private final boolean isRawValueSet;

    public PathSetupTypeTlv(int rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        this.pst = (byte)rawValue;
    }

    public PathSetupTypeTlv(byte pst) {
        this.pst = pst;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public static PathSetupTypeTlv of(int raw) {
        return new PathSetupTypeTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public int getInt() {
        return this.rawValue;
    }

    public byte getPst() {
        return this.pst;
    }

    @Override
    public short getType() {
        return 28;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.pst);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathSetupTypeTlv) {
            PathSetupTypeTlv other = (PathSetupTypeTlv)obj;
            return Objects.equals(this.pst, other.pst);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(28);
        c.writeShort(4);
        c.writeInt((int)this.pst);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PathSetupTypeTlv read(ChannelBuffer c) {
        return PathSetupTypeTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 28).add("Length", 4).add("PST", (int)this.pst).toString();
    }
}

