/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.IPv4RouterIdOfLocalNodeSubTlv;
import org.onosproject.pcepio.types.IPv6RouterIdofLocalNodeSubTlv;
import org.onosproject.pcepio.types.IsisAreaIdentifierSubTlv;
import org.onosproject.pcepio.types.NodeFlagBitsSubTlv;
import org.onosproject.pcepio.types.NodeNameSubTlv;
import org.onosproject.pcepio.types.OpaqueNodePropertiesSubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAttributesTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(NodeAttributesTlv.class);
    public static final short TYPE = -251;
    short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private List<PcepValueType> llNodeAttributesSubTLVs;

    public NodeAttributesTlv(List<PcepValueType> llNodeAttributesSubTLVs) {
        this.llNodeAttributesSubTLVs = llNodeAttributesSubTLVs;
    }

    public static NodeAttributesTlv of(List<PcepValueType> llNodeAttributesSubTLVs) {
        return new NodeAttributesTlv(llNodeAttributesSubTLVs);
    }

    public List<PcepValueType> getllNodeAttributesSubTLVs() {
        return this.llNodeAttributesSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -251;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llNodeAttributesSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeAttributesTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            NodeAttributesTlv other = (NodeAttributesTlv)obj;
            Iterator<PcepValueType> objListIterator = ((NodeAttributesTlv)obj).llNodeAttributesSubTLVs.iterator();
            countObjSubTlv = ((NodeAttributesTlv)obj).llNodeAttributesSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llNodeAttributesSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llNodeAttributesSubTLVs.contains(subTlv), other.llNodeAttributesSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(-251);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator<PcepValueType> listIterator = this.llNodeAttributesSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = listIterator.next();
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) throws PcepParseException {
        LinkedList<PcepValueType> llNodeAttributesSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)hLength);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short length = tempCb.readShort();
            switch (hType) {
                case 13: {
                    byte cValue = tempCb.readByte();
                    tlv = new NodeFlagBitsSubTlv(cValue);
                    break;
                }
                case 14: {
                    tlv = OpaqueNodePropertiesSubTlv.read(tempCb, length);
                    break;
                }
                case 15: {
                    tlv = NodeNameSubTlv.read(tempCb, length);
                    break;
                }
                case 16: {
                    tlv = IsisAreaIdentifierSubTlv.read(tempCb, length);
                    break;
                }
                case 17: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4RouterIdOfLocalNodeSubTlv(iValue);
                    break;
                }
                case 18: {
                    byte[] ipv6Value = new byte[18];
                    tempCb.readBytes(ipv6Value, 0, 18);
                    tlv = new IPv6RouterIdofLocalNodeSubTlv(ipv6Value);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = length % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llNodeAttributesSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new NodeAttributesTlv(llNodeAttributesSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -251).add("Length", (int)this.hLength).add("NodeAttributesSubTLVs", this.llNodeAttributesSubTLVs).toString();
    }
}

